/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.stairs;

import com.copycatsplus.copycats.CCBlockEntityTypes;
import com.copycatsplus.copycats.CCBlockStateProperties;
import com.copycatsplus.copycats.CCBlocks;
import com.copycatsplus.copycats.content.copycat.vertical_stairs.CopycatVerticalStairBlock;
import com.copycatsplus.copycats.foundation.copycat.CCCopycatBlockEntity;
import com.copycatsplus.copycats.foundation.copycat.ICopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.ICustomCTBlocking;
import com.copycatsplus.copycats.foundation.copycat.IStateType;
import com.copycatsplus.copycats.utility.BackportUtils;
import com.copycatsplus.copycats.utility.BlockUtils;
import com.copycatsplus.copycats.utility.InteractionUtils;
import com.mojang.math.OctahedralGroup;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.foundation.block.IBE;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.BlockHitResult;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CopycatStairsBlock
extends StairBlock
implements ICopycatBlock,
IBE<CCCopycatBlockEntity>,
ICustomCTBlocking,
IStateType {
    public CopycatStairsBlock(BlockBehaviour.Properties properties) {
        super(Blocks.f_50705_.m_49966_(), properties);
    }

    @Nullable
    public <S extends BlockEntity> BlockEntityTicker<S> m_142354_(Level level, BlockState state, BlockEntityType<S> type) {
        return null;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return InteractionUtils.sequential(() -> ICopycatBlock.super.m_6227_(state, level, pos, player, hand, hit), () -> super.m_6227_(state, level, pos, player, hand, hit));
    }

    @Override
    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        ICopycatBlock.super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        ICopycatBlock.super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving, (x$0, x$1, x$2, x$3, x$4) -> super.m_6810_(x$0, x$1, x$2, x$3, x$4));
    }

    @Override
    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        ICopycatBlock.super.m_5707_(pLevel, pPos, pState, pPlayer);
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    public Class<CCCopycatBlockEntity> getBlockEntityClass() {
        return CCCopycatBlockEntity.class;
    }

    public BlockEntityType<? extends CCCopycatBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CCBlockEntityTypes.COPYCAT.get();
    }

    @Override
    public boolean isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState state, Direction face, BlockPos fromPos, BlockPos toPos) {
        boolean flipped = state.m_61143_((Property)f_56842_) == Half.TOP;
        Direction facing = (Direction)state.m_61143_((Property)StairBlock.f_56841_);
        BlockState toState = reader.m_8055_(toPos);
        BlockPos diff = toPos.m_141950_((Vec3i)fromPos);
        if (diff.equals((Object)Vec3i.f_123288_)) {
            return true;
        }
        if (CopycatVerticalStairBlock.isStairs(toState)) {
            return false;
        }
        if (diff.m_123342_() == 0) {
            FaceShape faceShape;
            StairsShape shape = (StairsShape)state.m_61143_((Property)f_56843_);
            int fullCount = 0;
            if (diff.m_123341_() != 0) {
                faceShape = CopycatStairsBlock.getFaceShape(state, Direction.m_122387_((Direction.Axis)Direction.Axis.X, (Direction.AxisDirection)CopycatStairsBlock.directionOf(diff.m_123341_())));
                if (faceShape.isFull()) {
                    ++fullCount;
                } else if ((shape == StairsShape.OUTER_LEFT || shape == StairsShape.OUTER_RIGHT) && diff.m_123343_() != 0 && (diff.m_123341_() > 0 && faceShape.topNegative && faceShape.bottomNegative || diff.m_123341_() < 0 && faceShape.topPositive && faceShape.bottomPositive)) {
                    ++fullCount;
                }
            }
            if (diff.m_123343_() != 0) {
                faceShape = CopycatStairsBlock.getFaceShape(state, Direction.m_122387_((Direction.Axis)Direction.Axis.Z, (Direction.AxisDirection)CopycatStairsBlock.directionOf(diff.m_123343_())));
                if (faceShape.isFull()) {
                    ++fullCount;
                } else if ((shape == StairsShape.OUTER_LEFT || shape == StairsShape.OUTER_RIGHT) && diff.m_123341_() != 0 && (diff.m_123343_() > 0 && faceShape.topNegative && faceShape.bottomNegative || diff.m_123343_() < 0 && faceShape.topPositive && faceShape.bottomPositive)) {
                    ++fullCount;
                }
            }
            return fullCount < Mth.m_14040_((int)diff.m_123341_()) + Mth.m_14040_((int)diff.m_123343_());
        }
        return diff.m_123342_() > 0 != flipped;
    }

    @Override
    public boolean canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        BlockState toState = reader.m_8055_(toPos);
        BlockPos diff = toPos.m_141950_((Vec3i)fromPos);
        if (diff.equals((Object)Vec3i.f_123288_)) {
            return true;
        }
        Direction side = BackportUtils.directionFromDelta(diff.m_123341_(), diff.m_123342_(), diff.m_123343_());
        if (side != null) {
            FaceShape sideShape = CopycatStairsBlock.getFaceShape(state, side);
            if (!sideShape.canConnect()) {
                return false;
            }
            if (CopycatVerticalStairBlock.isStairs(toState) ? !sideShape.equals(CopycatStairsBlock.getFaceShape(toState, side.m_122424_())) : !sideShape.isFull()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Optional<Boolean> isCTBlocked(BlockAndTintGetter reader, BlockState state, BlockPos pos, BlockPos connectingPos, BlockPos blockingPos, Direction face) {
        return ((CopycatVerticalStairBlock)CCBlocks.COPYCAT_VERTICAL_STAIRS.get()).isCTBlocked(reader, state, pos, connectingPos, blockingPos, face);
    }

    @Override
    public Optional<Boolean> blockCTTowards(BlockAndTintGetter reader, BlockState state, BlockPos pos, BlockPos ctPos, BlockPos connectingPos, Direction face) {
        return ((CopycatVerticalStairBlock)CCBlocks.COPYCAT_VERTICAL_STAIRS.get()).blockCTTowards(reader, state, pos, ctPos, connectingPos, face);
    }

    @Override
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return ICopycatBlock.super.m_6843_(state, rotation);
    }

    @Override
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return ICopycatBlock.super.m_6943_(state, mirror);
    }

    @Override
    public BlockState transform(BlockState state, StructureTransform transform) {
        if (transform.mirror != null && transform.mirror != Mirror.NONE) {
            state = transform.mirror.m_54842_() == OctahedralGroup.INVERT_Y ? (BlockState)state.m_61122_((Property)f_56842_) : (BlockState)state.m_61124_((Property)f_56841_, (Comparable)transform.mirror.m_54848_((Direction)state.m_61143_((Property)f_56841_)));
        }
        if (transform.rotationAxis != null) {
            if (transform.rotationAxis == Direction.Axis.Y) {
                state = (BlockState)state.m_61124_((Property)f_56841_, (Comparable)transform.rotateFacing((Direction)state.m_61143_((Property)f_56841_)));
            } else {
                Direction facing = (Direction)state.m_61143_((Property)f_56841_);
                Half half = (Half)state.m_61143_((Property)f_56842_);
                if (transform.rotationAxis == facing.m_122434_()) {
                    if (transform.rotation == Rotation.CLOCKWISE_180) {
                        state = (BlockState)state.m_61122_((Property)f_56842_);
                    } else if (transform.rotation != Rotation.NONE) {
                        Direction offset = transform.rotateFacing(half == Half.TOP ? Direction.UP : Direction.DOWN);
                        state = (BlockState)((BlockState)BlockUtils.tryCopyProperties(state, CCBlocks.COPYCAT_VERTICAL_STAIRS.getDefaultState()).m_61124_((Property)f_56841_, (Comparable)offset)).m_61124_(CCBlockStateProperties.SIDE, (Comparable)((Object)(offset == facing.m_122427_() ? CCBlockStateProperties.Side.LEFT : CCBlockStateProperties.Side.RIGHT)));
                    }
                } else {
                    state = BlockUtils.setApparentDirection(state, transform.rotateFacing(BlockUtils.getApparentDirection(state)));
                }
            }
        }
        return state;
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    @Override
    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        return ICopycatBlock.hidesNeighborFace(level, pos, state, neighborState, dir);
    }

    private static Direction.AxisDirection directionOf(int value) {
        return value >= 0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
    }

    public static FaceShape getFaceShape(BlockState state, Direction face) {
        if (state.m_60734_() instanceof CopycatVerticalStairBlock) {
            return CopycatVerticalStairBlock.getFaceShape(state, face);
        }
        boolean top = state.m_61143_((Property)StairBlock.f_56842_) == Half.TOP;
        Direction facing = (Direction)state.m_61143_((Property)StairBlock.f_56841_);
        StairsShape shape = (StairsShape)state.m_61143_((Property)StairBlock.f_56843_);
        if (!top && face == Direction.DOWN) {
            return new FaceShape().fillAll();
        }
        if (top && face == Direction.UP) {
            return new FaceShape().fillAll();
        }
        FaceShape faceShape = new FaceShape();
        switch (shape) {
            case STRAIGHT: {
                if (!top && face == Direction.UP || top && face == Direction.DOWN) {
                    return faceShape.fillTop().rotate(facing.m_122435_());
                }
                faceShape.fillRow(top);
                if (face == facing) {
                    return faceShape.fillRow(!top);
                }
                if (face == facing.m_122424_()) {
                    return faceShape;
                }
                return faceShape.fillRow(!top, facing.m_122421_());
            }
            case INNER_LEFT: {
                if (!top && face == Direction.UP || top && face == Direction.DOWN) {
                    return faceShape.fillTop().fillBottom(Direction.AxisDirection.POSITIVE).rotate(facing.m_122435_());
                }
                faceShape.fillRow(top);
                if (face == facing) {
                    return faceShape.fillRow(!top);
                }
                if (face == facing.m_122424_()) {
                    return faceShape.fillRow(!top, facing.m_122428_().m_122421_());
                }
                if (face == facing.m_122428_()) {
                    return faceShape.fillRow(!top);
                }
                if (face != facing.m_122427_()) break;
                return faceShape.fillRow(!top, facing.m_122421_());
            }
            case INNER_RIGHT: {
                if (!top && face == Direction.UP || top && face == Direction.DOWN) {
                    return faceShape.fillTop().fillBottom(Direction.AxisDirection.NEGATIVE).rotate(facing.m_122435_());
                }
                faceShape.fillRow(top);
                if (face == facing) {
                    return faceShape.fillRow(!top);
                }
                if (face == facing.m_122424_()) {
                    return faceShape.fillRow(!top, facing.m_122427_().m_122421_());
                }
                if (face == facing.m_122427_()) {
                    return faceShape.fillRow(!top);
                }
                if (face != facing.m_122428_()) break;
                return faceShape.fillRow(!top, facing.m_122421_());
            }
            case OUTER_LEFT: {
                if (!top && face == Direction.UP || top && face == Direction.DOWN) {
                    return faceShape.fillTop(Direction.AxisDirection.POSITIVE).rotate(facing.m_122435_());
                }
                faceShape.fillRow(top);
                if (face == facing) {
                    return faceShape.fillRow(!top, facing.m_122428_().m_122421_());
                }
                if (face == facing.m_122424_()) {
                    return faceShape;
                }
                if (face == facing.m_122428_()) {
                    return faceShape.fillRow(!top, facing.m_122421_());
                }
                if (face != facing.m_122427_()) break;
                return faceShape;
            }
            case OUTER_RIGHT: {
                if (!top && face == Direction.UP || top && face == Direction.DOWN) {
                    return faceShape.fillTop(Direction.AxisDirection.NEGATIVE).rotate(facing.m_122435_());
                }
                faceShape.fillRow(top);
                if (face == facing) {
                    return faceShape.fillRow(!top, facing.m_122427_().m_122421_());
                }
                if (face == facing.m_122424_()) {
                    return faceShape;
                }
                if (face == facing.m_122427_()) {
                    return faceShape.fillRow(!top, facing.m_122421_());
                }
                if (face != facing.m_122428_()) break;
                return faceShape;
            }
        }
        return faceShape;
    }

    public static class FaceShape {
        public boolean topNegative;
        public boolean topPositive;
        public boolean bottomNegative;
        public boolean bottomPositive;

        public FaceShape fillTop() {
            this.topPositive = true;
            this.topNegative = true;
            return this;
        }

        public FaceShape fillColumn(Direction.AxisDirection direction) {
            switch (direction) {
                case POSITIVE: {
                    this.bottomPositive = true;
                    this.topPositive = true;
                    break;
                }
                case NEGATIVE: {
                    this.bottomNegative = true;
                    this.topNegative = true;
                }
            }
            return this;
        }

        public FaceShape fillNegative() {
            this.bottomNegative = true;
            this.topNegative = true;
            return this;
        }

        public FaceShape fillPositive() {
            this.bottomPositive = true;
            this.topPositive = true;
            return this;
        }

        public FaceShape fillLeft(Direction relativeTo) {
            return this.fillColumn(relativeTo.m_122427_().m_122421_());
        }

        public FaceShape fillRight(Direction relativeTo) {
            return this.fillColumn(relativeTo.m_122428_().m_122421_());
        }

        public FaceShape fillTop(Direction.AxisDirection direction) {
            switch (direction) {
                case POSITIVE: {
                    this.topPositive = true;
                    break;
                }
                case NEGATIVE: {
                    this.topNegative = true;
                }
            }
            return this;
        }

        public FaceShape fillBottom() {
            this.bottomPositive = true;
            this.bottomNegative = true;
            return this;
        }

        public FaceShape fillBottom(Direction.AxisDirection direction) {
            switch (direction) {
                case POSITIVE: {
                    this.bottomPositive = true;
                    break;
                }
                case NEGATIVE: {
                    this.bottomNegative = true;
                }
            }
            return this;
        }

        public FaceShape fillRow(boolean top) {
            if (top) {
                return this.fillTop();
            }
            return this.fillBottom();
        }

        public FaceShape fillRow(boolean top, Direction.AxisDirection direction) {
            if (top) {
                return this.fillTop(direction);
            }
            return this.fillBottom(direction);
        }

        public FaceShape fillAll() {
            return this.fillTop().fillBottom();
        }

        public FaceShape rotate(float angle) {
            return this.rotate((int)angle);
        }

        public FaceShape rotate(int angle) {
            if ((angle %= 360) < 0) {
                angle += 360;
            }
            return switch (angle) {
                case 90 -> this.set(this.topNegative, this.bottomNegative, this.topPositive, this.bottomPositive);
                case 180 -> this.set(this.topPositive, this.topNegative, this.bottomPositive, this.bottomNegative);
                case 270 -> this.set(this.bottomPositive, this.topPositive, this.bottomNegative, this.topNegative);
                default -> this;
            };
        }

        public FaceShape set(boolean bottomNegative, boolean bottomPositive, boolean topNegative, boolean topPositive) {
            this.bottomNegative = bottomNegative;
            this.bottomPositive = bottomPositive;
            this.topNegative = topNegative;
            this.topPositive = topPositive;
            return this;
        }

        public int countBlocks() {
            int count = 0;
            if (this.bottomNegative) {
                ++count;
            }
            if (this.bottomPositive) {
                ++count;
            }
            if (this.topNegative) {
                ++count;
            }
            if (this.topPositive) {
                ++count;
            }
            return count;
        }

        public boolean canConnect() {
            return this.countBlocks() >= 3;
        }

        public boolean isFull() {
            return this.countBlocks() == 4;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof FaceShape)) {
                return false;
            }
            FaceShape shape = (FaceShape)obj;
            return shape.bottomNegative == this.bottomNegative && shape.bottomPositive == this.bottomPositive && shape.topNegative == this.topNegative && shape.topPositive == this.topPositive;
        }
    }
}

