/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.forge.mixin.foundation.copycat.multistate;

import com.copycatsplus.copycats.content.copycat.cogwheel.CopycatCogWheelBlock;
import com.copycatsplus.copycats.foundation.copycat.ICopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlockEntity;
import com.copycatsplus.copycats.foundation.copycat.multistate.MaterialItemStorage;
import com.copycatsplus.copycats.foundation.copycat.multistate.MultiStateCopycatBlock;
import com.copycatsplus.copycats.utility.BlockEntityUtils;
import com.simibubi.create.AllBlocks;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.extensions.IForgeBlock;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;

@Mixin(value={MultiStateCopycatBlock.class, CopycatCogWheelBlock.class})
@Pseudo
public abstract class MultiStateCopycatBlockMixin
extends Block
implements IForgeBlock,
IMultiStateCopycatBlock {
    public MultiStateCopycatBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        Block block = state.m_60734_();
        if (block instanceof IMultiStateCopycatBlock) {
            IMultiStateCopycatBlock copycatBlock = (IMultiStateCopycatBlock)block;
            IMultiStateCopycatBlockEntity copycatBE = copycatBlock.getCopycatBlockEntity((BlockGetter)level, pos);
            if (copycatBE == null) {
                return super.getSoundType(state, level, pos, entity);
            }
            for (MaterialItemStorage.MaterialItem materialItem : copycatBE.getMaterialItemStorage().getAllMaterialItems()) {
                if (!materialItem.hasCustomMaterial()) continue;
                return materialItem.material().getSoundType(level, pos, entity);
            }
            return ICopycatBlock.getMaterial((BlockGetter)level, pos).getSoundType(level, pos, entity);
        }
        return super.getSoundType(state, level, pos, entity);
    }

    public float getFriction(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        Block block = state.m_60734_();
        if (block instanceof IMultiStateCopycatBlock) {
            IMultiStateCopycatBlock copycatBlock = (IMultiStateCopycatBlock)block;
            float bonus = 0.0f;
            int count = 0;
            IMultiStateCopycatBlockEntity copycatBE = copycatBlock.getCopycatBlockEntity((BlockGetter)level, pos);
            if (copycatBE == null) {
                return super.getFriction(state, level, pos, entity);
            }
            for (String property : copycatBE.getMaterialItemStorage().getAllProperties()) {
                if (!copycatBlock.partExists(state, property)) continue;
                BlockState mat = copycatBE.getMaterialItemStorage().getMaterialItem(property).material();
                ++count;
                bonus += mat.m_60713_(Blocks.f_50016_) ? super.getFriction(state, level, pos, entity) : mat.getFriction(level, pos, entity);
            }
            return bonus / (float)count;
        }
        return super.getFriction(state, level, pos, entity);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        Block block = state.m_60734_();
        if (block instanceof IMultiStateCopycatBlock) {
            IMultiStateCopycatBlock copycatBlock = (IMultiStateCopycatBlock)block;
            AtomicInteger light = new AtomicInteger(0);
            BlockEntity be = BlockEntityUtils.getBlockEntityCrossThread(level, pos);
            if (!(be instanceof IMultiStateCopycatBlockEntity)) {
                return super.getLightEmission(state, level, pos);
            }
            IMultiStateCopycatBlockEntity copycatBE = (IMultiStateCopycatBlockEntity)be;
            copycatBE.getMaterialItemStorage().getAllMaterials().forEach(bs -> light.accumulateAndGet(bs.m_60791_(), Math::max));
            return light.get();
        }
        return super.getLightEmission(state, level, pos);
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        Block block = state.m_60734_();
        if (block instanceof IMultiStateCopycatBlock) {
            IMultiStateCopycatBlock copycatBlock = (IMultiStateCopycatBlock)block;
            AtomicReference<Float> explosionResistance = new AtomicReference<Float>(Float.valueOf(state.m_60734_().m_7325_()));
            IMultiStateCopycatBlockEntity copycatBE = copycatBlock.getCopycatBlockEntity(level, pos);
            if (copycatBE == null) {
                return super.getExplosionResistance(state, level, pos, explosion);
            }
            copycatBE.getMaterialItemStorage().getAllMaterials().forEach(bs -> explosionResistance.accumulateAndGet(Float.valueOf(bs.m_60734_().m_7325_()), Math::max));
            return explosionResistance.get().floatValue();
        }
        return super.getExplosionResistance(state, level, pos, explosion);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        BlockState material;
        String string;
        if (target == null) {
            string = null;
        } else {
            Direction direction;
            Vec3 vec3 = target.m_82450_();
            if (target instanceof BlockHitResult) {
                BlockHitResult blockHit = (BlockHitResult)target;
                direction = blockHit.m_82434_();
            } else {
                direction = Direction.UP;
            }
            string = this.getPropertyFromInteraction(state, level, pos, vec3, direction, true);
        }
        String property = string;
        BlockState blockState = material = property == null ? ICopycatBlock.getMaterial(level, pos) : IMultiStateCopycatBlock.getMaterial(level, pos, property);
        if (AllBlocks.COPYCAT_BASE.has(material) || player != null && player.m_20161_()) {
            return new ItemStack((ItemLike)this);
        }
        return material.m_60734_().m_7397_(level, pos, material);
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        Block block = state1.m_60734_();
        if (block instanceof IMultiStateCopycatBlock) {
            IMultiStateCopycatBlock copycatBlock = (IMultiStateCopycatBlock)block;
            BlockHitResult hitResult = level.m_45547_(new ClipContext(entity.m_20182_(), entity.m_20182_().m_82520_(0.0, -2.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)entity));
            String property = copycatBlock.getPropertyFromInteraction(state1, (BlockGetter)level, pos, hitResult, true);
            IMultiStateCopycatBlockEntity copycatBE = copycatBlock.getCopycatBlockEntity((BlockGetter)level, pos);
            if (copycatBE == null) {
                return super.addLandingEffects(state1, level, pos, state2, entity, numberOfParticles);
            }
            BlockState material = copycatBE.getMaterialItemStorage().getMaterialItem(property).material();
            return material.addLandingEffects(level, pos, material, entity, numberOfParticles);
        }
        return super.addLandingEffects(state1, level, pos, state2, entity, numberOfParticles);
    }

    public boolean addRunningEffects(BlockState state, Level level, BlockPos pos, Entity entity) {
        Block block = state.m_60734_();
        if (block instanceof IMultiStateCopycatBlock) {
            IMultiStateCopycatBlock copycatBlock = (IMultiStateCopycatBlock)block;
            BlockHitResult hitResult = level.m_45547_(new ClipContext(entity.m_20182_(), entity.m_20182_().m_82520_(0.0, -2.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, entity));
            String property = copycatBlock.getPropertyFromInteraction(state, (BlockGetter)level, pos, hitResult, true);
            IMultiStateCopycatBlockEntity copycatBE = copycatBlock.getCopycatBlockEntity((BlockGetter)level, pos);
            if (copycatBE == null) {
                return super.addRunningEffects(state, level, pos, entity);
            }
            BlockState material = copycatBE.getMaterialItemStorage().getMaterialItem(property).material();
            return material.addRunningEffects(level, pos, entity);
        }
        return super.addRunningEffects(state, level, pos, entity);
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader level, BlockPos pos) {
        Block block = state.m_60734_();
        if (block instanceof IMultiStateCopycatBlock) {
            IMultiStateCopycatBlock copycatBlock = (IMultiStateCopycatBlock)block;
            AtomicReference<Float> bonus = new AtomicReference<Float>(Float.valueOf(0.0f));
            IMultiStateCopycatBlockEntity copycatBE = copycatBlock.getCopycatBlockEntity((BlockGetter)level, pos);
            if (copycatBE == null) {
                return super.getEnchantPowerBonus(state, level, pos);
            }
            copycatBE.getMaterialItemStorage().getAllMaterials().forEach(mat -> bonus.accumulateAndGet(Float.valueOf(mat.getEnchantPowerBonus(level, pos)), Float::max));
            return bonus.get().floatValue();
        }
        return super.getEnchantPowerBonus(state, level, pos);
    }

    public boolean isValidSpawn(BlockState state, BlockGetter level, BlockPos pos, SpawnPlacements.Type type, EntityType<?> entityType) {
        return false;
    }

    public void m_142072_(@NotNull Level pLevel, @NotNull BlockState state, @NotNull BlockPos pPos, @NotNull Entity pEntity, float p_152430_) {
        Block block = state.m_60734_();
        if (block instanceof IMultiStateCopycatBlock) {
            IMultiStateCopycatBlock copycatBlock = (IMultiStateCopycatBlock)block;
            BlockHitResult hitResult = pLevel.m_45547_(new ClipContext(pEntity.m_20182_(), pEntity.m_20182_().m_82520_(0.0, -2.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, pEntity));
            String property = copycatBlock.getPropertyFromInteraction(state, (BlockGetter)pLevel, pPos, hitResult, true);
            IMultiStateCopycatBlockEntity copycatBE = copycatBlock.getCopycatBlockEntity((BlockGetter)pLevel, pPos);
            if (copycatBE == null) {
                super.m_142072_(pLevel, state, pPos, pEntity, p_152430_);
                return;
            }
            BlockState material = copycatBE.getMaterialItemStorage().getMaterialItem(property).material();
            material.m_60734_().m_142072_(pLevel, material, pPos, pEntity, p_152430_);
        } else {
            super.m_142072_(pLevel, state, pPos, pEntity, p_152430_);
        }
    }

    public float m_5880_(@NotNull BlockState pState, @NotNull Player pPlayer, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos) {
        Block block = pState.m_60734_();
        if (block instanceof IMultiStateCopycatBlock) {
            IMultiStateCopycatBlock copycatBlock = (IMultiStateCopycatBlock)block;
            String property = copycatBlock.getPropertyFromInteraction(pState, pLevel, pPos, new BlockHitResult(Vec3.m_82512_((Vec3i)pPos), Direction.UP, pPos, true), true);
            IMultiStateCopycatBlockEntity copycatBE = copycatBlock.getCopycatBlockEntity(pLevel, pPos);
            if (copycatBE == null) {
                return super.m_5880_(pState, pPlayer, pLevel, pPos);
            }
            BlockState material = copycatBE.getMaterialItemStorage().getMaterialItem(property).material();
            return material.m_60625_(pPlayer, pLevel, pPos);
        }
        return super.m_5880_(pState, pPlayer, pLevel, pPos);
    }
}

