/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.mixin.entity;

import com.copycatsplus.copycats.CCBlocks;
import com.copycatsplus.copycats.content.copycat.block.CopycatBlockBlock;
import com.simibubi.create.AllTags;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Cat.class})
public abstract class CatMixin
extends TamableAnimal {
    @Unique
    private static final int COPY_CAT_ID = 11;
    @Shadow
    @Final
    private static EntityDataAccessor<Integer> f_28104_;
    @Unique
    private static final EntityDataAccessor<Integer> DATA_NATURAL_TYPE_ID;

    @Shadow
    public abstract int m_28163_();

    @Shadow
    public abstract void m_28179_(int var1);

    @Inject(at={@At(value="HEAD")}, method={"setCatType(I)V"}, cancellable=true)
    private void setCopyCat(int pType, CallbackInfo ci) {
        if (pType == 11) {
            this.f_19804_.m_135381_(f_28104_, (Object)pType);
            ci.cancel();
        }
    }

    @ModifyArg(at=@At(value="INVOKE", target="Ljava/util/Random;nextInt(I)I"), method={"finalizeSpawn(Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/world/DifficultyInstance;Lnet/minecraft/world/entity/MobSpawnType;Lnet/minecraft/world/entity/SpawnGroupData;Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/world/entity/SpawnGroupData;"}, index=0)
    private int spawnCopyCat(int original) {
        if (original <= 10) {
            return original;
        }
        return original + 1;
    }

    @Shadow
    protected abstract void m_142075_(Player var1, InteractionHand var2, ItemStack var3);

    protected CatMixin(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Unique
    public int getNaturalType() {
        return (Integer)this.f_19804_.m_135370_(DATA_NATURAL_TYPE_ID);
    }

    @Unique
    public void setNaturalType(int pType) {
        this.f_19804_.m_135381_(DATA_NATURAL_TYPE_ID, (Object)pType);
    }

    @Inject(at={@At(value="RETURN")}, method={"defineSynchedData()V"})
    private void defineNaturalVariant(CallbackInfo ci) {
        this.f_19804_.m_135372_(DATA_NATURAL_TYPE_ID, (Object)10);
    }

    @Inject(at={@At(value="RETURN")}, method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"})
    private void addNaturalVariantData(CompoundTag pCompound, CallbackInfo ci) {
        pCompound.m_128405_("NaturalType", this.getNaturalType());
    }

    @Inject(at={@At(value="RETURN")}, method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"})
    private void readNaturalVariantData(CompoundTag pCompound, CallbackInfo ci) {
        int naturalType = pCompound.m_128451_("NaturalType");
        this.setNaturalType(naturalType);
    }

    @Inject(at={@At(value="HEAD")}, method={"usePlayerItem(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/item/ItemStack;)V"})
    private void useCopycat(Player pPlayer, InteractionHand pHand, ItemStack pStack, CallbackInfo ci) {
        if (pStack.m_150930_(((CopycatBlockBlock)CCBlocks.COPYCAT_BLOCK.get()).m_5456_())) {
            this.m_5496_(SoundEvents.f_12013_, 75.0f, 0.95f);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"mobInteract(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, cancellable=true)
    private void copycatInteract(Player pPlayer, InteractionHand pHand, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack stack = pPlayer.m_21120_(pHand);
        if (stack.m_150930_(((CopycatBlockBlock)CCBlocks.COPYCAT_BLOCK.get()).m_5456_())) {
            int currentType = this.m_28163_();
            if (currentType == 11) {
                return;
            }
            if (!this.f_19853_.m_5776_()) {
                this.setNaturalType(currentType);
                this.m_28179_(11);
                this.m_142075_(pPlayer, pHand, stack);
                this.m_21530_();
            }
            cir.setReturnValue((Object)InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_()));
        } else if (stack.m_204117_(AllTags.AllItemTags.WRENCH.tag)) {
            int currentVariant = this.m_28163_();
            if (currentVariant != 11) {
                return;
            }
            if (!this.f_19853_.m_5776_()) {
                this.m_28179_(this.getNaturalType());
                this.m_21530_();
                this.m_19998_((ItemLike)((CopycatBlockBlock)CCBlocks.COPYCAT_BLOCK.get()).m_5456_());
                SoundType soundType = CCBlocks.COPYCAT_BLOCK.getDefaultState().m_60827_();
                this.m_5496_(soundType.m_56775_(), (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
            }
            cir.setReturnValue((Object)InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_()));
        }
    }

    static {
        Cat.f_28102_.put(11, new ResourceLocation("copycats", "textures/entity/cat/copy_cat.png"));
        DATA_NATURAL_TYPE_ID = SynchedEntityData.m_135353_(Cat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    }
}

