/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.logic;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mod.casinocraft.Config;
import mod.casinocraft.util.Card;
import mod.casinocraft.util.Dice;
import mod.casinocraft.util.Ship;
import mod.lucky77.util.Dummy;
import mod.lucky77.util.Vector2;
import net.minecraft.nbt.CompoundTag;

public abstract class LogicModule
extends Dummy {
    public final Random RANDOM = new Random();
    public int scorePoint = -1;
    public int scoreLevel = -1;
    public int scoreLives = -1;
    public String hand = "NULL";
    public String[] currentPlayer = new String[]{"void", "void", "void", "void", "void", "void"};
    public int[] reward = new int[]{0, 0, 0, 0, 0, 0};
    public int[][] grid;
    public Vector2 selector = new Vector2(0, 0);
    public int turnstate;
    public final int tableID;
    public int[] scoreHigh = new int[20];
    public String[] scoreName = new String[20];
    public int scoreLast = 18;
    public boolean pause = false;
    public int frame = 0;
    public int activePlayer = 0;
    public int timeout = 0;
    public int jingle = 0;
    protected int timeoutMAX;

    public LogicModule(int table) {
        this(table, 1, 1);
    }

    public LogicModule(int tableID, int gridX, int gridY) {
        this.tableID = tableID;
        if (this.hasHighscore()) {
            this.setupHighscore();
        }
        this.grid = new int[gridX][gridY];
        this.timeoutMAX = (Integer)Config.ConfigMachine.config_timeout.get();
    }

    public void start(int seed) {
        this.RANDOM.setSeed(seed);
        this.pause = false;
        this.turnstate = this.turnstate == 0 ? 2 : 0;
        this.scorePoint = 0;
        this.scoreLevel = 0;
        this.scoreLives = 0;
        this.hand = "empty";
        this.reward = new int[]{0, 0, 0, 0, 0, 0};
        this.selector.set(0, 0);
        this.activePlayer = 0;
        this.timeout = 0;
        if (this.tableID < 3) {
            this.resetGrid();
        }
        this.start2();
    }

    public void update() {
        if (!this.pause) {
            this.frame = (this.frame + 1) % 48;
            this.updateMotion();
            this.updateLogic();
        }
    }

    public void load(CompoundTag compound) {
        int[] baseValues = compound.m_128465_("basevalues");
        this.turnstate = baseValues[0];
        this.scorePoint = baseValues[1];
        this.scoreLevel = baseValues[2];
        this.scoreLives = baseValues[3];
        this.selector.set(baseValues[4], baseValues[5]);
        this.activePlayer = baseValues[6];
        this.hand = compound.m_128461_("hand");
        this.pause = compound.m_128471_("pause");
        this.currentPlayer[0] = compound.m_128461_("currentplayer0");
        this.currentPlayer[1] = compound.m_128461_("currentplayer1");
        this.currentPlayer[2] = compound.m_128461_("currentplayer2");
        this.currentPlayer[3] = compound.m_128461_("currentplayer3");
        this.currentPlayer[4] = compound.m_128461_("currentplayer4");
        this.currentPlayer[5] = compound.m_128461_("currentplayer5");
        int[] array = compound.m_128465_("grid");
        for (int y = 0; y < this.grid[0].length; ++y) {
            for (int x = 0; x < this.grid.length; ++x) {
                this.grid[x][y] = y * this.grid.length + x >= array.length ? 0 : array[y * this.grid.length + x];
            }
        }
        if (this.hasHighscore()) {
            for (int i = 0; i < 20; ++i) {
                this.scoreHigh[i] = compound.m_128451_("points" + i);
                this.scoreName[i] = compound.m_128461_("name" + i);
            }
        }
        if (this.turnstate >= 2 && this.turnstate <= 5) {
            this.load2(compound);
        }
    }

    public CompoundTag save(CompoundTag compound) {
        compound.m_128385_("basevalues", new int[]{this.turnstate, this.scorePoint, this.scoreLevel, this.scoreLives, this.selector.X, this.selector.Y, this.activePlayer});
        compound.m_128359_("hand", this.hand);
        compound.m_128379_("pause", this.pause);
        compound.m_128359_("currentplayer0", this.currentPlayer[0]);
        compound.m_128359_("currentplayer1", this.currentPlayer[1]);
        compound.m_128359_("currentplayer2", this.currentPlayer[2]);
        compound.m_128359_("currentplayer3", this.currentPlayer[3]);
        compound.m_128359_("currentplayer4", this.currentPlayer[4]);
        compound.m_128359_("currentplayer5", this.currentPlayer[5]);
        int[] array = new int[this.grid.length * this.grid[0].length];
        for (int y = 0; y < this.grid[0].length; ++y) {
            for (int x = 0; x < this.grid.length; ++x) {
                array[y * this.grid.length + x] = this.grid[x][y];
            }
        }
        compound.m_128385_("grid", array);
        if (this.hasHighscore()) {
            for (int i = 0; i < 20; ++i) {
                compound.m_128405_("points" + i, this.scoreHigh[i]);
                compound.m_128359_("name" + i, this.scoreName[i]);
            }
        }
        if (this.turnstate >= 2 && this.turnstate <= 5) {
            this.save2(compound);
        }
        return compound;
    }

    protected Card[] loadCardArray(CompoundTag compound, int index) {
        int[] array = compound.m_128465_("cardstack" + index);
        Card[] cards = new Card[array.length / 3];
        for (int i = 0; i < array.length; i += 3) {
            cards[i / 3] = new Card(array[i], array[i + 1], array[i + 2] == 1);
        }
        return cards;
    }

    protected List<Card> loadCardList(CompoundTag compound, int index) {
        int[] array = compound.m_128465_("cardstack" + index);
        ArrayList<Card> cards = new ArrayList<Card>();
        for (int i = 0; i < array.length; i += 3) {
            cards.add(new Card(array[i], array[i + 1], array[i + 2] == 1));
        }
        return cards;
    }

    protected Dice[] loadDice(CompoundTag compound) {
        int[] array = compound.m_128465_("diceset");
        Dice[] dice = new Dice[array.length / 2];
        for (int i = 0; i < array.length; i += 2) {
            dice[i / 2] = new Dice(array[i], array[i + 1]);
        }
        return dice;
    }

    protected Ship loadEntity(CompoundTag compound, int index) {
        int[] array = compound.m_128465_("entity" + index);
        return new Ship(array[0], new Vector2(array[1], array[2]), new Vector2(array[3], array[4]), new Vector2(array[5], array[6]));
    }

    protected List<Ship> loadEntityList(CompoundTag compound, int index) {
        int[] array = compound.m_128465_("entitylist" + index);
        ArrayList<Ship> list = new ArrayList<Ship>();
        for (int i = 0; i < array.length; i += 7) {
            list.add(new Ship(array[i], new Vector2(array[i + 1], array[i + 2]), new Vector2(array[i + 3], array[i + 4]), new Vector2(array[i + 5], array[i + 6])));
        }
        return list;
    }

    protected CompoundTag saveCardArray(CompoundTag compound, int index, Card[] cards) {
        int[] array = new int[cards.length * 3];
        for (int pos = 0; pos < cards.length; ++pos) {
            array[pos * 3] = cards[pos].number;
            array[pos * 3 + 1] = cards[pos].suit;
            array[pos * 3 + 2] = cards[pos].hidden ? 1 : 0;
        }
        compound.m_128385_("cardstack" + index, array);
        return compound;
    }

    protected CompoundTag saveCardList(CompoundTag compound, int index, List<Card> cards) {
        int[] array = new int[cards.size() * 3];
        for (int pos = 0; pos < cards.size(); ++pos) {
            array[pos * 3] = cards.get((int)pos).number;
            array[pos * 3 + 1] = cards.get((int)pos).suit;
            array[pos * 3 + 2] = cards.get((int)pos).hidden ? 1 : 0;
        }
        compound.m_128385_("cardstack" + index, array);
        return compound;
    }

    protected CompoundTag saveDice(CompoundTag compound, Dice[] dice) {
        int[] array = new int[dice.length * 2];
        for (int pos = 0; pos < dice.length; ++pos) {
            array[pos * 2] = dice[pos].number;
            array[pos * 2 + 1] = dice[pos].color;
        }
        compound.m_128385_("diceset", array);
        return compound;
    }

    protected CompoundTag saveEntity(CompoundTag compound, int index, Ship ent) {
        int[] array = new int[]{ent.ai, ent.getPos().X, ent.getPos().Y, ent.getNext().X, ent.getNext().Y, ent.getVel().X, ent.getVel().Y};
        compound.m_128385_("entity" + index, array);
        return compound;
    }

    protected CompoundTag saveEntityList(CompoundTag compound, int index, List<Ship> list) {
        int[] array = new int[list.size() * 7];
        for (int pos = 0; pos < list.size(); ++pos) {
            array[pos * 7] = list.get((int)pos).ai;
            array[pos * 7 + 1] = list.get((int)pos).getPos().X;
            array[pos * 7 + 2] = list.get((int)pos).getPos().Y;
            array[pos * 7 + 3] = list.get((int)pos).getNext().X;
            array[pos * 7 + 4] = list.get((int)pos).getNext().Y;
            array[pos * 7 + 5] = list.get((int)pos).getVel().X;
            array[pos * 7 + 6] = list.get((int)pos).getVel().Y;
        }
        compound.m_128385_("entitylist" + index, array);
        return compound;
    }

    public void addScore(String name, int points) {
        int i;
        int pos = 20;
        for (i = 19; i >= 0; --i) {
            if (points <= this.scoreHigh[i]) continue;
            pos = i;
        }
        if (pos == 19) {
            this.scoreHigh[19] = points;
            this.scoreName[19] = name;
            this.scoreLast = 19;
        }
        if (pos < 19) {
            for (i = 18; i >= pos; --i) {
                this.scoreHigh[i + 1] = this.scoreHigh[i];
                this.scoreName[i + 1] = this.scoreName[i];
            }
            this.scoreHigh[pos] = points;
            this.scoreName[pos] = name;
        }
        this.scoreLast = pos;
    }

    private void setupHighscore() {
        this.scoreLast = 20;
        for (int i = 19; i >= 0; --i) {
            this.scoreHigh[i] = 0;
            this.scoreName[i] = "--------";
        }
    }

    protected void resetGrid() {
        for (int i = 0; i < this.grid.length; ++i) {
            for (int j = 0; j < this.grid[0].length; ++j) {
                this.grid[i][j] = 0;
            }
        }
    }

    public void addPlayer(String newPlayer) {
        for (int i = 0; i < 6; ++i) {
            if (!this.currentPlayer[i].matches("void")) continue;
            this.currentPlayer[i] = newPlayer;
            break;
        }
    }

    public boolean hasFreePlayerSlots() {
        if (this.isMultiplayer()) {
            for (int i = 0; i < (this.tableID == 1 ? 4 : 6); ++i) {
                if (!this.currentPlayer[i].matches("void")) continue;
                return true;
            }
        } else {
            return this.currentPlayer[0].matches("void");
        }
        return false;
    }

    public int getFirstFreePlayerSlot() {
        if (this.isMultiplayer()) {
            for (int i = 0; i < (this.tableID == 1 ? 4 : 6); ++i) {
                if (!this.currentPlayer[i].matches("void")) continue;
                return i;
            }
        } else {
            return 0;
        }
        return 6;
    }

    public void removePlayer(String oldPlayer) {
        for (int i = 0; i < 6; ++i) {
            if (!this.currentPlayer[i].matches(oldPlayer)) continue;
            this.currentPlayer[i] = "void";
            break;
        }
    }

    public void resetPlayers() {
        for (int i = 0; i < 6; ++i) {
            this.currentPlayer[i] = "void";
        }
    }

    protected void setJingle(int i) {
        this.jingle = i;
    }

    public abstract void command(int var1);

    public abstract void updateMotion();

    public abstract void updateLogic();

    public abstract void start2();

    public abstract void load2(CompoundTag var1);

    public abstract CompoundTag save2(CompoundTag var1);

    public abstract boolean hasHighscore();

    public abstract boolean isMultiplayer();

    public abstract int getID();
}

