/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.logic.card;

import java.util.ArrayList;
import java.util.List;
import mod.casinocraft.logic.LogicModule;
import mod.casinocraft.util.Card;
import net.minecraft.nbt.CompoundTag;

public class LogicCardGreen
extends LogicModule {
    public List<Card> cardsP1 = new ArrayList<Card>();
    public List<Card> cardsP2 = new ArrayList<Card>();
    public List<Card> cardsP3 = new ArrayList<Card>();
    public List<Card> cardsP4 = new ArrayList<Card>();
    public List<Card> cardsP5 = new ArrayList<Card>();
    public List<Card> cardsP6 = new ArrayList<Card>();
    public Card[] placed = new Card[]{new Card(-1, -1), new Card(-1, -1)};
    public boolean[] folded = new boolean[6];
    public int playerCount = 0;
    public int chosenColor = -1;
    public int forcedAction = 0;

    public LogicCardGreen(int tableID) {
        super(tableID);
    }

    @Override
    public void start2() {
        int i;
        for (i = 0; i < 6; ++i) {
            this.getCards(i).clear();
        }
        for (i = 0; i < 6; ++i) {
            this.folded[i] = false;
        }
        this.placed[0] = new Card(-1, -1);
        this.placed[1] = new Card(-1, -1);
        this.chosenColor = -1;
        this.forcedAction = 0;
        this.playerCount = 1;
    }

    @Override
    public void command(int action) {
        if (action == -1) {
            this.drawCard();
        } else if (action < -1) {
            this.chooseColor(action);
        } else if (action < this.getCards(this.activePlayer).size()) {
            this.playCard(action);
        }
    }

    @Override
    public void updateLogic() {
        ++this.timeout;
        if (this.turnstate == 2 && this.timeout >= this.timeoutMAX || this.getFirstFreePlayerSlot() == (this.tableID == 1 ? 4 : 6)) {
            this.draw();
        }
        if (this.turnstate == 3) {
            if (this.timeout == this.timeoutMAX) {
                if (this.forcedAction == 3) {
                    this.chooseColor(4);
                } else {
                    this.drawCard();
                }
            }
            if (this.lastStanding() != -1) {
                this.result();
            }
        }
    }

    @Override
    public void updateMotion() {
        for (int i = 0; i < 6; ++i) {
            for (Card c : this.getCards(i)) {
                c.update();
            }
        }
        this.placed[0].update();
        this.placed[1].update();
    }

    @Override
    public void load2(CompoundTag compound) {
        this.cardsP1 = this.loadCardList(compound, 0);
        this.cardsP2 = this.loadCardList(compound, 1);
        this.cardsP3 = this.loadCardList(compound, 2);
        this.cardsP4 = this.loadCardList(compound, 3);
        this.cardsP5 = this.loadCardList(compound, 4);
        this.cardsP6 = this.loadCardList(compound, 5);
        this.placed = this.loadCardArray(compound, 6);
        this.folded[0] = compound.m_128471_("folded0");
        this.folded[1] = compound.m_128471_("folded1");
        this.folded[2] = compound.m_128471_("folded2");
        this.folded[3] = compound.m_128471_("folded3");
        this.folded[4] = compound.m_128471_("folded4");
        this.folded[5] = compound.m_128471_("folded5");
        this.chosenColor = compound.m_128451_("chosencolor");
        this.forcedAction = compound.m_128451_("forcedaction");
        this.playerCount = compound.m_128451_("playercount");
    }

    @Override
    public CompoundTag save2(CompoundTag compound) {
        this.saveCardList(compound, 0, this.cardsP1);
        this.saveCardList(compound, 1, this.cardsP2);
        this.saveCardList(compound, 2, this.cardsP3);
        this.saveCardList(compound, 3, this.cardsP4);
        this.saveCardList(compound, 4, this.cardsP5);
        this.saveCardList(compound, 5, this.cardsP6);
        this.saveCardArray(compound, 6, this.placed);
        compound.m_128379_("folded0", this.folded[0]);
        compound.m_128379_("folded1", this.folded[1]);
        compound.m_128379_("folded2", this.folded[2]);
        compound.m_128379_("folded3", this.folded[3]);
        compound.m_128379_("folded4", this.folded[4]);
        compound.m_128379_("folded5", this.folded[5]);
        compound.m_128405_("chosencolor", this.chosenColor);
        compound.m_128405_("forcedaction", this.forcedAction);
        compound.m_128405_("playercount", this.playerCount);
        return compound;
    }

    public List<Card> getCards(int index) {
        switch (index) {
            case 0: {
                return this.cardsP1;
            }
            case 1: {
                return this.cardsP2;
            }
            case 2: {
                return this.cardsP3;
            }
            case 3: {
                return this.cardsP4;
            }
            case 4: {
                return this.cardsP5;
            }
            case 5: {
                return this.cardsP6;
            }
        }
        return this.cardsP1;
    }

    private void draw() {
        this.turnstate = 3;
        this.timeout = 0;
        this.playerCount = this.getFirstFreePlayerSlot();
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < this.playerCount; ++x) {
                this.getCards(x).add(new Card(this.RANDOM, 0, 24, 8 * x + 32 * y, false));
            }
        }
        for (int i = 0; i < 6; ++i) {
            if (i < this.getFirstFreePlayerSlot()) continue;
            this.folded[i] = true;
        }
        this.placed[0].set(new Card(this.RANDOM, 0, 24, 0, false));
        this.placed[1].set(new Card(this.RANDOM, 0, 0, 0, true));
        this.setJingle(1);
    }

    private void drawCard() {
        if (this.forcedAction == 0) {
            this.getCards(this.activePlayer).add(new Card(this.RANDOM, 0, 24, 0, false));
        } else if (this.forcedAction == 2) {
            this.getCards(this.activePlayer).add(new Card(this.RANDOM, 0, 24, 0, false));
            this.getCards(this.activePlayer).add(new Card(this.RANDOM, 0, 24, 8, false));
        }
        this.forcedAction = 0;
        this.timeout = 0;
        this.activePlayer = (this.activePlayer + 1) % this.getFirstFreePlayerSlot();
        this.setJingle(1);
    }

    private void playCard(int action) {
        if (this.canStack(action)) {
            this.chosenColor = -1;
            this.placed[1].set(this.placed[0]);
            this.placed[0].set(this.getCards(this.activePlayer).get(action));
            this.placed[0].setShift(0, 24, 0);
            this.getCards(this.activePlayer).remove(action);
            if (this.getCards(this.activePlayer).size() == 0) {
                this.hand = this.currentPlayer[this.activePlayer] + " has won the Game!";
            }
            if (this.placed[0].number == 10) {
                this.forcedAction = 3;
            }
            if (this.placed[0].number == 11) {
                this.forcedAction = 1;
            }
            if (this.placed[0].number == 12) {
                this.forcedAction = 2;
            }
            if (this.forcedAction != 3) {
                this.timeout = 0;
                this.activePlayer = (this.activePlayer + 1) % this.getFirstFreePlayerSlot();
            }
            this.setJingle(1);
        }
    }

    private void chooseColor(int index) {
        this.forcedAction = 0;
        this.chosenColor = index + 5;
        this.timeout = 0;
        this.activePlayer = (this.activePlayer + 1) % this.getFirstFreePlayerSlot();
    }

    private int lastStanding() {
        for (int i = 0; i < 6; ++i) {
            if (this.folded[i] || this.getCards(i).size() != 0) continue;
            return i;
        }
        return -1;
    }

    private void result() {
        this.turnstate = 4;
    }

    private boolean canStack(int pos) {
        if (this.getCards((int)this.activePlayer).get((int)pos).number == 10) {
            return true;
        }
        return this.chosenColor == -1 ? this.getCards((int)this.activePlayer).get((int)pos).number == this.placed[0].number || this.getCards((int)this.activePlayer).get((int)pos).suit == this.placed[0].suit : this.getCards((int)this.activePlayer).get((int)pos).suit == this.chosenColor;
    }

    @Override
    public boolean hasHighscore() {
        return false;
    }

    @Override
    public boolean isMultiplayer() {
        return true;
    }

    @Override
    public int getID() {
        return 5;
    }
}

