/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.logic.card;

import java.util.ArrayList;
import java.util.List;
import mod.casinocraft.logic.LogicModule;
import mod.casinocraft.util.Card;
import net.minecraft.nbt.CompoundTag;

public class LogicCardOrange
extends LogicModule {
    public List<Card> cards_player = new ArrayList<Card>();
    public List<Card> cards_dealer = new ArrayList<Card>();
    public int value_player = 0;
    public int value_dealer = 0;
    public int status = 0;

    public LogicCardOrange(int table) {
        super(table);
    }

    @Override
    public void start2() {
        this.cards_player.clear();
        this.cards_dealer.clear();
        this.value_player = 0;
        this.value_dealer = 0;
        this.status = 0;
        this.cards_player.add(new Card(this.RANDOM));
        this.cards_player.add(new Card(this.RANDOM));
        this.cards_dealer.add(new Card(this.RANDOM));
        this.cards_dealer.add(new Card(this.RANDOM));
        this.cards_player.get(0).setShift(-32, 0, 8);
        this.cards_player.get(1).setShift(-48, 0, 32);
        this.cards_dealer.get(0).setShift(0, -48, 8);
        this.cards_dealer.get(1).setShift(0, -48, 32);
        for (Card card : this.cards_player) {
            if (card.number > 9) continue;
            this.value_player += card.number + 1;
        }
        for (Card card : this.cards_dealer) {
            if (card.number > 9) continue;
            this.value_dealer += card.number + 1;
        }
        this.value_player %= 10;
        this.value_dealer %= 10;
        if (this.value_player >= 8 || this.value_dealer >= 8) {
            this.status = 1;
            this.result();
        } else {
            this.status = 2;
        }
        this.setJingle(2);
    }

    @Override
    public void command(int action) {
        if (action == 0) {
            this.addCard(true);
        }
        if (action == 1) {
            this.addCard(false);
        }
    }

    @Override
    public void updateLogic() {
    }

    @Override
    public void updateMotion() {
        if (this.cards_player.size() > 0) {
            for (Card card : this.cards_player) {
                card.update();
            }
        }
        if (this.cards_dealer.size() > 0) {
            for (Card card : this.cards_dealer) {
                card.update();
            }
        }
    }

    @Override
    public void load2(CompoundTag compound) {
        this.cards_player = this.loadCardList(compound, 0);
        this.cards_dealer = this.loadCardList(compound, 1);
        this.value_player = compound.m_128451_("valueplayer");
        this.value_dealer = compound.m_128451_("valuedealer");
        this.status = compound.m_128451_("status");
    }

    @Override
    public CompoundTag save2(CompoundTag compound) {
        this.saveCardList(compound, 0, this.cards_player);
        this.saveCardList(compound, 1, this.cards_player);
        compound.m_128405_("valueplayer", this.value_player);
        compound.m_128405_("valuedealer", this.value_dealer);
        compound.m_128405_("status", this.status);
        return compound;
    }

    private void addCard(boolean player) {
        if (player) {
            this.value_player = 0;
            this.cards_player.add(new Card(this.RANDOM, -48, 0));
            for (Card card : this.cards_player) {
                if (card.number > 9) continue;
                this.value_player += card.number + 1;
            }
            this.value_player %= 10;
        }
        boolean temp_draw = false;
        if (this.cards_player.size() == 2 || this.value_dealer <= 3) {
            temp_draw = true;
        } else if (this.value_dealer == 4 && this.value_player <= 7) {
            temp_draw = true;
        } else if (this.value_dealer == 5 && this.value_player >= 4 && this.value_player <= 7) {
            temp_draw = true;
        } else if (this.value_dealer == 6 && this.value_player >= 6 && this.value_player <= 7) {
            temp_draw = true;
        }
        if (temp_draw) {
            this.value_dealer = 0;
            this.cards_dealer.add(new Card(this.RANDOM, -48, 0));
            for (Card card : this.cards_dealer) {
                if (card.number > 9) continue;
                this.value_dealer += card.number + 1;
            }
            this.value_dealer %= 10;
        }
        this.setJingle(1);
        this.result();
    }

    private void result() {
        this.turnstate = 4;
        if (this.status == 2) {
            this.status = 3;
        }
        if (this.value_dealer < this.value_player) {
            this.hand = "The Player Wins!";
            this.reward[0] = 2;
        }
        if (this.value_dealer > this.value_player) {
            this.hand = "The House Wins!";
            this.reward[0] = 0;
        }
        if (this.value_dealer == this.value_player) {
            this.hand = "DRAW!";
            this.reward[0] = 1;
        }
        if (this.reward[0] >= 2) {
            this.jingle = 10;
        }
    }

    @Override
    public boolean hasHighscore() {
        return false;
    }

    @Override
    public boolean isMultiplayer() {
        return false;
    }

    @Override
    public int getID() {
        return 10;
    }
}

