/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.logic.mino;

import mod.casinocraft.logic.LogicModule;
import mod.lucky77.util.Vector2;
import net.minecraft.nbt.CompoundTag;

public class LogicMinoBlue
extends LogicModule {
    public boolean selectA = false;
    public boolean selectB = false;
    public Vector2 positionA = new Vector2(0, 0);
    public Vector2 positionB = new Vector2(0, 0);
    public int timer = 0;

    public LogicMinoBlue(int tableID) {
        super(tableID, 17, 9);
    }

    @Override
    public void start2() {
        this.scoreLevel = 1;
        this.scoreLives = 8;
        this.selectA = false;
        this.selectB = false;
        this.timer = 0;
        this.positionA.set(-1, -1);
        this.positionB.set(-1, -1);
        this.commandCreateGrid();
    }

    public void restart() {
        this.turnstate = 2;
        ++this.scoreLevel;
        this.scoreLives += this.scoreLevel * 2;
        this.selectA = false;
        this.selectB = false;
        this.timer = 0;
        this.positionA.set(-1, -1);
        this.positionB.set(-1, -1);
        this.commandCreateGrid();
    }

    @Override
    public void command(int action) {
        if (action == -1) {
            this.restart();
        } else if (action == -2) {
            this.turnstate = 4;
        } else {
            this.clickMino(action % 17, action / 17);
        }
    }

    @Override
    public void updateLogic() {
        if (this.timer == -1) {
            if (this.grid[this.positionA.X][this.positionA.Y] == this.grid[this.positionB.X][this.positionB.Y]) {
                this.grid[this.positionA.X][this.positionA.Y] = -1;
                this.grid[this.positionB.X][this.positionB.Y] = -1;
            } else {
                --this.scoreLives;
            }
            boolean temp = false;
            for (int x = 0; x < 17; ++x) {
                for (int y = 0; y < 9; ++y) {
                    if (this.grid[x][y] == -1) continue;
                    temp = true;
                }
            }
            if (!temp) {
                this.turnstate = 3;
                this.scorePoint += this.scoreLevel * 4;
            } else if (this.scoreLives <= 0) {
                this.turnstate = 4;
                this.scorePoint /= 2;
            }
            this.selectA = false;
            this.selectB = false;
            this.positionA.set(-1, -1);
            this.positionB.set(-1, -1);
            this.timer = 0;
        }
    }

    @Override
    public void updateMotion() {
        if (this.timer > 0) {
            this.timer -= 10;
            if (this.timer <= 0) {
                this.timer = -1;
            }
        }
    }

    @Override
    public void load2(CompoundTag compound) {
        this.selectA = compound.m_128471_("selecta");
        this.selectB = compound.m_128471_("selectb");
        this.positionA.set(compound.m_128451_("positionax"), compound.m_128451_("positionay"));
        this.positionA.set(compound.m_128451_("positionbx"), compound.m_128451_("positionby"));
        this.timer = compound.m_128451_("timer");
    }

    @Override
    public CompoundTag save2(CompoundTag compound) {
        compound.m_128379_("selecta", this.selectA);
        compound.m_128379_("selectb", this.selectB);
        compound.m_128405_("positionax", this.positionA.X);
        compound.m_128405_("positionay", this.positionA.Y);
        compound.m_128405_("positionbx", this.positionB.X);
        compound.m_128405_("positionby", this.positionB.Y);
        compound.m_128405_("timer", this.timer);
        return compound;
    }

    private void clickMino(int x, int y) {
        if (!this.selectA) {
            if (this.grid[x][y] != -1) {
                this.selectA = true;
                this.positionA.set(x, y);
                this.setJingle(3);
            }
        } else if (!this.selectB && this.grid[x][y] != -1 && !this.positionA.matches(x, y)) {
            this.selectB = true;
            this.positionB.set(x, y);
            this.timer = 200 - this.scoreLevel * 10;
            this.setJingle(3);
        }
    }

    private void commandCreateGrid() {
        int filler;
        for (int x = 0; x < 17; ++x) {
            for (int y = 0; y < 9; ++y) {
                this.grid[x][y] = -1;
            }
        }
        int max = this.tableID == 1 ? 80 : 152;
        int filler2 = filler = this.scoreLevel * 4 < max ? this.scoreLevel * 4 : max;
        int[] color = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        while (filler > 0) {
            int z;
            int n = z = this.RANDOM.nextInt(8);
            color[n] = color[n] + 2;
            filler -= 2;
        }
        block3: while (filler2 > 0) {
            int y;
            int x = this.RANDOM.nextInt(this.tableID == 1 ? 9 : 17) + (this.tableID == 1 ? 4 : 0);
            if (this.grid[x][y = this.RANDOM.nextInt(9)] != -1) continue;
            for (int i = 0; i < 8; ++i) {
                if (color[i] <= 0) continue;
                this.grid[x][y] = i;
                int n = i;
                color[n] = color[n] - 1;
                --filler2;
                continue block3;
            }
        }
    }

    @Override
    public boolean hasHighscore() {
        return true;
    }

    @Override
    public boolean isMultiplayer() {
        return false;
    }

    @Override
    public int getID() {
        return 33;
    }
}

