/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.logic.mino;

import java.util.ArrayList;
import java.util.List;
import mod.casinocraft.logic.LogicModule;
import mod.casinocraft.util.Card;
import net.minecraft.nbt.CompoundTag;

public class LogicMinoLightBlue
extends LogicModule {
    public List<Card> reserve = new ArrayList<Card>();

    public LogicMinoLightBlue(int tableID) {
        super(tableID, 12, 8);
    }

    @Override
    public void start2() {
        this.reserve = this.fillReserve();
        for (int y = 0; y < 8; ++y) {
            for (int x = 0; x < 12; ++x) {
                if (this.tableID == 1) {
                    if (x < 2 || x > 9) {
                        this.grid[x][y] = -3;
                        continue;
                    }
                    this.grid[x][y] = -1;
                    continue;
                }
                this.grid[x][y] = -1;
            }
        }
        boolean[] number = new boolean[6];
        boolean[] suit = new boolean[6];
        for (int i = 0; i < 6; ++i) {
            number[i] = false;
            suit[i] = false;
        }
        int placed = 0;
        for (int i = 0; i < this.reserve.size(); ++i) {
            if (!number[this.reserve.get((int)i).number] && !suit[this.reserve.get((int)i).suit]) {
                number[this.reserve.get((int)i).number] = true;
                suit[this.reserve.get((int)i).suit] = true;
                ++placed;
                if (this.grid[5][3] < 0) {
                    this.grid[5][3] = this.takeMino(i);
                } else if (this.grid[6][4] < 0) {
                    this.grid[6][4] = this.takeMino(i);
                } else if (this.grid[this.tableID == 1 ? 2 : 0][0] < 0) {
                    this.grid[this.tableID == 1 ? 2 : 0][0] = this.takeMino(i);
                } else if (this.grid[this.tableID == 1 ? 9 : 11][0] < 0) {
                    this.grid[this.tableID == 1 ? 9 : 11][0] = this.takeMino(i);
                } else if (this.grid[this.tableID == 1 ? 2 : 0][7] < 0) {
                    this.grid[this.tableID == 1 ? 2 : 0][7] = this.takeMino(i);
                } else if (this.grid[this.tableID == 1 ? 9 : 11][7] < 0) {
                    this.grid[this.tableID == 1 ? 9 : 11][7] = this.takeMino(i);
                }
            }
            if (placed == 6) break;
        }
        this.checkForGameOver();
    }

    @Override
    public void command(int action) {
        this.place(action);
    }

    @Override
    public void updateLogic() {
    }

    @Override
    public void updateMotion() {
    }

    @Override
    public void load2(CompoundTag compound) {
        this.reserve.addAll(this.loadCardList(compound, 0));
    }

    @Override
    public CompoundTag save2(CompoundTag compound) {
        this.saveCardList(compound, 0, this.reserve);
        return compound;
    }

    private void place(int action) {
        int x = action % 12;
        int y = action / 12;
        int connections = this.canPlace(x, y);
        if (connections > 0) {
            this.setJingle(3);
            switch (connections) {
                case 1: {
                    ++this.scorePoint;
                    break;
                }
                case 2: {
                    this.scorePoint += 4;
                    break;
                }
                case 3: {
                    this.scorePoint += 8;
                    break;
                }
                case 4: {
                    this.scorePoint += 16;
                }
            }
            this.grid[x][y] = this.takeNextMino();
            this.checkForGameOver();
        }
    }

    private List<Card> fillReserve() {
        ArrayList<Card> stack = new ArrayList<Card>();
        ArrayList<Card> deck = new ArrayList<Card>();
        for (int z = 0; z < 2; ++z) {
            for (int y = 0; y < 6; ++y) {
                for (int x = 0; x < 6; ++x) {
                    stack.add(new Card(x, y));
                }
            }
        }
        while (stack.size() > 1) {
            int r = this.RANDOM.nextInt(stack.size() - 1);
            deck.add((Card)stack.get(r));
            stack.remove(r);
        }
        deck.add((Card)stack.get(0));
        return deck;
    }

    private int takeNextMino() {
        return this.takeMino(0);
    }

    private int takeMino(int index) {
        int x = this.reserve.get((int)index).number;
        int y = this.reserve.get((int)index).suit;
        this.reserve.remove(index);
        return x + y * 6;
    }

    private void checkForGameOver() {
        if (this.reserve.size() == 0) {
            this.turnstate = 4;
        } else {
            boolean placable = false;
            for (int y = 0; y < 8; ++y) {
                for (int x = 0; x < 12; ++x) {
                    int connect = this.canPlace(x, y);
                    if (connect > 0) {
                        placable = true;
                    }
                    if (this.grid[x][y] != -1 && this.grid[x][y] != -2) continue;
                    this.grid[x][y] = connect > 0 ? -2 : -1;
                }
            }
            if (!placable) {
                this.turnstate = 4;
            }
        }
    }

    private int canPlace(int x, int y) {
        if (this.grid[x][y] >= 0 || this.grid[x][y] == -3) {
            return 0;
        }
        int connections = 0;
        boolean noCon = false;
        if (x - 1 >= 0 && this.grid[x - 1][y] >= 0) {
            if (this.grid[x - 1][y] % 6 == this.reserve.get((int)0).number || this.grid[x - 1][y] / 6 == this.reserve.get((int)0).suit) {
                ++connections;
            } else {
                noCon = true;
            }
        }
        if (x + 1 < 12 && this.grid[x + 1][y] >= 0) {
            if (this.grid[x + 1][y] % 6 == this.reserve.get((int)0).number || this.grid[x + 1][y] / 6 == this.reserve.get((int)0).suit) {
                ++connections;
            } else {
                noCon = true;
            }
        }
        if (y - 1 >= 0 && this.grid[x][y - 1] >= 0) {
            if (this.grid[x][y - 1] % 6 == this.reserve.get((int)0).number || this.grid[x][y - 1] / 6 == this.reserve.get((int)0).suit) {
                ++connections;
            } else {
                noCon = true;
            }
        }
        if (y + 1 < 8 && this.grid[x][y + 1] >= 0) {
            if (this.grid[x][y + 1] % 6 == this.reserve.get((int)0).number || this.grid[x][y + 1] / 6 == this.reserve.get((int)0).suit) {
                ++connections;
            } else {
                noCon = true;
            }
        }
        return noCon ? 0 : connections;
    }

    @Override
    public boolean hasHighscore() {
        return true;
    }

    @Override
    public boolean isMultiplayer() {
        return false;
    }

    @Override
    public int getID() {
        return 38;
    }
}

