/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.network;

import java.util.function.Supplier;
import mod.casinocraft.blockentity.BlockEntityMachine;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.network.NetworkEvent;

public class MessageInventoryClient {
    static ItemStack stack0;
    static ItemStack stack1;
    static ItemStack stack2;
    static ItemStack stack3;
    static ItemStack stack4;
    static int storageToken;
    static int storagePrize;
    static BlockPos pos;

    public MessageInventoryClient(NonNullList<ItemStack> inventory, int storageToken, int storagePrize, BlockPos pos) {
        stack0 = (ItemStack)inventory.get(0);
        stack1 = (ItemStack)inventory.get(1);
        stack2 = (ItemStack)inventory.get(2);
        stack3 = (ItemStack)inventory.get(3);
        stack4 = (ItemStack)inventory.get(4);
        MessageInventoryClient.storageToken = storageToken;
        MessageInventoryClient.storagePrize = storagePrize;
        MessageInventoryClient.pos = pos;
    }

    public static void encode(MessageInventoryClient msg, FriendlyByteBuf buf) {
        buf.m_130055_(stack0);
        buf.m_130055_(stack1);
        buf.m_130055_(stack2);
        buf.m_130055_(stack3);
        buf.m_130055_(stack4);
        buf.writeInt(storageToken);
        buf.writeInt(storagePrize);
        buf.m_130064_(pos);
    }

    public static MessageInventoryClient decode(FriendlyByteBuf buf) {
        ItemStack _stack0 = buf.m_130267_();
        ItemStack _stack1 = buf.m_130267_();
        ItemStack _stack2 = buf.m_130267_();
        ItemStack _stack3 = buf.m_130267_();
        ItemStack _stack4 = buf.m_130267_();
        int _storageToken = buf.readInt();
        int _storagePrize = buf.readInt();
        BlockPos _pos = buf.m_130135_();
        NonNullList inv = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
        inv.set(0, (Object)_stack0);
        inv.set(1, (Object)_stack1);
        inv.set(2, (Object)_stack2);
        inv.set(3, (Object)_stack3);
        inv.set(4, (Object)_stack4);
        return new MessageInventoryClient((NonNullList<ItemStack>)inv, _storageToken, _storagePrize, _pos);
    }

    public static class Handler {
        public static void handle(MessageInventoryClient message, Supplier<NetworkEvent.Context> context) {
            BlockEntityMachine te = (BlockEntityMachine)Minecraft.m_91087_().f_91073_.m_7702_(pos);
            context.get().enqueueWork(() -> {
                te.m_6836_(0, stack0);
                te.m_6836_(1, stack1);
                te.m_6836_(2, stack2);
                te.m_6836_(3, stack3);
                te.m_6836_(4, stack4);
                te.storageToken = storageToken;
                te.storageReward = storagePrize;
                if (storageToken <= 0) {
                    te.storageToken = 0;
                    te.setTokenBET(new ItemStack((ItemLike)Blocks.f_50016_));
                }
                if (storagePrize <= 0) {
                    te.storageReward = 0;
                    te.setTokenREW(new ItemStack((ItemLike)Blocks.f_50016_));
                }
                te.changeLogic();
            });
            context.get().setPacketHandled(true);
        }
    }
}

