/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.network;

import java.util.function.Supplier;
import mod.casinocraft.blockentity.BlockEntityMachine;
import mod.casinocraft.logic.LogicModule;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class MessageStateClient {
    static boolean system;
    static int state;
    static BlockPos pos;

    public MessageStateClient(boolean system, int state, BlockPos pos) {
        MessageStateClient.system = system;
        MessageStateClient.state = state;
        MessageStateClient.pos = pos;
    }

    public static void encode(MessageStateClient msg, FriendlyByteBuf buf) {
        buf.writeBoolean(system);
        buf.writeInt(state);
        buf.m_130064_(pos);
    }

    public static MessageStateClient decode(FriendlyByteBuf buf) {
        boolean _system = buf.readBoolean();
        int _state = buf.readInt();
        BlockPos _pos = buf.m_130135_();
        return new MessageStateClient(_system, _state, _pos);
    }

    public static class Handler {
        public static void handle(MessageStateClient message, Supplier<NetworkEvent.Context> context) {
            BlockEntityMachine te = (BlockEntityMachine)Minecraft.m_91087_().f_91073_.m_7702_(pos);
            context.get().enqueueWork(() -> {
                if (system) {
                    if (state == -1) {
                        ((LogicModule)te.logic).pause = !((LogicModule)te.logic).pause;
                    } else if (state == -2) {
                        ((LogicModule)te.logic).resetPlayers();
                        ((LogicModule)te.logic).turnstate = 0;
                    } else if (state == -3) {
                        ((LogicModule)te.logic).resetPlayers();
                    } else if (state >= 10) {
                        ((LogicModule)te.logic).reward[MessageStateClient.state - 10] = 0;
                    } else {
                        ((LogicModule)te.logic).turnstate = state;
                    }
                } else {
                    ((LogicModule)te.logic).command(state);
                }
            });
            context.get().setPacketHandled(true);
        }
    }
}

