/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.screen.card;

import com.mojang.blaze3d.vertex.PoseStack;
import mod.casinocraft.logic.card.LogicCardBlack;
import mod.casinocraft.menu.MenuCasino;
import mod.casinocraft.screen.ScreenCasino;
import mod.casinocraft.util.ButtonMap;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class ScreenCardBlack
extends ScreenCasino {
    public ScreenCardBlack(MenuCasino container, Inventory player, Component name) {
        super(container, player, name);
    }

    public LogicCardBlack logic() {
        return (LogicCardBlack)((MenuCasino)this.f_97732_).logic();
    }

    @Override
    protected String getGameName() {
        return "black_jack";
    }

    @Override
    protected void createGameButtons() {
        this.buttonSet.addButton(ButtonMap.POS_MID_LEFT, ButtonMap.HIT, () -> this.isActivePlayer() && this.logic().turnstate == 2, () -> this.action(0));
        this.buttonSet.addButton(ButtonMap.POS_MID_RIGHT, ButtonMap.STAND, () -> this.isActivePlayer() && this.logic().turnstate == 2, () -> this.action(1));
        this.buttonSet.addButton(ButtonMap.POS_TOP_RIGHT, ButtonMap.SPLIT, () -> this.isActivePlayer() && this.logic().turnstate == 2 && this.canSplit(), () -> this.action(2));
        this.buttonSet.addButton(ButtonMap.POS_TOP_LEFT, ButtonMap.DOUBLE, () -> this.isActivePlayer() && this.logic().turnstate == 2 && ((MenuCasino)this.f_97732_).hasToken() && this.playerToken >= this.bet, () -> this.action(3));
    }

    @Override
    protected void interact(double mouseX, double mouseY, int mouseButton) {
    }

    @Override
    protected void drawForegroundLayer(PoseStack matrix, int mouseX, int mouseY) {
        if (this.logic().split == 0) {
            this.drawFont(matrix, "PLAYER:  " + this.logic().value_player1, 24, 24);
            if (this.logic().turnstate >= 4) {
                this.drawFontCenter(matrix, this.logic().hand, 128, 190);
            }
        } else {
            this.drawFont(matrix, "PLAYER L:  " + this.logic().value_player1, 24, 24);
            this.drawFont(matrix, "PLAYER R:  " + this.logic().value_player2, 24, 40);
            if (this.logic().turnstate >= 4) {
                this.drawFontCenter(matrix, this.logic().hand, 128, 190);
            }
        }
        if (this.logic().turnstate >= 3) {
            this.drawFont(matrix, "DEALER:  " + this.logic().value_dealer, 24, 56);
        }
    }

    @Override
    protected void drawBackgroundLayer(PoseStack matrix, float partialTicks, int mouseX, int mouseY) {
        int z;
        for (z = 0; z < this.logic().cards_player1.size(); ++z) {
            if (this.logic().cards_player1.get((int)z).idletimer == 0) {
                this.drawCard(matrix, 24 + 16 * z, 100 + 4 * z, this.logic().cards_player1.get(z));
            }
            if (this.logic().split != 1) continue;
            this.drawCardBack(matrix, 24 + 16 * z, 100 + 4 * z, 10);
        }
        for (z = 0; z < this.logic().cards_player2.size(); ++z) {
            if (this.logic().cards_player2.get((int)z).idletimer == 0) {
                this.drawCard(matrix, 144 + 16 * z, 100 + 4 * z, this.logic().cards_player2.get(z));
            }
            if (this.logic().split != 2) continue;
            this.drawCardBack(matrix, 144 + 16 * z, 100 + 4 * z, 10);
        }
        for (z = 0; z < this.logic().cards_dealer.size(); ++z) {
            if (this.logic().cards_dealer.get((int)z).idletimer != 0) continue;
            this.drawCard(matrix, 144 + 16 * z, 24 + 4 * z, this.logic().cards_dealer.get(z));
        }
    }

    private boolean canSplit() {
        return (this.logic().cards_player1.get((int)0).number >= 9 && this.logic().cards_player1.get((int)1).number >= 9 || this.logic().cards_player1.get((int)0).number == this.logic().cards_player1.get((int)1).number) && (this.playerToken >= this.bet || !((MenuCasino)this.f_97732_).hasToken());
    }
}

