/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.screen.card;

import com.mojang.blaze3d.vertex.PoseStack;
import mod.casinocraft.logic.card.LogicCardOrange;
import mod.casinocraft.menu.MenuCasino;
import mod.casinocraft.screen.ScreenCasino;
import mod.casinocraft.util.ButtonMap;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class ScreenCardOrange
extends ScreenCasino {
    public ScreenCardOrange(MenuCasino container, Inventory player, Component name) {
        super(container, player, name);
    }

    public LogicCardOrange logic() {
        return (LogicCardOrange)((MenuCasino)this.f_97732_).logic();
    }

    @Override
    protected String getGameName() {
        return this.tableID == 1 ? "bacca_rat" : "baccarat";
    }

    @Override
    protected void createGameButtons() {
        this.buttonSet.addButton(ButtonMap.POS_MID_LEFT, ButtonMap.ANOTHER, () -> this.isActivePlayer() && this.logic().turnstate == 2, () -> this.action(0));
        this.buttonSet.addButton(ButtonMap.POS_MID_RIGHT, ButtonMap.WAIT, () -> this.isActivePlayer() && this.logic().turnstate == 2, () -> this.action(1));
    }

    @Override
    protected void interact(double mouseX, double mouseY, int mouseButton) {
    }

    @Override
    protected void drawForegroundLayer(PoseStack matrix, int mouseX, int mouseY) {
        this.drawFont(matrix, "PLAYER:  " + this.logic().value_player, 24, 24);
        this.drawFont(matrix, "DEALER:  " + this.logic().value_dealer, 24, 40);
        if (this.logic().status == 1) {
            this.drawFontCenter(matrix, "Natural Draw!", 128, 176);
        }
        if (this.logic().turnstate == 2 && this.isActivePlayer()) {
            this.drawFontCenter(matrix, "Want another card ...?", 128, 192);
        }
        if (this.logic().turnstate == 2 && !this.isActivePlayer()) {
            this.drawFontCenter(matrix, "...", 128, 192);
        }
        if (this.logic().turnstate == 3) {
            this.drawFontCenter(matrix, "...", 128, 192);
        }
        if (this.logic().turnstate >= 4) {
            this.drawFontCenter(matrix, this.logic().hand, 128, 192);
        }
    }

    @Override
    protected void drawBackgroundLayer(PoseStack matrix, float partialTicks, int mouseX, int mouseY) {
        if (this.logic().turnstate >= 2) {
            int z;
            for (z = 0; z < this.logic().cards_player.size(); ++z) {
                if (this.logic().cards_player.get((int)z).idletimer != 0) continue;
                this.drawCard(matrix, 24 + 16 * z, 80 + 4 * z, this.logic().cards_player.get(z));
            }
            for (z = 0; z < this.logic().cards_dealer.size(); ++z) {
                if (this.logic().cards_dealer.get((int)z).idletimer != 0) continue;
                this.drawCard(matrix, 144 + 16 * z, 24 + 4 * z, this.logic().cards_dealer.get(z));
            }
        }
    }
}

