/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.screen.chip;

import com.mojang.blaze3d.vertex.PoseStack;
import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.logic.chip.LogicChipPink;
import mod.casinocraft.menu.MenuCasino;
import mod.casinocraft.screen.ScreenCasino;
import mod.casinocraft.util.Ship;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class ScreenChipPink
extends ScreenCasino {
    public ScreenChipPink(MenuCasino container, Inventory player, Component name) {
        super(container, player, name);
    }

    public LogicChipPink logic() {
        return (LogicChipPink)((MenuCasino)this.f_97732_).logic();
    }

    @Override
    protected String getGameName() {
        return "sokoban";
    }

    @Override
    protected void createGameButtons() {
    }

    @Override
    protected void interact(double mouseX, double mouseY, int mouseButton) {
    }

    @Override
    protected void drawForegroundLayer(PoseStack matrix, int mouseX, int mouseY) {
    }

    @Override
    protected void drawBackgroundLayer(PoseStack matrix, float partialTicks, int mouseX, int mouseY) {
        int y;
        int x;
        if (this.logic().turnstate == 2) {
            this.drawBackground(matrix, CasinoKeeper.TEXTURE_SOKOBAN, CasinoKeeper.TEXTURE_FONT_ARCADE);
            for (x = 0; x < 4; ++x) {
                for (y = 0; y < 5; ++y) {
                    int number = y * 4 + x + 1;
                    this.drawNumber(matrix, this.f_97735_ + 40 + 48 * x, this.f_97736_ + 14 + 34 * y, number / 10, number % 10, this.hasUnlocked(number), this.logic().mapID == number - 1);
                }
            }
        }
        if (this.logic().turnstate >= 3) {
            this.drawBackground(matrix, CasinoKeeper.TEXTURE_ARCADEDUMMY, CasinoKeeper.TEXTURE_ARCADE);
            for (x = 0; x < 12; ++x) {
                for (y = 0; y < 15; ++y) {
                    if (this.logic().grid[x][y] <= 0) continue;
                    this.drawDigi(matrix, 32 + x * 16, 8 + y * 16, 0, 0);
                }
            }
            for (Ship e : this.logic().cross) {
                this.drawShip(matrix, e, 4, 2, false);
            }
            for (Ship e : this.logic().crate) {
                this.drawShip(matrix, e, 4, 1, false);
            }
            this.drawShip(matrix, this.logic().octanom, 2, -1, true);
        }
    }

    private boolean hasUnlocked(int index) {
        for (int i = 0; i < 20; ++i) {
            if (this.logic().scoreHigh[i] != index) continue;
            return true;
        }
        return false;
    }

    private void drawNumber(PoseStack matrix, int x, int y, int left, int right, boolean colored, boolean highlighted) {
        int vOffset = 160 + (colored ? 48 : 0) + (highlighted ? 24 : 0);
        this.m_93228_(matrix, x, y, 16 * left, vOffset, 16, 24);
        this.m_93228_(matrix, x + 16, y, 16 * right, vOffset, 16, 24);
    }
}

