/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.util;

import mod.casinocraft.util.ActivatorFunction;
import mod.casinocraft.util.ButtonMap;
import mod.casinocraft.util.CommandFunction;
import mod.lucky77.util.Vector2;

public class Button {
    public Vector2 position;
    private Vector2 mapOFF;
    private Vector2 mapON;
    private int size;
    public boolean isActive;
    public boolean isSwitched;
    public boolean isHighlighted;
    private CommandFunction command;
    private ActivatorFunction activator;
    private int toggleID;
    private int timer;

    public Button(Vector2 position, Vector2 mapOFF, Vector2 mapON, int size, int toggleID, ActivatorFunction activator, CommandFunction command) {
        this.position = position;
        this.mapOFF = mapOFF;
        this.mapON = mapON;
        this.size = size;
        this.toggleID = toggleID;
        this.activator = activator;
        this.command = command;
        this.isActive = true;
        this.isSwitched = false;
        this.timer = 0;
    }

    public void collideWithMouse(int left, int top, double mouseX, double mouseY) {
        if (this.isActive && (double)(left + this.position.X) < mouseX && mouseX < (double)(left + this.position.X + this.width()) && (double)(top + this.position.Y) < mouseY && mouseY < (double)(top + this.position.Y + this.height())) {
            this.command.run();
            if (this.toggleID == 0) {
                boolean bl = this.isSwitched = !this.isSwitched;
            }
            if (this.toggleID > 0) {
                this.isSwitched = true;
                this.timer = this.toggleID;
            }
        }
    }

    public void update(int left, int top, double mouseX, double mouseY) {
        this.isActive = this.activator.run();
        if (this.isSwitched && this.toggleID > 0) {
            --this.timer;
            if (this.timer == 0) {
                this.isSwitched = false;
            }
        }
        if (this.isActive) {
            this.isHighlighted = false;
            if ((double)(left + this.position.X) < mouseX && mouseX < (double)(left + this.position.X + this.width()) && (double)(top + this.position.Y) < mouseY && mouseY < (double)(top + this.position.Y + this.height())) {
                this.isHighlighted = true;
            }
        }
    }

    public Vector2 map() {
        if (this.isSwitched) {
            return this.mapON;
        }
        return this.mapOFF;
    }

    public Vector2 highlight() {
        if (this.size == 0) {
            return ButtonMap.LIGHT_MICRO;
        }
        if (this.size == 1) {
            return ButtonMap.LIGHT_SMALL;
        }
        if (this.size == 2) {
            return ButtonMap.LIGHT_BASIC;
        }
        if (this.size == 3) {
            return ButtonMap.LIGHT_LARGE;
        }
        return ButtonMap.LIGHT_MICRO;
    }

    public int width() {
        if (this.size == 0) {
            return 14;
        }
        if (this.size == 1) {
            return 22;
        }
        if (this.size == 2) {
            return 39;
        }
        if (this.size == 3) {
            return 78;
        }
        return 0;
    }

    public int height() {
        if (this.size == 0) {
            return 14;
        }
        if (this.size == 1) {
            return 22;
        }
        if (this.size == 2) {
            return 22;
        }
        if (this.size == 3) {
            return 22;
        }
        return 0;
    }
}

