/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.util;

import java.util.ArrayList;
import java.util.List;
import mod.casinocraft.util.ActivatorFunction;
import mod.casinocraft.util.Button;
import mod.casinocraft.util.CommandFunction;
import mod.lucky77.util.Vector2;

public class ButtonSet {
    private List<Button> buttons = new ArrayList<Button>();
    private int index = -1;

    public void addButton(Vector2 position, Vector2 map, ActivatorFunction activator, CommandFunction command) {
        this.buttons.add(new Button(position, map, map, 3, -1, activator, command));
    }

    public void addButton(Vector2 position, Vector2 map, int size, ActivatorFunction activator, CommandFunction command) {
        this.buttons.add(new Button(position, map, map, size, -1, activator, command));
    }

    public void addButton(Vector2 position, Vector2 mapOFF, Vector2 mapON, int size, int toggleID, ActivatorFunction activator, CommandFunction command) {
        this.buttons.add(new Button(position, mapOFF, mapON, size, toggleID, activator, command));
    }

    public void update(int left, int top, double mouseX, double mouseY) {
        for (Button b : this.buttons) {
            b.update(left, top, mouseX, mouseY);
        }
    }

    public void interact(int left, int top, double mouseX, double mouseY) {
        for (Button b : this.buttons) {
            b.collideWithMouse(left, top, mouseX, mouseY);
        }
    }

    public void releaseToggle() {
        for (Button b : this.buttons) {
            b.isSwitched = false;
        }
    }

    public boolean next() {
        ++this.index;
        if (this.index >= this.buttons.size()) {
            this.index = -1;
            return false;
        }
        return true;
    }

    public Vector2 pos() {
        return this.buttons.get((int)this.index).position;
    }

    public Vector2 map() {
        return this.buttons.get(this.index).map();
    }

    public int sizeX() {
        return this.buttons.get(this.index).width();
    }

    public int sizeY() {
        return this.buttons.get(this.index).height();
    }

    public Vector2 highlight() {
        return this.buttons.get(this.index).highlight();
    }

    public boolean visible() {
        return this.buttons.get((int)this.index).isActive;
    }

    public boolean isHighlighted() {
        return this.visible() && this.buttons.get((int)this.index).isHighlighted;
    }
}

