/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.util;

import mod.lucky77.util.Vector2;

public class Ship {
    Vector2 position = new Vector2(0, 0);
    Vector2 next = new Vector2(0, 0);
    Vector2 velocity = new Vector2(0, 0);
    int lookDirection = 0;
    int hp = 0;
    public int ai = 0;

    public Ship(int _ai, Vector2 _position, Vector2 _next) {
        this.ai = _ai;
        this.position = _position;
        this.velocity = new Vector2(0, 0);
        this.next = _next;
    }

    public Ship(int _ai, Vector2 _position, Vector2 _velocity, Vector2 _next) {
        this.ai = _ai;
        this.position = _position;
        this.velocity = _velocity;
        this.next = _next;
        if (this.velocity.X < 0) {
            this.lookDirection = 2;
        }
        if (this.velocity.X > 0) {
            this.lookDirection = 3;
        }
        if (this.velocity.Y < 0) {
            this.lookDirection = 0;
        }
        if (this.velocity.Y > 0) {
            this.lookDirection = 1;
        }
    }

    public void update() {
        if (this.ai == 0) {
            this.position.add(this.velocity);
        } else if (!this.velocity.matches(0, 0)) {
            this.position.add(this.velocity);
            if (this.velocity.X < 0 && this.position.X <= this.next.X) {
                this.velocity.set(0, 0);
                this.position.set(this.next);
            }
            if (this.velocity.X > 0 && this.position.X >= this.next.X) {
                this.velocity.set(0, 0);
                this.position.set(this.next);
            }
            if (this.velocity.Y < 0 && this.position.Y <= this.next.Y) {
                this.velocity.set(0, 0);
                this.position.set(this.next);
            }
            if (this.velocity.Y > 0 && this.position.Y >= this.next.Y) {
                this.velocity.set(0, 0);
                this.position.set(this.next);
            }
        }
    }

    public Vector2 getPos() {
        return this.position;
    }

    public Vector2 getVel() {
        return this.velocity;
    }

    public Vector2 getNext() {
        return this.next;
    }

    public int getHP() {
        return this.hp;
    }

    public Vector2 getGrid() {
        return new Vector2(this.position.X / 16, this.position.Y / 16);
    }

    public int getLookDirection() {
        return this.lookDirection;
    }

    public void setPos(int x, int y) {
        this.position.set(x, y);
    }

    public void setHP(int i) {
        this.hp = i;
    }

    public void setNext(Vector2 i) {
        this.next.set(i);
    }

    public void changeHP(int i) {
        this.hp += i;
    }

    public void setInMotion(int x, int y) {
        this.velocity.set(x, y);
        if (this.velocity.X < 0) {
            this.lookDirection = 2;
        }
        if (this.velocity.X > 0) {
            this.lookDirection = 3;
        }
        if (this.velocity.Y < 0) {
            this.lookDirection = 0;
        }
        if (this.velocity.Y > 0) {
            this.lookDirection = 1;
        }
        if (this.velocity.Y < 0) {
            this.next.Y -= 16;
        }
        if (this.velocity.Y > 0) {
            this.next.Y += 16;
        }
        if (this.velocity.X < 0) {
            this.next.X -= 16;
        }
        if (this.velocity.X > 0) {
            this.next.X += 16;
        }
    }

    public boolean isMoving() {
        return this.velocity.X != 0 || this.velocity.Y != 0;
    }

    public void setVel(int x, int y) {
        this.velocity.set(x, y);
    }
}

