/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe;

import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.TagIngredientJS;
import dev.latvian.mods.kubejs.recipe.RecipeEventJS;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeTypeJS;
import dev.latvian.mods.kubejs.recipe.minecraft.CustomRecipeJS;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.WrappedJS;
import dev.latvian.mods.rhino.BaseFunction;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.Scriptable;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class RecipeFunction
extends BaseFunction
implements WrappedJS {
    private static final Pattern SKIP_ERROR = Pattern.compile("at dev.latvian.mods.kubejs.recipe.RecipeFunction.call");
    private final RecipeEventJS event;
    public final ResourceLocation typeID;
    public final RecipeTypeJS type;

    public RecipeFunction(RecipeEventJS e, ResourceLocation id, @Nullable RecipeTypeJS t) {
        this.event = e;
        this.typeID = id;
        this.type = t;
    }

    public RecipeJS call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args0) {
        return this.createRecipe(args0);
    }

    public RecipeJS createRecipe(Object[] args0) {
        try {
            MapJS map;
            if (this.type == null) {
                throw new RecipeExceptionJS("Unknown recipe type!");
            }
            ListJS args = ListJS.of(args0);
            if (args == null || args.isEmpty()) {
                throw new RecipeExceptionJS("Recipe requires at least one argument!");
            }
            if (this.type.isCustom() && args.size() != 1) {
                throw new RecipeExceptionJS("Custom recipe has to use a single json object argument!");
            }
            if (args.size() == 1 && (map = MapJS.of(args.get(0))) != null) {
                RecipeJS recipe = this.type.factory.get();
                recipe.type = this.type;
                recipe.json = ((MapJS)this.normalize(map)).toJson();
                if (!(recipe instanceof CustomRecipeJS)) {
                    recipe.serializeInputs = true;
                    recipe.serializeOutputs = true;
                    recipe.deserializeJson();
                }
                return this.event.addRecipe(recipe, this.type, args);
            }
            RecipeJS recipe = this.type.factory.get();
            recipe.type = this.type;
            recipe.json = new JsonObject();
            recipe.serializeInputs = true;
            recipe.serializeOutputs = true;
            recipe.create(args);
            return this.event.addRecipe(recipe, this.type, args);
        }
        catch (RecipeExceptionJS ex) {
            ex.error();
            ConsoleJS.SERVER.error("Failed to create recipe for type '" + this.typeID + "'", ex, SKIP_ERROR);
        }
        catch (Exception ex) {
            ConsoleJS.SERVER.printStackTrace(ex, SKIP_ERROR);
        }
        return new CustomRecipeJS();
    }

    private Object normalize(Object o) {
        if (o instanceof ItemStackJS) {
            ItemStackJS stack = (ItemStackJS)o;
            return stack.toResultJson();
        }
        if (o instanceof IngredientJS) {
            IngredientJS ingr = (IngredientJS)o;
            return ingr.toJson();
        }
        if (o instanceof String) {
            String s = (String)o;
            if (s.length() >= 4 && s.startsWith("#") && s.indexOf(58) != -1) {
                return TagIngredientJS.createTag(s.substring(1)).toJson();
            }
            return o;
        }
        if (o instanceof ListJS) {
            ListJS list = new ListJS();
            for (Object o1 : (ListJS)o) {
                list.add(this.normalize(o1));
            }
            return list;
        }
        if (o instanceof MapJS) {
            MapJS map = new MapJS();
            for (Map.Entry entry : ((MapJS)o).entrySet()) {
                map.put((String)entry.getKey(), this.normalize(entry.getValue()));
            }
            return map;
        }
        return o;
    }

    public String toString() {
        return this.typeID.toString();
    }
}

