/*
 * Decompiled with CFR 0.152.
 */
package com.mars.deimos.config;

import com.google.common.collect.Lists;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mars.deimos.platform.Services;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.io.Reader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public abstract class DeimosConfig {
    private static final Pattern INTEGER_ONLY = Pattern.compile("(-?[0-9]*)");
    private static final Pattern DECIMAL_ONLY = Pattern.compile("-?(\\d+\\.?\\d*|\\d*\\.?\\d+|\\.)");
    private static final Pattern HEXADECIMAL_ONLY = Pattern.compile("(-?[#0-9a-fA-F]*)");
    private static final List<EntryInfo> entries = new ArrayList<EntryInfo>();
    public static final Map<String, Class<? extends DeimosConfig>> configClass = new HashMap<String, Class<? extends DeimosConfig>>();
    private static Path path;
    private static final Gson gson;

    @Nullable
    public static Object getDefaultValue(String modid, String entry) {
        for (EntryInfo e : entries) {
            if (!modid.equals(e.modid) || !entry.equals(e.field.getName())) continue;
            return e.defaultValue;
        }
        return null;
    }

    public static void init(String modid, Class<? extends DeimosConfig> config) {
        path = Services.PLATFORM.getConfigDirectory().resolve(modid + ".json");
        configClass.put(modid, config);
        for (Field field : config.getFields()) {
            EntryInfo info = new EntryInfo();
            if ((field.isAnnotationPresent(Entry.class) || field.isAnnotationPresent(Comment.class)) && !field.isAnnotationPresent(Server.class) && !field.isAnnotationPresent(Hidden.class) && Services.PLATFORM.isClientEnv()) {
                DeimosConfig.initClient(modid, field, info);
            }
            if (field.isAnnotationPresent(Comment.class)) {
                info.centered = field.getAnnotation(Comment.class).centered();
            }
            if (!field.isAnnotationPresent(Entry.class)) continue;
            try {
                info.defaultValue = field.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        try {
            gson.fromJson((Reader)Files.newBufferedReader(path), config);
        }
        catch (Exception e) {
            DeimosConfig.write(modid);
        }
        for (EntryInfo info : entries) {
            if (!info.field.isAnnotationPresent(Entry.class)) continue;
            try {
                info.value = info.field.get(null);
                info.tempValue = info.toTemporaryValue();
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    private static void initClient(String modid, Field field, EntryInfo info) {
        info.dataType = DeimosConfig.getUnderlyingType(field);
        Entry e = field.getAnnotation(Entry.class);
        info.width = e != null ? e.width() : 0;
        info.field = field;
        info.modid = modid;
        if (e != null) {
            if (!e.name().isEmpty()) {
                info.name = new TranslatableComponent(e.name());
            }
            if (info.dataType == Integer.TYPE) {
                DeimosConfig.textField(info, Integer::parseInt, INTEGER_ONLY, (int)e.min(), (int)e.max(), true);
            } else if (info.dataType == Float.TYPE) {
                DeimosConfig.textField(info, Float::parseFloat, DECIMAL_ONLY, (float)e.min(), (float)e.max(), false);
            } else if (info.dataType == Double.TYPE) {
                DeimosConfig.textField(info, Double::parseDouble, DECIMAL_ONLY, e.min(), e.max(), false);
            } else if (info.dataType == String.class || info.dataType == ResourceLocation.class) {
                DeimosConfig.textField(info, String::length, null, Math.min(e.min(), 0.0), Math.max(e.max(), 1.0), true);
            } else if (info.dataType == Boolean.TYPE) {
                Function<Object, Component> func = value -> new TranslatableComponent((Boolean)value != false ? "gui.yes" : "gui.no").m_130940_((Boolean)value != false ? ChatFormatting.GREEN : ChatFormatting.RED);
                info.function = new AbstractMap.SimpleEntry<Button.OnPress, Function<Object, Component>>(button -> {
                    info.setValue((Boolean)info.value == false);
                    button.m_93666_((Component)func.apply(info.value));
                }, func);
            } else if (info.dataType.isEnum()) {
                List<?> values = Arrays.asList(field.getType().getEnumConstants());
                Function<Object, Component> func = value -> new TranslatableComponent(modid + ".deimosconfig.enum." + modid + "." + info.dataType.getSimpleName());
                info.function = new AbstractMap.SimpleEntry<Button.OnPress, Function<Object, Component>>(button -> {
                    int index = values.indexOf(info.value) + 1;
                    info.value = values.get(index >= values.size() ? 0 : index);
                    button.m_93666_((Component)func.apply(info.value));
                }, func);
            }
        }
        entries.add(info);
    }

    public static Class<?> getUnderlyingType(Field field) {
        if (field.getType() == List.class) {
            Class listType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
            try {
                return (Class)listType.getField("TYPE").get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException ignored) {
                return listType;
            }
        }
        return field.getType();
    }

    private static void textField(EntryInfo info, Function<String, Number> f, Pattern pattern, double min, double max, boolean cast) {
        boolean isNumber = pattern != null;
        info.function = (t, b) -> s -> {
            if (!((String)(s = ((String)s).trim())).isEmpty() && isNumber && !pattern.matcher((CharSequence)s).matches()) {
                return false;
            }
            Number value = 0;
            boolean inLimits = false;
            info.error = null;
            if (!(isNumber && ((String)s).isEmpty() || ((String)s).equals("-") || ((String)s).equals("."))) {
                try {
                    value = (Number)f.apply((String)s);
                }
                catch (NumberFormatException e2) {
                    return false;
                }
                boolean bl = inLimits = value.doubleValue() >= min && value.doubleValue() <= max;
                info.error = inLimits ? null : new TextComponent(value.doubleValue() < min ? "\u00c2\u00a7cMinimum " + (isNumber ? "value" : "length") + (cast ? " is " + (int)min : " is " + min) : "\u00c2\u00a7cMaximum " + (isNumber ? "value" : "length") + (cast ? " is " + (int)max : " is " + max)).m_130940_(ChatFormatting.RED);
            }
            info.tempValue = s;
            t.m_94202_(inLimits ? -1 : -34953);
            info.inLimits = inLimits;
            b.f_93623_ = entries.stream().allMatch(e -> e.inLimits);
            if (inLimits) {
                if (info.dataType == ResourceLocation.class) {
                    info.setValue(ResourceLocation.m_135820_((String)s));
                } else {
                    info.setValue(isNumber ? value : s);
                }
            }
            if (info.field.getAnnotation(Entry.class).isColor()) {
                if (!((String)s).contains("#")) {
                    s = "#" + (String)s;
                }
                if (!HEXADECIMAL_ONLY.matcher((CharSequence)s).matches()) {
                    return false;
                }
                try {
                    info.actionButton.m_93666_((Component)new TextComponent("\u00e2\u00ac\u203a").m_6270_(Style.f_131099_.m_178520_(Color.decode(info.tempValue).getRGB())));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        };
    }

    public static DeimosConfig getClass(String modid) {
        try {
            return configClass.get(modid).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void write(String modid) {
        DeimosConfig.getClass(modid).writeChanges(modid);
    }

    public void writeChanges(String modid) {
        try {
            path = Services.PLATFORM.getConfigDirectory().resolve(modid + ".json");
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
            }
            Files.write(path, gson.toJson((Object)DeimosConfig.getClass(modid)).getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            e.fillInStackTrace();
        }
    }

    static {
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).excludeFieldsWithModifiers(new int[]{2}).addSerializationExclusionStrategy((ExclusionStrategy)new HiddenAnnotationExclusionStrategy()).registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).setPrettyPrinting().create();
    }

    public static class EntryInfo {
        Field field;
        Class<?> dataType;
        int width;
        int listIndex;
        boolean centered;
        Object defaultValue;
        Object value;
        Object function;
        String modid;
        String tempValue;
        boolean inLimits = true;
        Component name;
        Component error;
        AbstractWidget actionButton;

        public void setValue(Object value) {
            if (this.field.getType() != List.class) {
                this.value = value;
                this.tempValue = value.toString();
            } else {
                this.writeList(this.listIndex, value);
                this.tempValue = this.toTemporaryValue();
            }
        }

        public String toTemporaryValue() {
            if (this.field.getType() != List.class) {
                return this.value.toString();
            }
            try {
                return ((List)this.value).get(this.listIndex).toString();
            }
            catch (Exception ignored) {
                return "";
            }
        }

        public <T> void writeList(int index, T value) {
            List list = (List)this.value;
            if (index >= list.size()) {
                list.add(value);
            } else {
                list.set(index, value);
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Entry {
        public int width() default 400;

        public double min() default 2.2250738585072014E-308;

        public double max() default 1.7976931348623157E308;

        public String name() default "";

        public int selectionMode() default -1;

        public int fileChooserType() default 0;

        public String[] fileExtensions() default {"*"};

        public int idMode() default -1;

        public boolean isColor() default false;

        public boolean isSlider() default false;

        public int precision() default 100;

        public String category() default "default";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Comment {
        public boolean centered() default false;

        public String category() default "default";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Server {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Hidden {
    }

    public static class HiddenAnnotationExclusionStrategy
    implements ExclusionStrategy {
        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            return fieldAttributes.getAnnotation(Entry.class) == null;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Client {
    }

    public static class DeimosSliderWidget
    extends AbstractSliderButton {
        private final EntryInfo info;
        private final Entry e;

        public DeimosSliderWidget(int x, int y, int width, int height, Component text, double value, EntryInfo info) {
            super(x, y, width, height, text, value);
            this.e = info.field.getAnnotation(Entry.class);
            this.info = info;
        }

        public void m_5695_() {
            this.m_93666_(Component.m_130674_((String)this.info.tempValue));
        }

        public void m_5697_() {
            if (this.info.dataType == Integer.TYPE) {
                this.info.setValue(Double.valueOf(this.e.min() + this.f_93577_ * (this.e.max() - this.e.min())).intValue());
            } else if (this.info.field.getType() == Double.TYPE) {
                this.info.setValue(Math.round((this.e.min() + this.f_93577_ * (this.e.max() - this.e.min())) * (double)this.e.precision()) / (long)this.e.precision());
            } else if (this.info.field.getType() == Float.TYPE) {
                this.info.setValue(Float.valueOf((float)Math.round((this.e.min() + this.f_93577_ * (this.e.max() - this.e.min())) * (double)this.e.precision()) / (float)this.e.precision()));
            }
        }
    }

    public static class ButtonEntry
    extends ContainerObjectSelectionList.Entry<ButtonEntry> {
        private static final Font textRenderer = Minecraft.m_91087_().f_91062_;
        public final Component text;
        public final List<AbstractWidget> buttons;
        public final EntryInfo info;
        public boolean centered = false;

        public ButtonEntry(List<AbstractWidget> buttons, Component text, EntryInfo info) {
            this.buttons = buttons;
            this.text = text;
            this.info = info;
            if (info != null) {
                this.centered = info.centered;
            }
        }

        public void m_6311_(PoseStack context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.buttons.forEach(b -> {
                b.f_93621_ = y;
                b.m_6305_(context, mouseX, mouseY, tickDelta);
            });
            if (!(this.text == null || this.text.getString().contains("spacer") && this.buttons.isEmpty())) {
                int wrappedY = y;
                Iterator textIterator = textRenderer.m_92923_((FormattedText)this.text, this.buttons.size() > 1 ? this.buttons.get((int)1).f_93620_ - 24 : Minecraft.m_91087_().m_91268_().m_85445_() - 24).iterator();
                while (textIterator.hasNext()) {
                    GuiComponent.m_168756_((PoseStack)context, (Font)textRenderer, (FormattedCharSequence)((FormattedCharSequence)textIterator.next()), (int)12, (int)(wrappedY + 5), (int)0xFFFFFF);
                    wrappedY += 9;
                }
            }
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Lists.newArrayList(this.buttons);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return Lists.newArrayList(this.buttons);
        }
    }

    public static class DeimosConfigListWidget
    extends ContainerObjectSelectionList<ButtonEntry> {
        public boolean renderHeaderSeparator = true;

        public DeimosConfigListWidget(Minecraft client, int i, int j, int k, int l, int m) {
            super(client, i, j, k, l, m);
        }

        public int m_5756_() {
            return this.f_93388_ - 7;
        }

        public void addButton(List<AbstractWidget> buttons, Component text, EntryInfo info) {
            this.m_7085_((AbstractSelectionList.Entry)new ButtonEntry(buttons, text, info));
        }

        public void clear() {
            this.m_93516_();
        }

        public int m_5759_() {
            return 10000;
        }
    }

    public static class DeimosConfigScreen
    extends Screen {
        public final String translationPrefix;
        public final String modid;
        public final Screen parent;
        public DeimosConfigListWidget list;
        public Button done;
        public double scrollProgress = 0.0;

        public static Screen getScreen(Screen parent, String modid) {
            return new DeimosConfigScreen(parent, modid);
        }

        protected DeimosConfigScreen(Screen parent, String modid) {
            super((Component)new TranslatableComponent(modid + ".deimosconfig.title"));
            this.parent = parent;
            this.modid = modid;
            this.translationPrefix = modid + ".deimosconfig.";
            this.loadValues();
            for (EntryInfo e : entries) {
                String tabId;
                if (!e.modid.equals(modid)) continue;
                String string = tabId = e.field.isAnnotationPresent(Entry.class) ? e.field.getAnnotation(Entry.class).category() : e.field.getAnnotation(Comment.class).category();
                String name = this.translationPrefix + "category." + this.translationPrefix;
                if (I18n.m_118936_((String)name) || !tabId.equals("default")) continue;
                name = this.translationPrefix + "title";
            }
        }

        public void m_96624_() {
            super.m_96624_();
            this.scrollProgress = this.list.m_93517_();
            for (EntryInfo info : entries) {
                try {
                    info.field.set(null, info.value);
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            this.updateButtons();
        }

        public void updateButtons() {
            if (this.list != null) {
                for (ButtonEntry entry : this.list.m_6702_()) {
                    if (entry.buttons == null || entry.buttons.size() <= 1) continue;
                    AbstractWidget abstractWidget = entry.buttons.get(0);
                    abstractWidget = entry.buttons.get(1);
                    if (!(abstractWidget instanceof Button)) continue;
                    Button button = (Button)abstractWidget;
                    button.f_93623_ = !Objects.equals(entry.info.value.toString(), entry.info.defaultValue.toString());
                }
            }
        }

        public void loadValues() {
            try {
                gson.fromJson((Reader)Files.newBufferedReader(path), configClass.get(this.modid));
            }
            catch (Exception e) {
                DeimosConfig.write(this.modid);
            }
            for (EntryInfo info : entries) {
                if (!info.field.isAnnotationPresent(Entry.class)) continue;
                try {
                    info.value = info.field.get(null);
                    info.tempValue = info.toTemporaryValue();
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            return super.m_7933_(keyCode, scanCode, modifiers);
        }

        public void m_7379_() {
            this.loadValues();
            this.cleanup();
            Objects.requireNonNull(this.f_96541_).m_91152_(this.parent);
        }

        private void cleanup() {
            entries.forEach(info -> {
                info.error = null;
                info.value = null;
                info.tempValue = null;
                info.actionButton = null;
                info.listIndex = 0;
                info.inLimits = true;
            });
        }

        public void m_7856_() {
            super.m_7856_();
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 154, this.f_96544_ - 28, 150, 20, CommonComponents.f_130656_, button -> {
                this.loadValues();
                Objects.requireNonNull(this.f_96541_).m_91152_(this.parent);
            }));
            this.done = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 4, this.f_96544_ - 28, 150, 20, CommonComponents.f_130655_, button -> {
                for (EntryInfo info : entries) {
                    if (!info.modid.equals(this.modid)) continue;
                    try {
                        info.field.set(null, info.value);
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                }
                DeimosConfig.write(this.modid);
                this.cleanup();
                Objects.requireNonNull(this.f_96541_).m_91152_(this.parent);
            }));
            this.list = new DeimosConfigListWidget(this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 25);
            this.m_7787_((GuiEventListener)this.list);
            this.fillList();
        }

        public void fillList() {
            for (EntryInfo info : entries) {
                if (info.modid.equals(this.modid)) {
                    Component name = Objects.requireNonNullElseGet(info.name, () -> new TranslatableComponent(this.translationPrefix + info.field.getName()));
                    Button resetButton = new Button(this.f_96543_ - 205 + 150 + 25, 0, 20, 20, (Component)new TextComponent("R").m_130940_(ChatFormatting.RED), button -> {
                        info.value = info.defaultValue;
                        info.tempValue = info.defaultValue.toString();
                        info.listIndex = 0;
                        double scrollAmount = this.list.m_93517_();
                        Objects.requireNonNull(this.f_96541_).m_91152_((Screen)this);
                        this.list.m_93410_(scrollAmount);
                    });
                    if (info.function != null) {
                        Object editBox;
                        Entry e = info.field.getAnnotation(Entry.class);
                        if (info.function instanceof Map.Entry) {
                            Map.Entry values = (Map.Entry)info.function;
                            if (info.dataType.isEnum()) {
                                values.setValue(value -> new TranslatableComponent(this.translationPrefix + "enum." + this.translationPrefix + "." + info.field.getType().getSimpleName()));
                            }
                            editBox = new Button(this.f_96543_ - 185, 0, 150, 20, (Component)((Function)values.getValue()).apply(info.value), (Button.OnPress)values.getKey());
                        } else {
                            editBox = e.isSlider() ? new DeimosSliderWidget(this.f_96543_ - 185, 0, 150, 20, Component.m_130674_((String)info.tempValue), (Double.parseDouble(info.tempValue) - e.min()) / (e.max() - e.min()), info) : new EditBox(this.f_96547_, this.f_96543_ - 185, 0, 150, 20, null);
                        }
                        if (editBox instanceof EditBox) {
                            EditBox textField = editBox;
                            textField.m_94199_(info.width);
                            textField.m_94144_(info.tempValue);
                            Predicate processor = (Predicate)((BiFunction)info.function).apply(textField, this.done);
                            textField.m_94153_(processor);
                        }
                        Button cycleButton = null;
                        if (info.field.getType() == List.class) {
                            cycleButton = new Button(this.f_96543_ - 185, 0, 20, 20, (Component)new TextComponent(String.valueOf(info.listIndex)).m_130940_(ChatFormatting.GOLD), button -> {
                                List values = (List)info.value;
                                values.remove("");
                                ++info.listIndex;
                                if (info.listIndex > values.size()) {
                                    info.listIndex = 0;
                                }
                                info.tempValue = info.toTemporaryValue();
                                if (info.listIndex == values.size()) {
                                    info.tempValue = "";
                                }
                                this.list.clear();
                                this.fillList();
                            });
                        }
                        if (e.isColor()) {
                            Button colorButton = new Button(this.f_96543_ - 185, 0, 20, 20, (Component)new TextComponent("\u00e2\u00ac\u203a"), button -> {});
                            try {
                                colorButton.m_93666_((Component)new TextComponent("\u00e2\u00ac\u203a").m_6270_(Style.f_131099_.m_178520_(Color.decode(info.tempValue).getRGB())));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            info.actionButton = colorButton;
                        }
                        ArrayList widgets = Lists.newArrayList((Object[])new AbstractWidget[]{editBox, resetButton});
                        if (info.actionButton != null) {
                            if (Minecraft.f_91002_) {
                                info.actionButton.f_93623_ = false;
                            }
                            editBox.m_93674_(editBox.m_5711_() - 22);
                            editBox.f_93620_ += 22;
                            widgets.add(info.actionButton);
                        }
                        if (cycleButton != null) {
                            if (info.actionButton != null) {
                                info.actionButton.f_93620_ += 22;
                            }
                            editBox.m_93674_(editBox.m_5711_() - 22);
                            editBox.f_93620_ += 22;
                            widgets.add(cycleButton);
                        }
                        this.list.addButton(widgets, name, info);
                    } else {
                        this.list.addButton(List.of(), name, info);
                    }
                }
                this.list.m_93410_(this.scrollProgress);
                this.updateButtons();
            }
        }

        public void m_6305_(PoseStack context, int mouseX, int mouseY, float delta) {
            this.list.m_6305_(context, mouseX, mouseY, delta);
            DeimosConfigScreen.m_93215_((PoseStack)context, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)15, (int)0xFFFFFF);
            super.m_6305_(context, mouseX, mouseY, delta);
        }
    }
}

