/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.addons.top;

import java.util.function.Function;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.styles.ProgressStyle;
import net.darkhax.botanypots.block.BlockEntityBotanyPot;
import net.darkhax.botanypots.block.inv.BotanyPotContainer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TOPPlugin
implements IProbeInfoProvider,
Function<ITheOneProbe, Void> {
    private static final ResourceLocation PLUGIN_ID = new ResourceLocation("botanypots", "top_pot_info");
    private static final Component HARVESTABLE = new TranslatableComponent("tooltip.botanypots.harvestable").m_130940_(ChatFormatting.GREEN);

    public ResourceLocation getID() {
        return PLUGIN_ID;
    }

    @Override
    public Void apply(ITheOneProbe probeMod) {
        probeMod.registerProvider((IProbeInfoProvider)this);
        return null;
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo info, Player player, Level level, BlockState state, IProbeHitData data) {
        BlockEntity blockEntity = level.m_7702_(data.getPos());
        if (blockEntity instanceof BlockEntityBotanyPot) {
            BlockEntityBotanyPot pot = (BlockEntityBotanyPot)blockEntity;
            BotanyPotContainer inv = (BotanyPotContainer)pot.getInventory();
            if (!inv.getSoilStack().m_41619_()) {
                IProbeInfo soilInfo = info.horizontal(info.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
                soilInfo.item(inv.getSoilStack());
                soilInfo.mcText((Component)new TranslatableComponent("tooltip.botanypots.soil", new Object[]{inv.getSoilStack().m_41786_()}));
            }
            if (!inv.getCropStack().m_41619_()) {
                IProbeInfo seedInfo = info.horizontal(info.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
                seedInfo.item(inv.getCropStack());
                seedInfo.mcText((Component)new TranslatableComponent("tooltip.botanypots.seed", new Object[]{inv.getCropStack().m_41786_()}));
            }
            if (pot.isGrowing()) {
                int currentTime = pot.getGrowthTime();
                int requiredTime = inv.getRequiredGrowthTime();
                int remainingTime = requiredTime - currentTime;
                if (remainingTime > 0) {
                    info.mcText((Component)new TranslatableComponent("tooltip.botanypots.time", new Object[]{StringUtil.m_14404_((int)(requiredTime - currentTime))}));
                    ProgressStyle progressStyle = new ProgressStyle();
                    progressStyle.filledColor(-13447886);
                    progressStyle.alternateFilledColor(-14313179);
                    progressStyle.prefix("tooltip.botanypots.progress");
                    progressStyle.suffix("%");
                    int f = Mth.m_14143_((float)((float)currentTime / (float)requiredTime * 100.0f));
                    info.progress(f, 100, (IProgressStyle)progressStyle);
                } else {
                    info.mcText(HARVESTABLE);
                }
            }
        }
    }
}

