/*
 * Decompiled with CFR 0.152.
 */
package net.lmor.botanicalextramachinery.blocks.base;

import com.google.common.collect.Streams;
import de.melanx.botanicalmachinery.blocks.base.BotanicalTile;
import io.github.noeppi_noeppi.libx.crafting.recipe.RecipeHelper;
import io.github.noeppi_noeppi.libx.inventory.IAdvancedItemHandlerModifiable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.lib.ModTags;

public abstract class RecipeTile<T extends Recipe<Container>>
extends BotanicalTile {
    private final RecipeType<T> recipeType;
    private final int firstInputSlot;
    private final int firstOutputSlot;
    protected T recipe;
    private boolean needsRecipeUpdate;
    private final int countCraft;
    private int countCraftPerRecipe;

    public RecipeTile(BlockEntityType<?> blockEntityType, RecipeType<T> recipeType, BlockPos pos, BlockState state, int manaCap, int firstInputSlot, int firstOutputSlot, int countCraft) {
        super(blockEntityType, pos, state, manaCap);
        this.recipeType = recipeType;
        this.firstInputSlot = firstInputSlot;
        this.firstOutputSlot = firstOutputSlot;
        this.needsRecipeUpdate = true;
        this.countCraft = countCraft;
        this.countCraftPerRecipe = countCraft;
    }

    public int getCountCraft() {
        return this.countCraftPerRecipe;
    }

    protected void updateRecipeIfNeeded() {
        this.updateRecipeIfNeeded(() -> {}, (stack, slot) -> {});
    }

    protected void updateRecipeIfNeeded(Runnable doUpdate, BiConsumer<ItemStack, Integer> usedStacks) {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && this.needsRecipeUpdate) {
            this.needsRecipeUpdate = false;
            doUpdate.run();
            this.updateRecipe(usedStacks);
        }
    }

    protected void updateRecipe() {
        this.updateRecipe((stack, slot) -> {});
    }

    public int getCountCraftPerRecipe() {
        return this.countCraftPerRecipe;
    }

    protected void updateRecipe(BiConsumer<ItemStack, Integer> usedStacks) {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            if (!this.canMatchRecipes()) {
                this.recipe = null;
            } else {
                Recipe recipe;
                IAdvancedItemHandlerModifiable inventory = this.getInventory().getUnrestricted();
                IntStream range = IntStream.range(this.firstInputSlot, this.firstOutputSlot);
                Objects.requireNonNull(inventory);
                List<ItemStack> stacks = range.mapToObj(arg_0 -> ((IAdvancedItemHandlerModifiable)inventory).getStackInSlot(arg_0)).toList();
                Iterator iterator = this.f_58857_.m_7465_().m_44013_(this.recipeType).iterator();
                do {
                    if (iterator.hasNext()) continue;
                    this.recipe = null;
                    return;
                } while (!this.matchRecipe(recipe = (Recipe)iterator.next(), stacks));
                ArrayList<ItemStack> consumedStacks = new ArrayList<ItemStack>();
                Iterator iteratorRecipe = recipe.m_7527_().iterator();
                this.countCraftPerRecipe = this.maxCountCraft(iteratorRecipe, stacks);
                if (recipe.m_8043_().m_41613_() != 0) {
                    int currentStackSize;
                    int maxStackSize;
                    int availableSpace;
                    int itemsToPlaceInSlot;
                    Object slotStack;
                    int remainingItemsToPlace = recipe.m_8043_().m_41613_() != 0 ? this.countCraftPerRecipe * recipe.m_8043_().m_41613_() : this.countCraftPerRecipe;
                    for (int slot = this.firstOutputSlot; slot < inventory.getSlots() && (!(slotStack = inventory.getStackInSlot(slot)).m_41619_() && !slotStack.m_41656_(recipe.m_8043_()) || (remainingItemsToPlace -= (itemsToPlaceInSlot = Math.min(remainingItemsToPlace, availableSpace = (maxStackSize = recipe.m_8043_().m_41741_()) - (currentStackSize = slotStack.m_41613_())))) > 0); ++slot) {
                    }
                    if (remainingItemsToPlace < this.countCraftPerRecipe * recipe.m_8043_().m_41613_()) {
                        this.countCraftPerRecipe -= remainingItemsToPlace / recipe.m_8043_().m_41613_();
                    } else if (remainingItemsToPlace >= this.countCraftPerRecipe * recipe.m_8043_().m_41613_()) {
                        this.recipe = null;
                        return;
                    }
                }
                if (recipe.m_6671_() == ModRecipeTypes.RUNE_TYPE) {
                    ArrayList<ItemStack> inputItemRes = new ArrayList<ItemStack>();
                    iteratorRecipe = recipe.m_7527_().iterator();
                    while (iteratorRecipe.hasNext()) {
                        Ingredient ingredient = (Ingredient)iteratorRecipe.next();
                        for (ItemStack itemStack : Arrays.stream(ingredient.m_43908_()).toList()) {
                            inputItemRes.add(itemStack);
                        }
                    }
                    List res = Streams.concat((Stream[])new Stream[]{inputItemRes.stream().filter(s -> s.m_204117_(ModTags.Items.RUNES)).map(ItemStack::m_41777_)}).toList();
                    if (res.size() != 0) {
                        int emptySlot = 0;
                        for (int slot = this.firstOutputSlot; slot < inventory.getSlots(); ++slot) {
                            ItemStack slotItem = inventory.getStackInSlot(slot);
                            if (!slotItem.m_41619_()) continue;
                            ++emptySlot;
                        }
                        if (emptySlot == 0 || emptySlot < res.size() + 1) {
                            this.recipe = null;
                            return;
                        }
                    }
                }
                block5: while (iteratorRecipe.hasNext()) {
                    Ingredient ingredient = (Ingredient)iteratorRecipe.next();
                    for (int stackIdx = 0; stackIdx < stacks.size(); ++stackIdx) {
                        if (!ingredient.test(stacks.get(stackIdx))) continue;
                        ItemStack theStack = stacks.get(stackIdx).m_41777_();
                        theStack.m_41764_(this.countCraftPerRecipe);
                        consumedStacks.add(theStack.m_41777_());
                        usedStacks.accept(theStack, this.firstInputSlot + stackIdx);
                        continue block5;
                    }
                }
                List<ItemStack> resultItems = this.resultItems(recipe, consumedStacks);
                this.recipe = !resultItems.isEmpty() && !inventory.hasSpaceFor(resultItems, this.firstOutputSlot, inventory.getSlots()) ? null : recipe;
                return;
            }
        }
    }

    public int maxCountCraft(Iterator iteratorRecipe, List<ItemStack> stacks) {
        HashMap<Item, Integer> iteratorMap = new HashMap<Item, Integer>();
        HashMap<Item, Integer> allIngredients = new HashMap<Item, Integer>();
        int count = 9999999;
        while (iteratorRecipe.hasNext()) {
            Ingredient ingredient = (Ingredient)iteratorRecipe.next();
            for (ItemStack itemStack : Arrays.stream(ingredient.m_43908_()).toList()) {
                iteratorMap.merge(itemStack.m_41720_().m_5456_(), itemStack.m_41613_(), Integer::sum);
            }
        }
        for (int stackIdx = this.firstInputSlot; stackIdx < this.firstOutputSlot; ++stackIdx) {
            ItemStack theStack = this.getInventory().getStackInSlot(stackIdx);
            if (theStack.m_41619_()) continue;
            for (Item item : iteratorMap.keySet()) {
                if (item != theStack.m_41720_().m_5456_()) continue;
                allIngredients.merge(theStack.m_41720_().m_5456_(), theStack.m_41613_(), Integer::sum);
            }
        }
        block4: for (Item itemIngredient : allIngredients.keySet()) {
            int n = (Integer)allIngredients.get(itemIngredient);
            for (Item itemDefaultIngredient : iteratorMap.keySet()) {
                if (itemDefaultIngredient != itemIngredient) continue;
                int count_item = (Integer)iteratorMap.get(itemDefaultIngredient);
                int min_craft = Math.min(n, n / count_item);
                if (min_craft >= count) continue block4;
                count = min_craft;
                continue block4;
            }
        }
        count = Math.min(this.countCraft, count);
        return count;
    }

    protected void craftRecipe() {
        this.craftRecipe((stack, slot) -> {});
    }

    protected void craftRecipe(BiConsumer<ItemStack, Integer> usedStacks) {
        block6: {
            int slot;
            Ingredient ingredient;
            if (this.f_58857_ == null || this.f_58857_.f_46443_ || this.recipe == null) break block6;
            IAdvancedItemHandlerModifiable inventory = this.getInventory().getUnrestricted();
            ArrayList<ItemStack> consumedStacks = new ArrayList<ItemStack>();
            Iterator<ItemStack> iterator = this.recipe.m_7527_().iterator();
            Iterator iteratorTest = this.recipe.m_7527_().iterator();
            int countItemCraft = 0;
            block0: while (iteratorTest.hasNext()) {
                ingredient = (Ingredient)iteratorTest.next();
                for (slot = this.firstInputSlot; slot < this.firstOutputSlot; ++slot) {
                    if (!ingredient.test(inventory.getStackInSlot(slot))) continue;
                    int cc = inventory.getStackInSlot(slot).m_41613_();
                    if (countItemCraft == 0) {
                        countItemCraft = Math.min(this.countCraftPerRecipe, cc);
                        continue block0;
                    }
                    countItemCraft = Math.min(countItemCraft, cc);
                    continue block0;
                }
            }
            block2: while (iterator.hasNext()) {
                ingredient = (Ingredient)iterator.next();
                for (slot = this.firstInputSlot; slot < this.firstOutputSlot; ++slot) {
                    if (!ingredient.test(inventory.getStackInSlot(slot))) continue;
                    ItemStack extracted = inventory.extractItem(slot, countItemCraft, false);
                    if (extracted.m_41619_()) continue block2;
                    consumedStacks.add(extracted);
                    usedStacks.accept(extracted, slot);
                    continue block2;
                }
            }
            for (ItemStack result : this.resultItems(this.recipe, consumedStacks)) {
                result.m_41764_(result.m_41613_() * countItemCraft);
                this.putIntoOutputOrDrop(result.m_41777_());
            }
            this.onCrafted(this.recipe, countItemCraft);
            this.recipe = null;
            this.needsRecipeUpdate();
            this.countCraftPerRecipe = this.countCraft;
        }
    }

    protected boolean canMatchRecipes() {
        return true;
    }

    protected boolean matchRecipe(T recipe, List<ItemStack> stacks) {
        return RecipeHelper.matches(recipe, stacks, (boolean)false);
    }

    protected void onCrafted(T recipe, int countItemCraft) {
    }

    protected List<ItemStack> resultItems(T recipe, List<ItemStack> stacks) {
        return recipe.m_8043_().m_41619_() ? List.of() : List.of(recipe.m_8043_().m_41777_());
    }

    protected void putIntoOutputOrDrop(ItemStack stack) {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            IAdvancedItemHandlerModifiable inventory = this.getInventory().getUnrestricted();
            ItemStack left = stack.m_41777_();
            for (int slot = this.firstOutputSlot; slot < inventory.getSlots(); ++slot) {
                if (!(left = inventory.insertItem(slot, left, false)).m_41619_()) continue;
                return;
            }
            if (!left.m_41619_()) {
                ItemEntity ie = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.7, (double)this.f_58858_.m_123343_() + 0.5, left.m_41777_());
                this.f_58857_.m_7967_((Entity)ie);
            }
        }
    }

    public void needsRecipeUpdate() {
        this.needsRecipeUpdate = true;
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.needsRecipeUpdate = true;
    }
}

