/*
 * Decompiled with CFR 0.152.
 */
package net.lmor.botanicalextramachinery.blocks.base;

import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.lmor.botanicalextramachinery.blocks.base.RecipeTile;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class WorkingTile<T extends Recipe<Container>>
extends RecipeTile<T> {
    private int progress = 0;
    private int maxProgress = 0;

    public WorkingTile(BlockEntityType<?> blockEntityType, RecipeType<T> recipeType, BlockPos pos, BlockState state, int manaCap, int firstInputSlot, int firstOutputSlot, int countCraft) {
        super(blockEntityType, recipeType, pos, state, manaCap, firstInputSlot, firstOutputSlot, countCraft);
    }

    protected void runRecipeTick() {
        this.runRecipeTick(() -> {}, (stack, slot) -> {}, (stack, slot) -> {});
    }

    protected void runRecipeTick(Runnable doUpdate, BiConsumer<ItemStack, Integer> updateStack, BiConsumer<ItemStack, Integer> consumeStack) {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.updateRecipeIfNeeded(doUpdate, updateStack);
            if (this.recipe != null) {
                int newMaxProgress = this.getMaxProgress(this.recipe);
                if (newMaxProgress != this.maxProgress) {
                    this.maxProgress = newMaxProgress;
                    this.m_6596_();
                    this.setDispatchable();
                }
                this.progress += this.getAndApplyProgressThisTick();
                if (this.progress >= this.getMaxProgress(this.recipe)) {
                    this.progress = 0;
                    this.craftRecipe(consumeStack);
                }
                this.m_6596_();
                this.setDispatchable();
            } else if (this.progress != 0 || this.maxProgress != 0) {
                this.progress = 0;
                this.maxProgress = 0;
                this.m_6596_();
                this.setDispatchable();
            }
        }
    }

    public int getProgress() {
        return this.progress;
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    protected int getAndApplyProgressThisTick() {
        int manaToTransfer = Math.min(Math.min(this.getCurrentMana(), this.getMaxManaPerTick()), this.getMaxProgress(this.recipe) - this.progress);
        this.receiveMana(-manaToTransfer * this.getCountCraft());
        return manaToTransfer;
    }

    protected abstract int getMaxProgress(T var1);

    public abstract int getMaxManaPerTick();

    public int getComparatorOutput() {
        return this.getProgress() > 0 ? 15 : 0;
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.progress = nbt.m_128451_("progress");
        this.maxProgress = nbt.m_128451_("maxProgress");
    }

    public void m_183515_(@Nonnull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("progress", this.progress);
        nbt.m_128405_("maxProgress", this.maxProgress);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            return super.m_5995_();
        }
        CompoundTag nbt = super.m_5995_();
        nbt.m_128405_("progress", this.progress);
        nbt.m_128405_("maxProgress", this.maxProgress);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            this.progress = tag.m_128451_("progress");
            this.maxProgress = tag.m_128451_("maxProgress");
        }
    }
}

