/*
 * Decompiled with CFR 0.152.
 */
package net.lmor.botanicalextramachinery.blocks.pattern;

import appeng.api.config.Actionable;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.util.AECableType;
import appeng.hooks.ticking.TickHandler;
import appeng.me.helpers.BlockEntityNodeListener;
import appeng.me.helpers.IGridConnectedBlockEntity;
import io.github.noeppi_noeppi.libx.base.tile.BlockEntityBase;
import io.github.noeppi_noeppi.libx.base.tile.TickableBlock;
import io.github.noeppi_noeppi.libx.capability.ItemCapabilities;
import io.github.noeppi_noeppi.libx.inventory.BaseItemStackHandler;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.lmor.botanicalextramachinery.ModBlocks;
import net.lmor.botanicalextramachinery.ModItems;
import net.lmor.botanicalextramachinery.blocks.tiles.mechanicalDaisy.BlockEntityDaisyAdvanced;
import net.lmor.botanicalextramachinery.blocks.tiles.mechanicalDaisy.BlockEntityDaisyBase;
import net.lmor.botanicalextramachinery.blocks.tiles.mechanicalDaisy.BlockEntityDaisyUpgraded;
import net.lmor.botanicalextramachinery.config.LibXClientConfig;
import net.lmor.botanicalextramachinery.config.LibXServerConfig;
import net.lmor.botanicalextramachinery.util.SettingPattern;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.recipe.IPureDaisyRecipe;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.crafting.ModRecipeTypes;

public class BlockEntityDaisyPattern
extends BlockEntityBase
implements TickableBlock,
IInWorldGridNodeHost,
IGridConnectedBlockEntity {
    private int ticksToNextUpdate = LibXServerConfig.DaisySettings.ticksToNextUpdate;
    private int[] workingTicks;
    private final InventoryHandler inventory;
    private int SLOT_UPGRADE = -1;
    private BaseItemStackHandler inventoryUpgrade;
    private final int sizeItemSlots;
    private final LazyOptional<IItemHandlerModifiable> lazyInventory;
    private final LazyOptional<IItemHandlerModifiable> hopperInventory;
    private final int countSlotInventory;
    private final SettingPattern setting;
    private boolean recipeOutputItem = false;
    private int timeCheckOutputSlot = LibXServerConfig.tickOutputSlots;
    private boolean setChangedQueued;
    private final IManagedGridNode mainNode = this.createMainNode().setVisualRepresentation((ItemLike)this.getItemFromBlockEntity()).setInWorldNode(true).setTagName("proxy");

    public BlockEntityDaisyPattern(BlockEntityType<?> type, BlockPos pos, BlockState state, int countSlotInventory, SettingPattern settingPattern, int ... slotUpgrade) {
        super(type, pos, state);
        if (slotUpgrade.length != 0) {
            this.SLOT_UPGRADE = slotUpgrade[0];
            this.inventoryUpgrade = BaseItemStackHandler.builder((int)(this.SLOT_UPGRADE + 1)).validator(stack -> stack.m_41720_() == ModItems.catalystStoneInfinity.m_5456_() || stack.m_41720_() == ModItems.catalystWoodInfinity.m_5456_(), new int[]{this.SLOT_UPGRADE}).slotLimit(1, new int[]{this.SLOT_UPGRADE}).output(new int[0]).contentsChanged(() -> {
                this.m_6596_();
                this.setDispatchable();
                this.activeUpgradeSlot();
            }).build();
        }
        this.countSlotInventory = countSlotInventory;
        this.setting = settingPattern;
        this.sizeItemSlots = settingPattern.getConfigInt("sizeSlots");
        this.inventory = new InventoryHandler();
        this.workingTicks = new int[this.countSlotInventory];
        this.lazyInventory = ItemCapabilities.create((IItemHandlerModifiable)this.inventory).cast();
        this.hopperInventory = ItemCapabilities.create((IItemHandlerModifiable)this.inventory, slot -> this.workingTicks[slot] < 0, null).cast();
        this.setChangedQueued = false;
    }

    public void tick() {
        boolean hasSpawnedParticles = false;
        for (int i = 0; i < this.countSlotInventory; ++i) {
            IPureDaisyRecipe recipe = this.getRecipe(i);
            if (recipe != null && this.workingTicks[i] >= 0) {
                if (!this.f_58857_.f_46443_) {
                    if (this.workingTicks[i] >= recipe.getTime() * this.setting.getConfigInt("durationTime")) {
                        BlockState state = recipe.getOutputState();
                        this.recipeOutputItem = true;
                        this.inventory.setStackInSlot(i, state.m_60734_().m_7397_((BlockGetter)this.f_58857_, this.f_58858_, state));
                        this.workingTicks[i] = -1;
                        this.setDispatchable();
                        continue;
                    }
                    int n = i;
                    this.workingTicks[n] = this.workingTicks[n] + 1;
                    continue;
                }
                if (hasSpawnedParticles || !LibXClientConfig.RenderingVisualContent.all || !this.setting.getConfigBoolean("renderingDaisy").booleanValue()) continue;
                hasSpawnedParticles = true;
                double x = (double)this.f_58858_.m_123341_() + Math.random();
                double y = (double)this.f_58858_.m_123342_() + Math.random() + 0.25;
                double z = (double)this.f_58858_.m_123343_() + Math.random();
                WispParticleData data = WispParticleData.wisp((float)((float)Math.random() / 2.0f), (float)1.0f, (float)1.0f, (float)1.0f);
                this.f_58857_.m_7106_((ParticleOptions)data, x, y, z, 0.0, 0.0, 0.0);
                continue;
            }
            this.workingTicks[i] = this.workingTicks[i] < 0 && !this.inventory.getStackInSlot(i).m_41619_() ? -1 : 0;
        }
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            if (!this.getMainNode().isReady()) {
                this.getMainNode().create(this.f_58857_, this.m_58899_());
            }
            if (this.getMainNode().isReady() && this.recipeOutputItem) {
                this.exportResultsItemsME();
                this.recipeOutputItem = false;
                this.activeUpgradeSlot();
            }
            if (this.ticksToNextUpdate <= 0) {
                this.ticksToNextUpdate = LibXServerConfig.DaisySettings.ticksToNextUpdate;
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers((BlockEntity)this);
            } else {
                --this.ticksToNextUpdate;
            }
        }
    }

    private void activeUpgradeSlot() {
        if (this.inventoryUpgrade != null && !this.inventoryUpgrade.getStackInSlot(0).m_41619_()) {
            ItemStack upgradeItem = this.inventoryUpgrade.getStackInSlot(this.SLOT_UPGRADE);
            ItemStack setSlotItem = ItemStack.f_41583_;
            if (upgradeItem.m_41720_() == ModItems.catalystStoneInfinity.m_5456_()) {
                setSlotItem = new ItemStack((ItemLike)Blocks.f_50069_);
            } else if (upgradeItem.m_41720_() == ModItems.catalystWoodInfinity.m_5456_()) {
                setSlotItem = new ItemStack((ItemLike)Blocks.f_49999_);
            }
            if (!setSlotItem.m_41619_()) {
                setSlotItem.m_41764_(this.setting.getConfigInt("sizeSlots").intValue());
                for (int i = 0; i < this.countSlotInventory; ++i) {
                    if (!this.inventory.getStackInSlot(i).m_41619_()) continue;
                    this.inventory.setStackInSlot(i, setSlotItem.m_41777_());
                }
            }
        }
    }

    @Nullable
    private IPureDaisyRecipe getRecipe(int slot) {
        BlockState state = this.getState(slot);
        return state == null ? null : this.getRecipe(state);
    }

    @Nullable
    public BlockState getState(int slot) {
        BlockState state = null;
        ItemStack stack = this.inventory.getStackInSlot(slot);
        if (stack.m_41720_() instanceof BlockItem) {
            state = ((BlockItem)stack.m_41720_()).m_40614_().m_49966_();
        }
        return state;
    }

    @Nullable
    public IPureDaisyRecipe getRecipe(BlockState state) {
        if (this.f_58857_ == null) {
            return null;
        }
        for (Recipe genericRecipe : this.f_58857_.m_7465_().m_44013_(ModRecipeTypes.PURE_DAISY_TYPE)) {
            IPureDaisyRecipe recipe;
            if (!(genericRecipe instanceof IPureDaisyRecipe) || !(recipe = (IPureDaisyRecipe)genericRecipe).matches(this.f_58857_, this.f_58858_, null, state)) continue;
            return recipe;
        }
        return null;
    }

    public InventoryHandler getInventory() {
        return this.inventory;
    }

    public BaseItemStackHandler getInventoryUpgrade() {
        return this.inventoryUpgrade;
    }

    public List<ItemStack> getUpgrades() {
        ArrayList<ItemStack> upgrade = new ArrayList<ItemStack>();
        upgrade.add(new ItemStack((ItemLike)ModItems.catalystWoodInfinity));
        upgrade.add(new ItemStack((ItemLike)ModItems.catalystStoneInfinity));
        return upgrade;
    }

    @Nonnull
    public <X> LazyOptional<X> getCapability(@Nonnull Capability<X> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return side == null ? this.lazyInventory : this.hopperInventory;
        }
        return super.getCapability(cap, side);
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("workingTicks")) {
            this.workingTicks = nbt.m_128465_("workingTicks");
        }
        if (nbt.m_128441_("inv")) {
            this.getInventoryUpgrade().deserializeNBT(nbt.m_128469_("inv"));
        }
    }

    public void m_183515_(@Nonnull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128385_("workingTicks", this.workingTicks);
        if (this.inventoryUpgrade != null) {
            nbt.m_128365_("inv", (Tag)this.getInventoryUpgrade().serializeNBT());
        }
    }

    public void handleUpdateTag(CompoundTag nbt) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            super.handleUpdateTag(nbt);
            if (nbt.m_128441_("workingTicks")) {
                this.workingTicks = nbt.m_128465_("workingTicks");
            }
            if (nbt.m_128441_("inv")) {
                this.getInventoryUpgrade().deserializeNBT(nbt.m_128469_("inv"));
            }
        }
    }

    @Nonnull
    public CompoundTag m_5995_() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            return super.m_5995_();
        }
        CompoundTag nbt = super.m_5995_();
        nbt.m_128385_("workingTicks", this.workingTicks);
        if (this.inventoryUpgrade != null) {
            nbt.m_128365_("inv", (Tag)this.getInventoryUpgrade().serializeNBT());
        }
        return nbt;
    }

    public BlockEntity getBlockEntity() {
        return this;
    }

    public void drops() {
        InventoryHandler inventory = this.getInventory();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemStack = inventory.getStackInSlot(i);
            if (itemStack.m_41619_()) continue;
            ItemEntity ie = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.7, (double)this.f_58858_.m_123343_() + 0.5, itemStack.m_41777_());
            this.f_58857_.m_7967_((Entity)ie);
        }
    }

    protected IManagedGridNode createMainNode() {
        return GridHelper.createManagedNode((Object)((Object)this), (IGridNodeListener)BlockEntityNodeListener.INSTANCE);
    }

    protected Item getItemFromBlockEntity() {
        BlockEntity blockEntity = this.getBlockEntity();
        if (blockEntity instanceof BlockEntityDaisyBase) {
            return ModBlocks.baseDaisy.m_5456_();
        }
        if (blockEntity instanceof BlockEntityDaisyUpgraded) {
            return ModBlocks.upgradedDaisy.m_5456_();
        }
        if (blockEntity instanceof BlockEntityDaisyAdvanced) {
            return ModBlocks.advancedDaisy.m_5456_();
        }
        return ModBlocks.ultimateDaisy.m_5456_();
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.getMainNode() != null) {
            this.getMainNode().destroy();
        }
    }

    private Object setChangedAtEndOfTick(Level level) {
        this.m_6596_();
        this.setChangedQueued = false;
        return null;
    }

    @Nullable
    public IGridNode getGridNode(Direction direction) {
        return this.getMainNode().getNode();
    }

    public IManagedGridNode getMainNode() {
        return this.mainNode;
    }

    public void securityBreak() {
        this.f_58857_.m_46961_(this.f_58858_, true);
    }

    public void saveChanges() {
        if (this.f_58857_ != null) {
            if (this.f_58857_.f_46443_) {
                this.m_6596_();
            } else {
                this.f_58857_.m_151543_(this.f_58858_);
                if (!this.setChangedQueued) {
                    TickHandler.instance().addCallable(null, this::setChangedAtEndOfTick);
                    this.setChangedQueued = true;
                }
            }
        }
    }

    private void exportResultsItemsME() {
        for (int slot = 0; slot < this.countSlotInventory; ++slot) {
            int getCountExport;
            ItemStack stackInSlot = this.inventory.getStackInSlot(slot);
            if (stackInSlot.m_41619_() || (getCountExport = Math.toIntExact(this.getMainNode().getGrid().getStorageService().getInventory().insert((AEKey)AEItemKey.of((ItemStack)stackInSlot), (long)stackInSlot.m_41613_(), Actionable.MODULATE, IActionSource.empty()))) <= 0) continue;
            stackInSlot.m_41774_(getCountExport);
            this.inventory.setStackInSlot(slot, stackInSlot);
            this.inventory.onContentsChanged(slot);
        }
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    public class InventoryHandler
    extends ItemStackHandler {
        public InventoryHandler() {
            super(BlockEntityDaisyPattern.this.countSlotInventory);
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            if (BlockEntityDaisyPattern.this.recipeOutputItem) {
                stack.m_41764_(BlockEntityDaisyPattern.this.inventory.getStackInSlot(slot).m_41613_());
            }
            this.stacks.set(slot, (Object)stack);
        }

        public int getSlots() {
            return BlockEntityDaisyPattern.this.countSlotInventory;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return super.insertItem(slot, stack, simulate);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            int getCountExport;
            ItemStack stackInSlot;
            if (BlockEntityDaisyPattern.this.getMainNode() != null && BlockEntityDaisyPattern.this.getMainNode().getNode() != null && BlockEntityDaisyPattern.this.getMainNode().isOnline() && !(stackInSlot = BlockEntityDaisyPattern.this.getInventory().getStackInSlot(slot)).m_41619_() && (getCountExport = Math.toIntExact(BlockEntityDaisyPattern.this.getMainNode().getGrid().getStorageService().getInventory().insert((AEKey)AEItemKey.of((ItemStack)stackInSlot), (long)stackInSlot.m_41613_(), Actionable.MODULATE, IActionSource.empty()))) > 0) {
                stackInSlot.m_41774_(getCountExport);
                BlockEntityDaisyPattern.this.inventory.setStackInSlot(slot, stackInSlot);
            }
            return super.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return BlockEntityDaisyPattern.this.sizeItemSlots;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return !stack.m_41619_() && stack.m_41720_() instanceof BlockItem && BlockEntityDaisyPattern.this.getRecipe(((BlockItem)stack.m_41720_()).m_40614_().m_49966_()) != null;
        }

        protected void onContentsChanged(int slot) {
            if (slot >= 0 && slot < BlockEntityDaisyPattern.this.countSlotInventory && this.getStackInSlot(slot).m_41619_()) {
                BlockEntityDaisyPattern.this.workingTicks[slot] = 0;
            }
            BlockEntityDaisyPattern.this.m_6596_();
            BlockEntityDaisyPattern.this.setDispatchable();
        }
    }
}

