/*
 * Decompiled with CFR 0.152.
 */
package net.lmor.botanicalextramachinery.blocks.pattern;

import appeng.api.config.Actionable;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.util.AECableType;
import appeng.hooks.ticking.TickHandler;
import appeng.me.helpers.BlockEntityNodeListener;
import appeng.me.helpers.IGridConnectedBlockEntity;
import com.google.common.collect.Range;
import de.melanx.botanicalmachinery.blocks.base.BotanicalTile;
import io.github.noeppi_noeppi.libx.inventory.BaseItemStackHandler;
import io.github.noeppi_noeppi.libx.inventory.IAdvancedItemHandlerModifiable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.lmor.botanicalextramachinery.ModBlocks;
import net.lmor.botanicalextramachinery.ModItems;
import net.lmor.botanicalextramachinery.blocks.tiles.mechanicalOrechid.BlockEntityOrechidAdvanced;
import net.lmor.botanicalextramachinery.blocks.tiles.mechanicalOrechid.BlockEntityOrechidBase;
import net.lmor.botanicalextramachinery.blocks.tiles.mechanicalOrechid.BlockEntityOrechidUpgraded;
import net.lmor.botanicalextramachinery.config.LibXServerConfig;
import net.lmor.botanicalextramachinery.util.SettingPattern;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.recipe.IOrechidRecipe;
import vazkii.botania.common.crafting.ModRecipeTypes;

public class BlockEntityOrechidPattern
extends BotanicalTile
implements IInWorldGridNodeHost,
IGridConnectedBlockEntity {
    private List<Integer> FILTER_SLOTS = new ArrayList<Integer>();
    private final int FIRST_INPUT_SLOT;
    private final int LAST_INPUT_SLOT;
    private final int FIRST_OUTPUT_SLOT;
    private final int LAST_OUTPUT_SLOT;
    private int UPGRADE_SLOT_1 = -1;
    private int UPGRADE_SLOT_2 = -1;
    private final BaseItemStackHandler inventory;
    private final SettingPattern settingPattern;
    private int cooldown;
    private int timeCheckOutputSlot = LibXServerConfig.tickOutputSlots;
    private boolean catalystMana = false;
    private boolean setChangedQueued;
    private final IManagedGridNode mainNode = this.createMainNode().setVisualRepresentation((ItemLike)this.getItemFromBlockEntity()).setInWorldNode(true).setTagName("proxy");

    public BlockEntityOrechidPattern(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state, int manaCap, int[] slots, int[] upgrade_slot, SettingPattern settingPattern) {
        super(blockEntityType, pos, state, manaCap);
        this.FIRST_INPUT_SLOT = slots[0];
        this.LAST_INPUT_SLOT = slots[1];
        this.FIRST_OUTPUT_SLOT = slots[2];
        this.LAST_OUTPUT_SLOT = slots[3];
        for (int i = 4; i < slots.length; ++i) {
            this.FILTER_SLOTS.add(slots[i]);
        }
        if (upgrade_slot != null) {
            this.UPGRADE_SLOT_1 = upgrade_slot[0];
            this.UPGRADE_SLOT_2 = upgrade_slot[1];
        }
        this.settingPattern = settingPattern;
        this.inventory = upgrade_slot != null ? BaseItemStackHandler.builder((int)(this.LAST_OUTPUT_SLOT + 1)).validator(stack -> stack.m_41720_() == ModItems.catalystManaInfinity.m_5456_() || stack.m_41720_() == ModItems.catalystStoneInfinity.m_5456_(), new int[]{this.UPGRADE_SLOT_1, this.UPGRADE_SLOT_2}).validator(stack -> this.f_58857_ != null && this.getInputs().contains(stack.m_41720_()), Range.closedOpen((Comparable)Integer.valueOf(this.FIRST_INPUT_SLOT), (Comparable)Integer.valueOf(this.LAST_INPUT_SLOT + 1))).validator(stack -> this.getOutputs().contains(stack.m_41720_()), this.FILTER_SLOTS.stream().mapToInt(Integer::intValue).toArray()).output(Range.closedOpen((Comparable)Integer.valueOf(this.FIRST_OUTPUT_SLOT), (Comparable)Integer.valueOf(this.LAST_OUTPUT_SLOT + 1))).contentsChanged(() -> {
            this.m_6596_();
            this.setDispatchable();
        }).slotLimit(1, new int[]{this.UPGRADE_SLOT_1, this.UPGRADE_SLOT_2}).slotLimit(1, this.FILTER_SLOTS.stream().mapToInt(Integer::intValue).toArray()).build() : BaseItemStackHandler.builder((int)(this.LAST_OUTPUT_SLOT + 1)).validator(stack -> this.f_58857_ != null && this.getInputs().contains(stack.m_41720_()), Range.closedOpen((Comparable)Integer.valueOf(this.FIRST_INPUT_SLOT), (Comparable)Integer.valueOf(this.LAST_INPUT_SLOT + 1))).validator(stack -> this.getOutputs().contains(stack.m_41720_()), this.FILTER_SLOTS.stream().mapToInt(Integer::intValue).toArray()).output(Range.closedOpen((Comparable)Integer.valueOf(this.FIRST_OUTPUT_SLOT), (Comparable)Integer.valueOf(this.LAST_OUTPUT_SLOT + 1))).contentsChanged(() -> {
            this.m_6596_();
            this.setDispatchable();
        }).slotLimit(1, this.FILTER_SLOTS.stream().mapToInt(Integer::intValue).toArray()).build();
        this.setChangedQueued = false;
    }

    public BlockEntity getBlockEntity() {
        return this;
    }

    private boolean checkOutputSlots() {
        for (int i = this.FIRST_OUTPUT_SLOT; i <= this.LAST_OUTPUT_SLOT; ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    private boolean checkFilterSlots() {
        for (int index : this.FILTER_SLOTS) {
            if (this.inventory.getStackInSlot(index).m_41619_()) continue;
            return true;
        }
        return false;
    }

    public void tick() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            if (!this.getMainNode().isReady()) {
                this.getMainNode().create(this.f_58857_, this.m_58899_());
            }
            if (this.getMainNode() != null && this.getMainNode().getNode() != null && this.getMainNode().isOnline()) {
                if (this.timeCheckOutputSlot <= 0) {
                    if (this.checkOutputSlots()) {
                        this.exportResultsItemsME();
                    }
                    this.timeCheckOutputSlot = LibXServerConfig.tickOutputSlots;
                } else {
                    --this.timeCheckOutputSlot;
                }
            }
            if (this.UPGRADE_SLOT_1 != -1 && this.UPGRADE_SLOT_2 != -1) {
                if (this.inventory.getStackInSlot(this.UPGRADE_SLOT_1).m_41720_() == ModItems.catalystManaInfinity || this.inventory.getStackInSlot(this.UPGRADE_SLOT_2).m_41720_() == ModItems.catalystManaInfinity) {
                    if (this.getManaCap() != this.getCurrentMana()) {
                        this.receiveMana(this.getManaCap());
                    }
                    this.catalystMana = true;
                } else {
                    this.catalystMana = false;
                }
            }
            if (this.cooldown > 0) {
                --this.cooldown;
                this.m_6596_();
                this.setDispatchable();
            }
            if (this.cooldown <= 0) {
                int output_slot = this.LAST_INPUT_SLOT;
                int count_success = 0;
                for (int input_slot = this.FIRST_INPUT_SLOT; input_slot <= this.LAST_INPUT_SLOT; ++input_slot) {
                    IOrechidRecipe recipe;
                    if (this.inventory.getStackInSlot(input_slot).m_41619_() || !this.inventory.getStackInSlot(++output_slot).m_41619_()) continue;
                    IOrechidRecipe iOrechidRecipe = recipe = !this.checkFilterSlots() ? this.getRecipeOrechid() : this.getRecipeOrechidFilter();
                    if (recipe == null) continue;
                    int count_recipe = Math.min(this.inventory.getStackInSlot(input_slot).m_41613_(), this.settingPattern.getConfigInt("countCraft"));
                    count_recipe = Math.min(count_recipe, this.inventory.getStackInSlot(output_slot).m_41741_() - this.inventory.getStackInSlot(output_slot).m_41613_());
                    if (!this.catalystMana) {
                        if (this.getCurrentMana() < LibXServerConfig.OrechidSettings.recipeCost * count_recipe) {
                            while (this.getCurrentMana() < LibXServerConfig.OrechidSettings.recipeCost * count_recipe) {
                                --count_recipe;
                            }
                        }
                        if (count_recipe == 0) break;
                        this.receiveMana(-(count_recipe * LibXServerConfig.OrechidSettings.recipeCost));
                    }
                    ItemStack resItemStack = new ItemStack((ItemLike)recipe.getOutput().pick(this.f_58857_.f_46441_).m_60734_().m_5456_());
                    resItemStack.m_41764_(count_recipe);
                    IAdvancedItemHandlerModifiable inventory = this.getInventory().getUnrestricted();
                    inventory.extractItem(input_slot, count_recipe, false);
                    inventory.insertItem(output_slot, resItemStack, false);
                    ++count_success;
                }
                if (count_success != 0 && this.UPGRADE_SLOT_1 != -1 && this.UPGRADE_SLOT_2 != -1 && (this.inventory.getStackInSlot(this.UPGRADE_SLOT_1).m_41720_() == ModItems.catalystStoneInfinity || this.inventory.getStackInSlot(this.UPGRADE_SLOT_2).m_41720_() == ModItems.catalystStoneInfinity)) {
                    ItemStack stone = new ItemStack((ItemLike)Items.f_41905_);
                    stone.m_41764_(64);
                    for (int i = this.FIRST_INPUT_SLOT; i <= this.LAST_INPUT_SLOT; ++i) {
                        this.inventory.setStackInSlot(i, stone);
                    }
                }
                this.cooldown = this.settingPattern.getConfigInt("cooldown");
            }
        }
    }

    protected Predicate<Integer> getExtracts(Supplier<IItemHandlerModifiable> supplier) {
        return slot -> slot >= this.FIRST_OUTPUT_SLOT && slot <= this.LAST_OUTPUT_SLOT;
    }

    @NotNull
    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public int getComparatorOutput() {
        return 0;
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.getMainNode() != null) {
            this.getMainNode().destroy();
        }
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.cooldown = nbt.m_128451_("cooldown");
        this.m_6596_();
        this.setDispatchable();
    }

    public void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("cooldown", this.cooldown);
    }

    public void handleUpdateTag(CompoundTag nbt) {
        super.handleUpdateTag(nbt);
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            this.cooldown = nbt.m_128451_("cooldown");
        }
    }

    @NotNull
    public CompoundTag m_5995_() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            return super.m_5995_();
        }
        CompoundTag nbt = super.m_5995_();
        nbt.m_128405_("cooldown", this.cooldown);
        return nbt;
    }

    public List<Item> getOutputs() {
        ArrayList<Item> outputs = new ArrayList<Item>();
        if (this.f_58857_ == null) {
            return List.of();
        }
        this.f_58857_.m_7465_().m_44013_(ModRecipeTypes.ORECHID_TYPE).forEach(recipe -> {
            if (recipe.getOutput() != null) {
                recipe.getOutput().getDisplayedStacks().stream().map(ItemStack::m_41720_).forEach(item -> {
                    if (!outputs.contains(item)) {
                        outputs.add((Item)item);
                    }
                });
            }
        });
        return outputs;
    }

    public List<Item> getInputs() {
        ArrayList<Item> inputs = new ArrayList<Item>();
        if (this.f_58857_ == null) {
            return List.of();
        }
        this.f_58857_.m_7465_().m_44013_(ModRecipeTypes.ORECHID_TYPE).forEach(recipe -> {
            Item input;
            if (recipe.getInput() != null && !inputs.contains(input = recipe.getInput().m_49966_().m_60734_().m_5456_())) {
                inputs.add(input);
            }
        });
        return inputs;
    }

    @Nullable
    public IOrechidRecipe getRecipeOrechid() {
        ArrayList values = new ArrayList();
        this.f_58857_.m_7465_().m_44013_(ModRecipeTypes.ORECHID_TYPE).forEach(recipe -> values.add(WeightedEntry.m_146290_((Object)recipe, (int)recipe.getWeight())));
        return WeightedRandom.m_146317_((Random)this.f_58857_.f_46441_, values).map(WeightedEntry.Wrapper::m_146310_).orElse(null);
    }

    @Nullable
    public IOrechidRecipe getRecipeOrechidFilter() {
        ArrayList values = new ArrayList();
        this.f_58857_.m_7465_().m_44013_(ModRecipeTypes.ORECHID_TYPE).forEach(recipe -> recipe.getOutput().getDisplayedStacks().stream().forEach(itemStack -> {
            for (int index : this.FILTER_SLOTS) {
                if (this.inventory.getStackInSlot(index).m_41720_() != itemStack.m_41720_()) continue;
                values.add(WeightedEntry.m_146290_((Object)recipe, (int)recipe.getWeight()));
            }
        }));
        return WeightedRandom.m_146317_((Random)this.f_58857_.f_46441_, values).map(WeightedEntry.Wrapper::m_146310_).orElse(null);
    }

    public void drops() {
        IAdvancedItemHandlerModifiable inventory = this.getInventory().getUnrestricted();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemStack = inventory.getStackInSlot(i);
            if (itemStack.m_41619_()) continue;
            ItemEntity ie = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.7, (double)this.f_58858_.m_123343_() + 0.5, itemStack.m_41777_());
            this.f_58857_.m_7967_((Entity)ie);
        }
    }

    protected IManagedGridNode createMainNode() {
        return GridHelper.createManagedNode((Object)((Object)this), (IGridNodeListener)BlockEntityNodeListener.INSTANCE);
    }

    protected Item getItemFromBlockEntity() {
        BlockEntity blockEntity = this.getBlockEntity();
        if (blockEntity instanceof BlockEntityOrechidBase) {
            return ModBlocks.baseOrechid.m_5456_();
        }
        if (blockEntity instanceof BlockEntityOrechidUpgraded) {
            return ModBlocks.upgradedOrechid.m_5456_();
        }
        if (blockEntity instanceof BlockEntityOrechidAdvanced) {
            return ModBlocks.advancedOrechid.m_5456_();
        }
        return ModBlocks.ultimateOrechid.m_5456_();
    }

    private Object setChangedAtEndOfTick(Level level) {
        this.m_6596_();
        this.setChangedQueued = false;
        return null;
    }

    @Nullable
    public IGridNode getGridNode(Direction direction) {
        return this.getMainNode().getNode();
    }

    public IManagedGridNode getMainNode() {
        return this.mainNode;
    }

    public void securityBreak() {
        this.f_58857_.m_46961_(this.f_58858_, true);
    }

    public void saveChanges() {
        if (this.f_58857_ != null) {
            if (this.f_58857_.f_46443_) {
                this.m_6596_();
            } else {
                this.f_58857_.m_151543_(this.f_58858_);
                if (!this.setChangedQueued) {
                    TickHandler.instance().addCallable((LevelAccessor)null, this::setChangedAtEndOfTick);
                    this.setChangedQueued = true;
                }
            }
        }
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    private void exportResultsItemsME() {
        for (int slot = this.FIRST_OUTPUT_SLOT; slot <= this.LAST_OUTPUT_SLOT; ++slot) {
            int getCountExport;
            ItemStack stackInSlot = this.inventory.getStackInSlot(slot);
            if (stackInSlot.m_41619_() || (getCountExport = Math.toIntExact(this.getMainNode().getGrid().getStorageService().getInventory().insert((AEKey)AEItemKey.of((ItemStack)stackInSlot), (long)stackInSlot.m_41613_(), Actionable.MODULATE, IActionSource.empty()))) <= 0) continue;
            stackInSlot.m_41774_(getCountExport);
            this.inventory.setStackInSlot(slot, stackInSlot);
        }
    }
}

