/*
 * Decompiled with CFR 0.152.
 */
package net.lmor.botanicalextramachinery.blocks.tiles;

import appeng.api.config.Actionable;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.util.AECableType;
import appeng.hooks.ticking.TickHandler;
import appeng.me.helpers.BlockEntityNodeListener;
import appeng.me.helpers.IGridConnectedBlockEntity;
import de.melanx.botanicalmachinery.blocks.base.BotanicalTile;
import io.github.noeppi_noeppi.libx.inventory.BaseItemStackHandler;
import io.github.noeppi_noeppi.libx.inventory.IAdvancedItemHandlerModifiable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.lmor.botanicalextramachinery.ModBlocks;
import net.lmor.botanicalextramachinery.ModItems;
import net.lmor.botanicalextramachinery.config.LibXServerConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityJadedAmaranthus
extends BotanicalTile
implements IInWorldGridNodeHost,
IGridConnectedBlockEntity {
    private final List<Integer> UPGRADE_SLOT = new ArrayList<Integer>();
    private final int FIRST_OUTPUT_SLOT;
    private final int LAST_OUTPUT_SLOT;
    private int cooldown = LibXServerConfig.JadedAmaranthusSettings.cooldown;
    private int countCraft = LibXServerConfig.JadedAmaranthusSettings.countCraft;
    private int costMana = LibXServerConfig.JadedAmaranthusSettings.costMana;
    private boolean petalUpgrade = false;
    private boolean petalBlockUpgrade = false;
    private int timeCheckOutputSlot = LibXServerConfig.tickOutputSlots;
    private final BaseItemStackHandler inventory;
    private boolean setChangedQueued;
    private final IManagedGridNode mainNode = this.createMainNode().setVisualRepresentation((ItemLike)this.getItemFromBlockEntity()).setInWorldNode(true).setTagName("proxy");

    public BlockEntityJadedAmaranthus(BlockEntityType<?> blockEntityTypeIn, BlockPos pos, BlockState state) {
        super(blockEntityTypeIn, pos, state, LibXServerConfig.JadedAmaranthusSettings.manaStorage);
        for (int i = 0; i <= 1; ++i) {
            this.UPGRADE_SLOT.add(i);
        }
        this.FIRST_OUTPUT_SLOT = this.UPGRADE_SLOT.size();
        this.LAST_OUTPUT_SLOT = this.FIRST_OUTPUT_SLOT + 15;
        this.inventory = BaseItemStackHandler.builder((int)(this.LAST_OUTPUT_SLOT + 1)).validator(stack -> stack.m_41720_() == ModItems.catalystManaInfinity.m_5456_() || stack.m_41720_() == ModItems.catalystPetal.m_5456_() || stack.m_41720_() == ModItems.catalystPetalBlock.m_5456_(), this.UPGRADE_SLOT.stream().mapToInt(Integer::intValue).toArray()).output(new int[]{this.FIRST_OUTPUT_SLOT, this.LAST_OUTPUT_SLOT + 1}).slotLimit(1, this.UPGRADE_SLOT.stream().mapToInt(Integer::intValue).toArray()).contentsChanged(slot -> {
            this.m_6596_();
            this.setDispatchable();
            this.changedUpgrade((int)slot);
        }).build();
        this.setChangedQueued = false;
    }

    public void changedUpgrade(int slot) {
        if (this.UPGRADE_SLOT.contains(slot)) {
            this.petalUpgrade = false;
            this.petalBlockUpgrade = false;
            for (int slotUpgrade : this.UPGRADE_SLOT) {
                if (!this.getInventory().getStackInSlot(slotUpgrade).m_41619_() && this.getInventory().getStackInSlot(slotUpgrade).m_41720_() == ModItems.catalystPetal.m_5456_()) {
                    this.petalUpgrade = true;
                }
                if (this.getInventory().getStackInSlot(slotUpgrade).m_41619_() || this.getInventory().getStackInSlot(slotUpgrade).m_41720_() != ModItems.catalystPetalBlock.m_5456_()) continue;
                this.petalBlockUpgrade = true;
            }
        }
    }

    public void tick() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (!this.getMainNode().isReady()) {
            this.getMainNode().create(this.f_58857_, this.m_58899_());
        }
        if (this.getCurrentMana() != this.getManaCap() && (this.inventory.getStackInSlot(0).m_41720_() == ModItems.catalystManaInfinity || this.inventory.getStackInSlot(1).m_41720_() == ModItems.catalystManaInfinity)) {
            this.receiveMana(this.getManaCap());
        }
        if (this.getMainNode() != null && this.getMainNode().getNode() != null && this.getMainNode().isOnline()) {
            if (this.timeCheckOutputSlot <= 0) {
                if (this.checkOutputSlots()) {
                    this.exportResultsItemsME();
                }
                this.timeCheckOutputSlot = LibXServerConfig.tickOutputSlots;
            } else {
                --this.timeCheckOutputSlot;
            }
        }
        if (this.getCurrentMana() <= 0) {
            this.cooldown = LibXServerConfig.JadedAmaranthusSettings.cooldown;
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            this.m_6596_();
            this.setDispatchable();
        } else {
            for (int dyeIndex = 0; dyeIndex < 16; ++dyeIndex) {
                DyeColor color = DyeColor.m_41053_((int)dyeIndex);
                Item flowerOrPetal = this.petalUpgrade && !this.petalBlockUpgrade ? vazkii.botania.common.item.ModItems.getPetal((DyeColor)color).m_5456_() : (this.petalBlockUpgrade ? vazkii.botania.common.block.ModBlocks.getPetalBlock((DyeColor)color).m_5456_() : vazkii.botania.common.block.ModBlocks.getFlower((DyeColor)color).m_49966_().m_60734_().m_5456_());
                ItemStack itemSlot = this.getInventory().getStackInSlot(dyeIndex + this.FIRST_OUTPUT_SLOT);
                if (!itemSlot.m_41619_() && !itemSlot.m_150930_(flowerOrPetal)) continue;
                ItemStack addItem = new ItemStack((ItemLike)flowerOrPetal);
                int mana = this.costMana * this.countCraft;
                if (this.petalUpgrade && !this.petalBlockUpgrade) {
                    addItem.m_41764_(Math.min(itemSlot.m_41741_(), itemSlot.m_41613_() + this.countCraft * 2));
                } else {
                    addItem.m_41764_(Math.min(itemSlot.m_41741_(), itemSlot.m_41613_() + this.countCraft));
                }
                if (this.petalBlockUpgrade) {
                    mana = this.costMana * this.countCraft * 9;
                }
                if (this.getInventory().getStackInSlot(dyeIndex + this.FIRST_OUTPUT_SLOT).m_41613_() == this.getInventory().getStackInSlot(dyeIndex + this.FIRST_OUTPUT_SLOT).m_41741_()) continue;
                if (this.getCurrentMana() - mana < 0) break;
                this.getInventory().setStackInSlot(dyeIndex + this.FIRST_OUTPUT_SLOT, addItem);
                this.receiveMana(-mana);
            }
            this.cooldown = LibXServerConfig.JadedAmaranthusSettings.cooldown;
        }
    }

    private boolean checkOutputSlots() {
        for (int i = this.FIRST_OUTPUT_SLOT; i <= this.LAST_OUTPUT_SLOT; ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    public void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("cooldown", this.cooldown);
        nbt.m_128379_("petalUpgrade", this.petalUpgrade);
        nbt.m_128379_("petalUpgradeBlock", this.petalBlockUpgrade);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.cooldown = nbt.m_128451_("cooldown");
        this.petalUpgrade = nbt.m_128471_("petalUpgrade");
        this.petalBlockUpgrade = nbt.m_128471_("petalUpgradeBlock");
        this.m_6596_();
        this.setDispatchable();
    }

    public void handleUpdateTag(CompoundTag nbt) {
        super.handleUpdateTag(nbt);
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            this.cooldown = nbt.m_128451_("cooldown");
            this.petalUpgrade = nbt.m_128471_("petalUpgrade");
            this.petalBlockUpgrade = nbt.m_128471_("petalUpgradeBlock");
        }
    }

    @NotNull
    public CompoundTag m_5995_() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            return super.m_5995_();
        }
        CompoundTag nbt = super.m_5995_();
        nbt.m_128405_("cooldown", this.cooldown);
        nbt.m_128379_("petalUpgrade", this.petalUpgrade);
        nbt.m_128379_("petalUpgradeBlock", this.petalBlockUpgrade);
        return nbt;
    }

    protected Predicate<Integer> getExtracts(Supplier<IItemHandlerModifiable> supplier) {
        return slot -> slot >= this.FIRST_OUTPUT_SLOT && slot <= this.LAST_OUTPUT_SLOT;
    }

    @NotNull
    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public int getComparatorOutput() {
        return 0;
    }

    public void drops() {
        IAdvancedItemHandlerModifiable inventory = this.getInventory().getUnrestricted();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemStack = inventory.getStackInSlot(i);
            if (itemStack.m_41619_()) continue;
            ItemEntity ie = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.7, (double)this.f_58858_.m_123343_() + 0.5, itemStack.m_41777_());
            this.f_58857_.m_7967_((Entity)ie);
        }
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.getMainNode() != null) {
            this.getMainNode().destroy();
        }
    }

    protected IManagedGridNode createMainNode() {
        return GridHelper.createManagedNode((Object)((Object)this), (IGridNodeListener)BlockEntityNodeListener.INSTANCE);
    }

    protected Item getItemFromBlockEntity() {
        return ModBlocks.jadedAmaranthus.m_5456_();
    }

    private Object setChangedAtEndOfTick(Level level) {
        this.m_6596_();
        this.setChangedQueued = false;
        return null;
    }

    @Nullable
    public IGridNode getGridNode(Direction direction) {
        return this.getMainNode().getNode();
    }

    public IManagedGridNode getMainNode() {
        return this.mainNode;
    }

    public void saveChanges() {
        if (this.f_58857_ != null) {
            if (this.f_58857_.f_46443_) {
                this.m_6596_();
            } else {
                this.f_58857_.m_151543_(this.f_58858_);
                if (!this.setChangedQueued) {
                    TickHandler.instance().addCallable((LevelAccessor)null, this::setChangedAtEndOfTick);
                    this.setChangedQueued = true;
                }
            }
        }
    }

    public void securityBreak() {
        this.f_58857_.m_46961_(this.f_58858_, true);
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    private void exportResultsItemsME() {
        for (int slot = this.FIRST_OUTPUT_SLOT; slot <= this.LAST_OUTPUT_SLOT; ++slot) {
            int getCountExport;
            ItemStack stackInSlot = this.inventory.getStackInSlot(slot);
            if (stackInSlot.m_41619_() || (getCountExport = Math.toIntExact(this.getMainNode().getGrid().getStorageService().getInventory().insert((AEKey)AEItemKey.of((ItemStack)stackInSlot), (long)stackInSlot.m_41613_(), Actionable.MODULATE, IActionSource.empty()))) <= 0) continue;
            stackInSlot.m_41774_(getCountExport);
            this.inventory.setStackInSlot(slot, stackInSlot);
        }
    }
}

