/*
 * Decompiled with CFR 0.152.
 */
package net.lmor.botanicalextramachinery.entities.manaSpark;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.lmor.botanicalextramachinery.ModItems;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.block.IWandHUD;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.mana.spark.IManaSpark;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.SparkHelper;
import vazkii.botania.api.mana.spark.SparkUpgradeType;
import vazkii.botania.common.entity.EntitySparkBase;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.item.ItemSparkUpgrade;
import vazkii.botania.common.item.ItemTwigWand;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.IPacket;
import vazkii.botania.network.clientbound.PacketBotaniaEffect;
import vazkii.botania.xplat.IXplatAbstractions;

public class EntityManaSparkPattern
extends EntitySparkBase
implements IManaSpark {
    protected int TRANSFER_RATE;
    private static final String TAG_UPGRADE = "upgrade";
    private static final EntityDataAccessor<Integer> UPGRADE = SynchedEntityData.m_135353_(EntityManaSparkPattern.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final Set<IManaSpark> transfers = Collections.newSetFromMap(new WeakHashMap());
    private int removeTransferants = 2;

    public EntityManaSparkPattern(EntityType<?> entityEntityType, Level level) {
        super(entityEntityType, level);
    }

    protected Item getSparkItem() {
        return ModItems.malachiteSpark;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(UPGRADE, (Object)0);
    }

    @NotNull
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)this.getSparkItem());
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            ISparkAttachable tile = this.getAttachedTile();
            if (tile == null) {
                this.dropAndKill();
            } else {
                int spend;
                IManaReceiver receiver = this.getAttachedManaReceiver();
                SparkUpgradeType upgrade = this.getUpgrade();
                Collection<IManaSpark> transfers = this.getTransfers();
                switch (upgrade) {
                    case DISPERSIVE: {
                        Player player2;
                        List validSparks = SparkHelper.getEntitiesAround(Player.class, (Level)this.f_19853_, (double)this.m_20185_(), (double)(this.m_20186_() + (double)this.m_20206_() / 2.0), (double)this.m_20189_());
                        HashMap receivingPlayers = new HashMap();
                        ItemStack input = new ItemStack((ItemLike)this.getSparkItem());
                        for (Player player2 : validSparks) {
                            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                            stacks.addAll((Collection<ItemStack>)player2.m_150109_().f_35974_);
                            stacks.addAll((Collection<ItemStack>)player2.m_150109_().f_35975_);
                            Container inv = BotaniaAPI.instance().getAccessoriesInventory(player2);
                            for (spend = 0; spend < inv.m_6643_(); ++spend) {
                                stacks.add(inv.m_8020_(spend));
                            }
                            for (ItemStack stack : stacks) {
                                int recv;
                                HashMap<IManaItem, Integer> receivingStacks;
                                IManaItem manaItem = IXplatAbstractions.INSTANCE.findManaItem(stack);
                                if (stack.m_41619_() || manaItem == null || !manaItem.canReceiveManaFromItem(input)) continue;
                                boolean add = false;
                                if (!receivingPlayers.containsKey(player2)) {
                                    add = true;
                                    receivingStacks = new HashMap<IManaItem, Integer>();
                                } else {
                                    receivingStacks = (HashMap<IManaItem, Integer>)receivingPlayers.get(player2);
                                }
                                if ((recv = Math.min(receiver.getCurrentMana(), Math.min(this.TRANSFER_RATE, manaItem.getMaxMana() - manaItem.getMana()))) <= 0) continue;
                                receivingStacks.put(manaItem, recv);
                                if (!add) continue;
                                receivingPlayers.put(player2, receivingStacks);
                            }
                        }
                        if (receivingPlayers.isEmpty()) break;
                        ArrayList keys = new ArrayList(receivingPlayers.keySet());
                        Collections.shuffle(keys);
                        player2 = (Player)keys.iterator().next();
                        Map items = (Map)receivingPlayers.get(player2);
                        Map.Entry e2 = items.entrySet().iterator().next();
                        IManaItem manaItem = (IManaItem)e2.getKey();
                        int cost = (Integer)e2.getValue();
                        int manaToPut = Math.min(receiver.getCurrentMana(), cost);
                        manaItem.addMana(manaToPut);
                        receiver.receiveMana(-manaToPut);
                        this.particlesTowards((Entity)player2);
                        break;
                    }
                    case DOMINANT: {
                        List validSparks = SparkHelper.getSparksAround((Level)this.f_19853_, (double)this.m_20185_(), (double)(this.m_20186_() + (double)(this.m_20206_() / 2.0f)), (double)this.m_20189_(), (DyeColor)this.getNetwork()).filter(s -> {
                            SparkUpgradeType otherUpgrade = s.getUpgrade();
                            return s != this && otherUpgrade == SparkUpgradeType.NONE && s.getAttachedManaReceiver() instanceof IManaPool;
                        }).collect(Collectors.toList());
                        if (validSparks.size() <= 0) break;
                        ((IManaSpark)validSparks.get(this.f_19853_.f_46441_.nextInt(validSparks.size()))).registerTransfer((IManaSpark)this);
                        break;
                    }
                    case RECESSIVE: {
                        Stream<IManaSpark> iManaSparkStream = SparkHelper.getSparksAround((Level)this.f_19853_, (double)this.m_20185_(), (double)(this.m_20186_() + (double)(this.m_20206_() / 2.0f)), (double)this.m_20189_(), (DyeColor)this.getNetwork()).filter(s -> {
                            SparkUpgradeType otherUpgrade = s.getUpgrade();
                            return s != this && otherUpgrade != SparkUpgradeType.DOMINANT && otherUpgrade != SparkUpgradeType.RECESSIVE && otherUpgrade != SparkUpgradeType.ISOLATED;
                        });
                        Objects.requireNonNull(transfers);
                        iManaSparkStream.forEach(e -> transfers.add((IManaSpark)e));
                    }
                }
                if (!transfers.isEmpty()) {
                    int manaTotal = Math.min(this.TRANSFER_RATE * transfers.size(), receiver.getCurrentMana());
                    int count = transfers.size();
                    int manaSpent = 0;
                    if (manaTotal > 0) {
                        for (IManaSpark spark : transfers) {
                            --count;
                            ISparkAttachable attached = spark.getAttachedTile();
                            IManaReceiver attachedReceiver = spark.getAttachedManaReceiver();
                            if (attached == null || attachedReceiver == null || attachedReceiver.isFull() || spark.areIncomingTransfersDone()) continue;
                            spend = Math.min(attached.getAvailableSpaceForMana(), (manaTotal - manaSpent) / (count + 1));
                            attachedReceiver.receiveMana(spend);
                            manaSpent += spend;
                            this.particlesTowards(spark.entity());
                        }
                        receiver.receiveMana(-manaSpent);
                    }
                }
                if (this.removeTransferants > 0) {
                    --this.removeTransferants;
                }
                this.filterTransfers();
            }
        }
    }

    private void particlesTowards(Entity e) {
        IXplatAbstractions.INSTANCE.sendToTracking((Entity)this, (IPacket)new PacketBotaniaEffect(EffectType.SPARK_MANA_FLOW, this.m_20185_(), this.m_20186_(), this.m_20189_(), new int[]{this.m_142049_(), e.m_142049_(), ColorHelper.getColorValue((DyeColor)this.getNetwork())}));
    }

    public static void particleBeam(Player player, Entity e1, Entity e2) {
        if (e1 != null && e2 != null && !e1.m_183503_().f_46443_) {
            IXplatAbstractions.INSTANCE.sendToPlayer(player, (IPacket)new PacketBotaniaEffect(EffectType.SPARK_NET_INDICATOR, e1.m_20185_(), e1.m_20186_(), e1.m_20189_(), new int[]{e1.m_142049_(), e2.m_142049_()}));
        }
    }

    private void dropAndKill() {
        SparkUpgradeType upgrade = this.getUpgrade();
        this.m_5552_(new ItemStack((ItemLike)this.getSparkItem()), 0.0f);
        if (upgrade != SparkUpgradeType.NONE) {
            this.m_5552_(ItemSparkUpgrade.getByType((SparkUpgradeType)upgrade), 0.0f);
        }
        this.m_146870_();
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.m_6084_() && !stack.m_41619_()) {
            DyeItem dye;
            DyeColor color;
            SparkUpgradeType upgrade = this.getUpgrade();
            if (stack.m_41720_() instanceof ItemTwigWand) {
                if (!this.f_19853_.f_46443_) {
                    if (player.m_6144_()) {
                        if (upgrade != SparkUpgradeType.NONE) {
                            this.m_5552_(ItemSparkUpgrade.getByType((SparkUpgradeType)upgrade), 0.0f);
                            this.setUpgrade(SparkUpgradeType.NONE);
                            this.transfers.clear();
                            this.removeTransferants = 2;
                        } else {
                            this.dropAndKill();
                        }
                    } else {
                        SparkHelper.getSparksAround((Level)this.f_19853_, (double)this.m_20185_(), (double)(this.m_20186_() + (double)(this.m_20206_() / 2.0f)), (double)this.m_20189_(), (DyeColor)this.getNetwork()).forEach(s -> EntityManaSparkPattern.particleBeam(player, (Entity)this, s.entity()));
                    }
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            Item item = stack.m_41720_();
            if (item instanceof ItemSparkUpgrade) {
                ItemSparkUpgrade newUpgrade = (ItemSparkUpgrade)item;
                if (upgrade == SparkUpgradeType.NONE) {
                    if (!this.f_19853_.f_46443_) {
                        this.setUpgrade(newUpgrade.type);
                        stack.m_41774_(1);
                    }
                    return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
                }
            }
            if (stack.m_150930_(vazkii.botania.common.item.ModItems.phantomInk)) {
                if (!this.f_19853_.f_46443_) {
                    this.m_6842_(true);
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            item = stack.m_41720_();
            if (item instanceof DyeItem && (color = (dye = (DyeItem)item).m_41089_()) != this.getNetwork()) {
                if (!this.f_19853_.f_46443_) {
                    this.setNetwork(color);
                    stack.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    protected void m_7378_(@NotNull CompoundTag cmp) {
        super.m_7378_(cmp);
        this.setUpgrade(SparkUpgradeType.values()[cmp.m_128451_(TAG_UPGRADE)]);
    }

    protected void m_7380_(@NotNull CompoundTag cmp) {
        super.m_7380_(cmp);
        cmp.m_128405_(TAG_UPGRADE, this.getUpgrade().ordinal());
    }

    @Nullable
    public ISparkAttachable getAttachedTile() {
        return IXplatAbstractions.INSTANCE.findSparkAttachable(this.m_183503_(), this.getAttachPos(), this.m_183503_().m_8055_(this.getAttachPos()), this.m_183503_().m_7702_(this.getAttachPos()), Direction.UP);
    }

    private void filterTransfers() {
        Iterator<IManaSpark> iter = this.transfers.iterator();
        while (iter.hasNext()) {
            IManaSpark spark = iter.next();
            SparkUpgradeType upgr = this.getUpgrade();
            SparkUpgradeType supgr = spark.getUpgrade();
            IManaReceiver arecv = spark.getAttachedManaReceiver();
            if (spark != this && ((Entity)spark).m_6084_() && !spark.areIncomingTransfersDone() && this.getNetwork() == spark.getNetwork() && arecv != null && !arecv.isFull() && (upgr == SparkUpgradeType.NONE && supgr == SparkUpgradeType.DOMINANT || upgr == SparkUpgradeType.RECESSIVE && (supgr == SparkUpgradeType.NONE || supgr == SparkUpgradeType.DISPERSIVE) || !(arecv instanceof IManaPool))) continue;
            iter.remove();
        }
        return;
    }

    public Collection<IManaSpark> getTransfers() {
        this.filterTransfers();
        return this.transfers;
    }

    private boolean hasTransfer(IManaSpark entity) {
        return this.transfers.contains(entity);
    }

    public void registerTransfer(IManaSpark manaSpark) {
        if (!this.hasTransfer(manaSpark)) {
            this.transfers.add(manaSpark);
        }
    }

    public SparkUpgradeType getUpgrade() {
        return SparkUpgradeType.values()[(Integer)this.f_19804_.m_135370_(UPGRADE)];
    }

    public void setUpgrade(SparkUpgradeType sparkUpgradeType) {
        this.f_19804_.m_135381_(UPGRADE, (Object)sparkUpgradeType.ordinal());
    }

    public boolean areIncomingTransfersDone() {
        if (this.getAttachedManaReceiver() instanceof IManaPool) {
            return this.removeTransferants > 0;
        }
        ISparkAttachable attachable = this.getAttachedTile();
        return attachable != null && attachable.areIncomingTranfersDone();
    }

    public record WandHud(EntityManaSparkPattern entity) implements IWandHUD
    {
        public void renderHUD(PoseStack ms, Minecraft mc) {
            ItemStack sparkStack = new ItemStack((ItemLike)this.entity.getSparkItem());
            ItemStack augmentStack = ItemSparkUpgrade.getByType((SparkUpgradeType)this.entity.getUpgrade());
            DyeColor networkColor = this.entity.getNetwork();
            String colorName = networkColor.m_41065_();
            MutableComponent networkColorName = new TranslatableComponent("color.minecraft." + colorName).m_130940_(ChatFormatting.ITALIC);
            int textColor = ColorHelper.getColorValue((DyeColor)networkColor);
            int width = 4 + Collections.max(Arrays.asList(mc.f_91062_.m_92852_((FormattedText)networkColorName), WandHud.itemWithNameWidth(mc, sparkStack), WandHud.itemWithNameWidth(mc, augmentStack)));
            int height = augmentStack.m_41619_() ? 30 : 50;
            int networkColorTextStart = mc.f_91062_.m_92852_((FormattedText)networkColorName) / 2;
            int centerX = mc.m_91268_().m_85445_() / 2;
            int centerY = mc.m_91268_().m_85446_() / 2;
            WandHud.renderHUDBox(ms, centerX - width / 2, centerY + 8, centerX + width / 2, centerY + 8 + height);
            WandHud.renderItemWithNameCentered(ms, mc, sparkStack, centerY + 10, textColor);
            WandHud.renderItemWithNameCentered(ms, mc, augmentStack, centerY + 28, textColor);
            mc.f_91062_.m_92763_(ms, (Component)networkColorName, (float)(centerX - networkColorTextStart), (float)(centerY + (augmentStack.m_41619_() ? 28 : 46)), textColor);
        }

        public static int itemWithNameWidth(Minecraft mc, ItemStack itemStack) {
            return 20 + mc.f_91062_.m_92852_((FormattedText)itemStack.m_41786_());
        }

        public static void renderHUDBox(PoseStack ms, int startX, int startY, int endX, int endY) {
            GuiComponent.m_93172_((PoseStack)ms, (int)startX, (int)startY, (int)endX, (int)endY, (int)0x44000000);
            GuiComponent.m_93172_((PoseStack)ms, (int)(startX - 2), (int)(startY - 2), (int)(endX + 2), (int)(endY + 2), (int)0x44000000);
        }

        public static void renderItemWithNameCentered(PoseStack ms, Minecraft mc, ItemStack itemStack, int startY, int color) {
            int centerX = mc.m_91268_().m_85445_() / 2;
            int startX = centerX - (20 + mc.f_91062_.m_92852_((FormattedText)itemStack.m_41786_())) / 2;
            WandHud.renderItemWithName(ms, mc, itemStack, startX, startY, color);
        }

        public static void renderItemWithName(PoseStack ps, Minecraft mc, ItemStack itemStack, int startX, int startY, int color) {
            if (!itemStack.m_41619_()) {
                mc.f_91062_.m_92763_(ps, itemStack.m_41786_(), (float)(startX + 20), (float)(startY + 4), color);
                mc.m_91291_().m_115203_(itemStack, startX, startY);
            }
        }
    }
}

