/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.api.misc;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import sonar.fluxnetworks.api.device.FluxDeviceType;
import sonar.fluxnetworks.common.connection.FluxNetwork;
import sonar.fluxnetworks.common.connection.FluxNetworkData;
import sonar.fluxnetworks.common.device.TileFluxDevice;

public enum FluxConfigurationType {
    NETWORK("networkID"),
    PRIORITY("priority"),
    PRIORITY_SETTING("surgeMode"),
    TRANSFER("limit"),
    TRANSFER_SETTING("disableLimit");

    public static final FluxConfigurationType[] VALUES;
    private final String key;

    private FluxConfigurationType(String key) {
        this.key = key;
    }

    public void copy(@Nonnull Player player, @Nonnull CompoundTag tag, @Nonnull TileFluxDevice device) {
        switch (this) {
            case NETWORK: {
                tag.m_128405_(this.key, device.getNetworkID());
                break;
            }
            case PRIORITY: {
                tag.m_128405_(this.key, device.getRawPriority());
                break;
            }
            case PRIORITY_SETTING: {
                tag.m_128379_(this.key, device.getSurgeMode());
                break;
            }
            case TRANSFER: {
                tag.m_128356_(this.key, device.getRawLimit());
                break;
            }
            case TRANSFER_SETTING: {
                tag.m_128379_(this.key, device.getDisableLimit());
            }
        }
    }

    public void paste(@Nonnull Player player, @Nonnull CompoundTag tag, @Nonnull TileFluxDevice device) {
        if (!tag.m_128441_(this.key)) {
            return;
        }
        if (this == NETWORK) {
            FluxNetwork network;
            if (device.getDeviceType() != FluxDeviceType.CONTROLLER && (!(network = FluxNetworkData.getNetwork(tag.m_128451_(this.key))).isValid() || network.canPlayerAccess(player))) {
                if (network.isValid()) {
                    device.setOwnerUUID(player.m_142081_());
                }
                device.connect(network);
            }
        } else {
            device.readCustomTag(tag, (byte)19);
        }
    }

    static {
        VALUES = FluxConfigurationType.values();
    }
}

