/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.mui;

import icyllis.modernui.animation.Animator;
import icyllis.modernui.animation.AnimatorListener;
import icyllis.modernui.animation.LayoutTransition;
import icyllis.modernui.animation.ObjectAnimator;
import icyllis.modernui.animation.TimeInterpolator;
import icyllis.modernui.core.Context;
import icyllis.modernui.fragment.Fragment;
import icyllis.modernui.graphics.Canvas;
import icyllis.modernui.graphics.Image;
import icyllis.modernui.graphics.Paint;
import icyllis.modernui.graphics.Rect;
import icyllis.modernui.graphics.drawable.Drawable;
import icyllis.modernui.mc.forge.ContainerDrawHelper;
import icyllis.modernui.text.InputFilter;
import icyllis.modernui.text.method.DigitsInputFilter;
import icyllis.modernui.util.DataSet;
import icyllis.modernui.util.FloatProperty;
import icyllis.modernui.util.IntProperty;
import icyllis.modernui.view.LayoutInflater;
import icyllis.modernui.view.View;
import icyllis.modernui.view.ViewGroup;
import icyllis.modernui.widget.EditText;
import icyllis.modernui.widget.FrameLayout;
import icyllis.modernui.widget.LinearLayout;
import icyllis.modernui.widget.TextView;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.locale.Language;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import sonar.fluxnetworks.client.design.RoundRectDrawable;
import sonar.fluxnetworks.client.mui.FluxDeviceUI;
import sonar.fluxnetworks.common.device.TileFluxDevice;
import sonar.fluxnetworks.register.ClientMessages;

public class DeviceHomeTab
extends Fragment {
    private final TileFluxDevice mDevice;
    private TextView mCustomName;
    private TextView mPriority;
    private TextView mLimit;

    public DeviceHomeTab(@Nonnull TileFluxDevice device) {
        this.mDevice = device;
    }

    @Nullable
    public View onCreateView(@Nonnull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable DataSet savedInstanceState) {
        Language lang = Language.m_128107_();
        LinearLayout content = new LinearLayout(this.requireContext());
        content.setOrientation(1);
        content.setLayoutTransition(new LayoutTransition());
        for (int i = 0; i < 3; ++i) {
            EditText v = new EditText(this.requireContext());
            switch (i) {
                case 0: {
                    v.setText((CharSequence)this.mDevice.getCustomName());
                    v.setHint((CharSequence)lang.m_6834_(this.mDevice.m_58900_().m_60734_().m_7705_()));
                    v.setFilters(new InputFilter[]{new InputFilter.LengthFilter(24)});
                    v.setOnFocusChangeListener((__, hasFocus) -> {
                        if (!hasFocus) {
                            CompoundTag tag = new CompoundTag();
                            tag.m_128359_("customName", this.mCustomName.getText().toString());
                            ClientMessages.editTile(this.requireArguments().getInt("token"), this.mDevice, tag);
                        }
                    });
                    this.mCustomName = v;
                    break;
                }
                case 1: {
                    v.setText((CharSequence)Integer.toString(this.mDevice.getRawPriority()));
                    v.setHint((CharSequence)"Priority");
                    v.setHintTextColor(-8355712);
                    v.setFilters(new InputFilter[]{new InputFilter.LengthFilter(5), DigitsInputFilter.getInstance((Locale)v.getTextLocale())});
                    v.setOnFocusChangeListener((__, hasFocus) -> {
                        if (!hasFocus) {
                            int priority = Mth.m_14045_((int)Integer.parseInt(this.mPriority.getText().toString()), (int)-9999, (int)9999);
                            this.mPriority.setTextKeepState((CharSequence)Integer.toString(priority));
                            CompoundTag tag = new CompoundTag();
                            tag.m_128405_("priority", priority);
                            ClientMessages.editTile(this.requireArguments().getInt("token"), this.mDevice, tag);
                        }
                    });
                    this.mPriority = v;
                    break;
                }
                default: {
                    v.setText((CharSequence)Long.toString(this.mDevice.getRawLimit()));
                    v.setHint((CharSequence)"Transfer Limit");
                    v.setHintTextColor(-8355712);
                    v.setFilters(new InputFilter[]{new InputFilter.LengthFilter(15), DigitsInputFilter.getInstance((Locale)v.getTextLocale())});
                    v.setOnFocusChangeListener((__, hasFocus) -> {
                        if (!hasFocus) {
                            long limit = Long.parseLong(this.mLimit.getText().toString());
                            this.mLimit.setTextKeepState((CharSequence)Long.toString(limit));
                            CompoundTag tag = new CompoundTag();
                            tag.m_128356_("limit", limit);
                            ClientMessages.editTile(this.requireArguments().getInt("token"), this.mDevice, tag);
                        }
                    });
                    this.mLimit = v;
                }
            }
            v.setSingleLine();
            v.setBackground((Drawable)new RoundRectDrawable((View)v));
            v.setTextSize(16.0f);
            v.setCompoundDrawablesRelativeWithIntrinsicBounds((Drawable)new TextFieldStart((View)v, FluxDeviceUI.sButtonIcon, ((i + 1) % 3 + 1) * 64), null, null, null);
            v.setTextAlignment(5);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
            params.setMargins(content.dp(20.0f), content.dp(i == 0 ? 50.0f : 2.0f), content.dp(20.0f), content.dp(2.0f));
            content.postDelayed(() -> content.addView((View)v, (ViewGroup.LayoutParams)params), (long)((i + 1) * 100));
        }
        ConnectorView v = new ConnectorView(this.requireContext(), FluxDeviceUI.sButtonIcon);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -1);
        params.setMargins(content.dp(8.0f), content.dp(2.0f), content.dp(8.0f), content.dp(8.0f));
        content.postDelayed(() -> content.addView((View)v, (ViewGroup.LayoutParams)params), 400L);
        content.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        return content;
    }

    static class TextFieldStart
    extends Drawable {
        private final Image mImage;
        private final int mSrcLeft;
        private final int mSize;

        public TextFieldStart(View v, Image image, int srcLeft) {
            this.mImage = image;
            this.mSrcLeft = srcLeft;
            this.mSize = v.dp(24.0f);
        }

        public void draw(@Nonnull Canvas canvas) {
            Rect b = this.getBounds();
            canvas.drawImage(this.mImage, (float)this.mSrcLeft, 192.0f, (float)(this.mSrcLeft + 64), 256.0f, (float)b.left, (float)b.top, (float)b.right, (float)b.bottom, null);
        }

        public int getIntrinsicWidth() {
            return this.mSize;
        }

        public int getIntrinsicHeight() {
            return this.mSize;
        }

        public boolean getPadding(@Nonnull Rect padding) {
            int h = Math.round((float)this.mSize / 4.0f);
            int v = Math.round((float)this.mSize / 6.0f);
            padding.set(h, v, h, v);
            return true;
        }
    }

    static class ConnectorView
    extends View {
        private final Image mImage;
        private final int mSize;
        private float mRodLength;
        private final Paint mBoxPaint = new Paint();
        private final ObjectAnimator mRodAnimator;
        private final ObjectAnimator mBoxAnimator;
        private final ItemStack mItem = Items.f_41959_.m_7968_();

        public ConnectorView(Context context, Image image) {
            super(context);
            this.mImage = image;
            this.mSize = this.dp(32.0f);
            this.mRodAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (FloatProperty)new FloatProperty<ConnectorView>("rod"){

                public void setValue(@Nonnull ConnectorView object, float value) {
                    object.mRodLength = value;
                    this.invalidate();
                }

                public Float get(@Nonnull ConnectorView object) {
                    return Float.valueOf(object.mRodLength);
                }
            }, (float[])new float[]{0.0f, this.mSize});
            this.mRodAnimator.setInterpolator(TimeInterpolator.DECELERATE);
            this.mRodAnimator.setDuration(400L);
            this.mRodAnimator.addListener(new AnimatorListener(){

                public void onAnimationEnd(@Nonnull Animator animation) {
                    mBoxAnimator.start();
                }
            });
            this.mBoxAnimator = ObjectAnimator.ofInt((Object)this.mBoxPaint, (IntProperty)new IntProperty<Paint>("box"){

                public void setValue(@Nonnull Paint object, int value) {
                    object.setAlpha(value);
                    this.invalidate();
                }

                public Integer get(@Nonnull Paint object) {
                    return object.getColor() >>> 24;
                }
            }, (int[])new int[]{0, 128});
            this.mRodAnimator.setInterpolator(TimeInterpolator.LINEAR);
            this.mBoxAnimator.setDuration(400L);
        }

        protected void onAttachedToWindow() {
            super.onAttachedToWindow();
            this.mRodAnimator.start();
            this.mBoxPaint.setRGBA(64, 64, 64, 0);
        }

        protected void onDraw(@Nonnull Canvas canvas) {
            Paint paint = Paint.obtain();
            paint.setColor(-14066038);
            paint.setAlpha(192);
            paint.setStrokeWidth((float)this.mSize / 8.0f);
            float centerX = (float)this.getWidth() / 2.0f;
            float centerY = (float)this.getHeight() / 2.0f;
            int boxAlpha = this.mBoxPaint.getColor() >>> 24;
            float px1l = centerX - 0.234375f * (float)this.mSize;
            float py1 = centerY + 0.125f * (float)this.mSize;
            canvas.save();
            canvas.rotate(22.5f, px1l, py1);
            canvas.drawLine(px1l, py1, px1l - this.mRodLength * 2.0f, py1, paint);
            canvas.restore();
            if (boxAlpha > 0) {
                canvas.drawRect(px1l - (float)this.mSize * 2.9f, py1 - (float)this.mSize * 1.1f, px1l - (float)this.mSize * 1.9f, py1 - (float)this.mSize * 0.1f, this.mBoxPaint);
            }
            float px1r = centerX + 0.234375f * (float)this.mSize;
            canvas.save();
            canvas.rotate(-22.5f, px1r, py1);
            canvas.drawLine(px1r, py1, px1r + this.mRodLength * 2.0f, py1, paint);
            canvas.restore();
            if (boxAlpha > 0) {
                canvas.drawRect(px1r + (float)this.mSize * 1.9f, py1 - (float)this.mSize * 1.1f, px1r + (float)this.mSize * 2.9f, py1 - (float)this.mSize * 0.1f, this.mBoxPaint);
            }
            float py2 = centerY + 0.296875f * (float)this.mSize;
            canvas.drawLine(centerX, py2, centerX, py2 + this.mRodLength, paint);
            if (boxAlpha > 0) {
                canvas.drawRect(centerX - (float)this.mSize * 0.5f, py2 + (float)this.mSize * 1.1f, centerX + (float)this.mSize * 0.5f, py2 + (float)this.mSize * 2.1f, this.mBoxPaint);
            }
            float offset = (float)this.mSize / 2.0f;
            canvas.drawImage(this.mImage, 0.0f, 192.0f, 64.0f, 256.0f, centerX - offset, centerY - offset, centerX + offset, centerY + offset, null);
            canvas.save();
            canvas.rotate(-22.5f, px1l, py1);
            canvas.drawLine(px1l, py1, px1l - this.mRodLength * 2.0f, py1, paint);
            canvas.restore();
            if (boxAlpha > 0) {
                canvas.drawRect(px1l - (float)this.mSize * 2.9f, py1 + (float)this.mSize * 0.1f, px1l - (float)this.mSize * 1.9f, py1 + (float)this.mSize * 1.1f, this.mBoxPaint);
            }
            canvas.save();
            canvas.rotate(22.5f, px1r, py1);
            canvas.drawLine(px1r, py1, px1r + this.mRodLength * 2.0f, py1, paint);
            canvas.restore();
            if (boxAlpha > 0) {
                canvas.drawRect(px1r + (float)this.mSize * 1.9f, py1 + (float)this.mSize * 0.1f, px1r + (float)this.mSize * 2.9f, py1 + (float)this.mSize * 1.1f, this.mBoxPaint);
            }
            py2 = centerY - 0.296875f * (float)this.mSize;
            canvas.drawLine(centerX, py2, centerX, py2 - this.mRodLength, paint);
            if (boxAlpha > 0) {
                canvas.drawRect(centerX - (float)this.mSize * 0.5f, py2 - (float)this.mSize * 2.1f, centerX + (float)this.mSize * 0.5f, py2 - (float)this.mSize * 1.1f, this.mBoxPaint);
                ContainerDrawHelper.drawItem((Canvas)canvas, (ItemStack)this.mItem, (float)centerX, (float)(py2 - (float)this.mSize * 1.6f), (float)0.0f, (float)this.mSize, (int)0);
            }
            paint.recycle();
        }
    }
}

