/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.device;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import sonar.fluxnetworks.api.energy.IBlockEnergyBridge;

public class SideTransfer {
    private final Direction mSide;
    @Nullable
    private BlockEntity mTarget;
    private IBlockEnergyBridge mBridge;
    private ItemStack mDisplayStack = ItemStack.f_41583_;
    public long mChange;

    public SideTransfer(@Nonnull Direction direction) {
        this.mSide = direction.m_122424_();
    }

    public void set(@Nullable BlockEntity target, IBlockEnergyBridge bridge) {
        this.mTarget = target;
        this.mBridge = bridge;
        this.mDisplayStack = target != null ? new ItemStack((ItemLike)target.m_58900_().m_60734_()) : ItemStack.f_41583_;
    }

    public long send(long amount, boolean simulate) {
        if (this.mTarget == null || this.mTarget.m_58901_()) {
            return 0L;
        }
        if (this.mBridge.canAddEnergy(this.mTarget, this.mSide)) {
            long op = this.mBridge.addEnergy(amount, this.mTarget, this.mSide, simulate);
            if (!simulate) {
                this.mChange -= op;
            }
            return op;
        }
        return 0L;
    }

    public void receive(long amount) {
        this.mChange += amount;
    }

    public void onCycleStart() {
        this.mChange = 0L;
    }

    @Nullable
    public BlockEntity getTarget() {
        return this.mTarget;
    }

    @Nonnull
    public ItemStack getDisplayStack() {
        return this.mDisplayStack;
    }
}

