/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.integration.energy;

import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import sonar.fluxnetworks.api.FluxCapabilities;
import sonar.fluxnetworks.api.energy.IBlockEnergyBridge;
import sonar.fluxnetworks.api.energy.IFNEnergyStorage;
import sonar.fluxnetworks.api.energy.IItemEnergyBridge;
import sonar.fluxnetworks.common.util.FluxUtils;

public class FNEnergyBridge
implements IBlockEnergyBridge,
IItemEnergyBridge {
    public static final FNEnergyBridge INSTANCE = new FNEnergyBridge();

    private FNEnergyBridge() {
    }

    @Override
    public boolean hasCapability(@Nonnull BlockEntity target, @Nonnull Direction side) {
        return !target.m_58901_() && target.getCapability(FluxCapabilities.FN_ENERGY_STORAGE, side).isPresent();
    }

    @Override
    public boolean canAddEnergy(@Nonnull BlockEntity target, @Nonnull Direction side) {
        IFNEnergyStorage storage;
        if (!target.m_58901_() && (storage = FluxUtils.get((ICapabilityProvider)target, FluxCapabilities.FN_ENERGY_STORAGE, side)) != null) {
            return storage.canReceive();
        }
        return false;
    }

    @Override
    public boolean canRemoveEnergy(@Nonnull BlockEntity target, @Nonnull Direction side) {
        IFNEnergyStorage storage;
        if (!target.m_58901_() && (storage = FluxUtils.get((ICapabilityProvider)target, FluxCapabilities.FN_ENERGY_STORAGE, side)) != null) {
            return storage.canExtract();
        }
        return false;
    }

    @Override
    public long addEnergy(long amount, @Nonnull BlockEntity target, @Nonnull Direction side, boolean simulate) {
        IFNEnergyStorage storage = FluxUtils.get((ICapabilityProvider)target, FluxCapabilities.FN_ENERGY_STORAGE, side);
        return storage == null ? 0L : storage.receiveEnergyL(amount, simulate);
    }

    @Override
    public long removeEnergy(long amount, @Nonnull BlockEntity target, @Nonnull Direction side, boolean simulate) {
        IFNEnergyStorage storage = FluxUtils.get((ICapabilityProvider)target, FluxCapabilities.FN_ENERGY_STORAGE, side);
        return storage == null ? 0L : storage.extractEnergyL(amount, simulate);
    }

    @Override
    public boolean hasCapability(@Nonnull ItemStack stack) {
        return stack.getCapability(FluxCapabilities.FN_ENERGY_STORAGE).isPresent();
    }

    @Override
    public boolean canAddEnergy(@Nonnull ItemStack stack) {
        IFNEnergyStorage storage = FluxUtils.get((ICapabilityProvider)stack, FluxCapabilities.FN_ENERGY_STORAGE);
        return storage != null && storage.canReceive();
    }

    @Override
    public boolean canRemoveEnergy(@Nonnull ItemStack stack) {
        IFNEnergyStorage storage = FluxUtils.get((ICapabilityProvider)stack, FluxCapabilities.FN_ENERGY_STORAGE);
        return storage != null && storage.canExtract();
    }

    @Override
    public long addEnergy(long amount, @Nonnull ItemStack stack, boolean simulate) {
        IFNEnergyStorage storage = FluxUtils.get((ICapabilityProvider)stack, FluxCapabilities.FN_ENERGY_STORAGE);
        return storage == null ? 0L : storage.receiveEnergyL(amount, simulate);
    }

    @Override
    public long removeEnergy(long amount, @Nonnull ItemStack stack, boolean simulate) {
        IFNEnergyStorage storage = FluxUtils.get((ICapabilityProvider)stack, FluxCapabilities.FN_ENERGY_STORAGE);
        return storage == null ? 0L : storage.extractEnergyL(amount, simulate);
    }
}

