/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.compat.jei;

import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.fluids.FluidStack;
import plus.dragons.createenchantmentindustry.EnchantmentIndustry;
import plus.dragons.createenchantmentindustry.compat.jei.category.DisenchantingCategory;
import plus.dragons.createenchantmentindustry.compat.jei.category.RecipeCategoryBuilder;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.disenchanter.DisenchantRecipe;
import plus.dragons.createenchantmentindustry.content.contraptions.fluids.experience.ExperienceFluid;
import plus.dragons.createenchantmentindustry.content.contraptions.fluids.experience.HyperExperienceFluid;
import plus.dragons.createenchantmentindustry.entry.CeiBlocks;
import plus.dragons.createenchantmentindustry.entry.CeiFluids;
import plus.dragons.createenchantmentindustry.entry.CeiRecipeTypes;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@JeiPlugin
public class CeiJEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = EnchantmentIndustry.genRL("jei_plugin");
    protected final List<CreateRecipeCategory<?>> allCategories = new ArrayList();
    protected IIngredientManager ingredientManager;

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.loadCategories(registration);
        registration.addRecipeCategories((IRecipeCategory[])this.allCategories.toArray(IRecipeCategory[]::new));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.ingredientManager = registration.getIngredientManager();
        this.allCategories.forEach(c -> c.registerRecipes(registration));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        this.allCategories.forEach(c -> c.registerCatalysts(registration));
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        ArrayList<FluidStack> fluidIngredients = new ArrayList<FluidStack>();
        fluidIngredients.add(new FluidStack(((ExperienceFluid)CeiFluids.EXPERIENCE.get()).m_5613_(), 1000));
        fluidIngredients.add(new FluidStack(((HyperExperienceFluid)CeiFluids.HYPER_EXPERIENCE.get()).m_5613_(), 1000));
        jeiRuntime.getIngredientManager().addIngredientsAtRuntime((IIngredientType)ForgeTypes.FLUID_STACK, fluidIngredients);
    }

    private static <T extends Recipe<?>> RecipeCategoryBuilder<T> builder(Class<T> cls) {
        return new RecipeCategoryBuilder<T>("create_enchantment_industry", cls);
    }

    private void loadCategories(IRecipeCategoryRegistration registration) {
        this.allCategories.clear();
        this.allCategories.add(CeiJEIPlugin.builder(DisenchantRecipe.class).addTypedRecipes(CeiRecipeTypes.DISENCHANTING).catalyst(() -> CeiBlocks.DISENCHANTER.get()).emptyBackground(177, 50).build("disenchanting", (CreateRecipeCategory.Factory<DisenchantRecipe>)((CreateRecipeCategory.Factory)DisenchantingCategory::new)));
    }
}

