/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.chipped.compat.rei;

import earth.terrarium.chipped.compat.rei.ChippedRecipeCategory;
import earth.terrarium.chipped.recipe.ChippedRecipe;
import earth.terrarium.chipped.registry.ModBlocks;
import earth.terrarium.chipped.registry.ModRecipeTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class REIChippedPlugin
implements REIClientPlugin {
    public void registerCategories(CategoryRegistry registry) {
        registry.add(new DisplayCategory[]{new ChippedRecipeCategory(ModBlocks.BOTANIST_WORKBENCH.get()), new ChippedRecipeCategory(ModBlocks.GLASSBLOWER.get()), new ChippedRecipeCategory(ModBlocks.CARPENTERS_TABLE.get()), new ChippedRecipeCategory(ModBlocks.LOOM_TABLE.get()), new ChippedRecipeCategory(ModBlocks.MASON_TABLE.get()), new ChippedRecipeCategory(ModBlocks.ALCHEMY_BENCH.get()), new ChippedRecipeCategory(ModBlocks.MECHANIST_WORKBENCH.get())});
    }

    public void registerDisplays(DisplayRegistry registry) {
        Minecraft client = Minecraft.m_91087_();
        assert (client.f_91073_ != null);
        RecipeManager recipeManager = client.f_91073_.m_7465_();
        this.registerRecipes(recipeManager, registry, ModRecipeTypes.BOTANIST_WORKBENCH_TYPE.get(), ModBlocks.BOTANIST_WORKBENCH.get());
        this.registerRecipes(recipeManager, registry, ModRecipeTypes.CARPENTERS_TABLE_TYPE.get(), ModBlocks.CARPENTERS_TABLE.get());
        this.registerRecipes(recipeManager, registry, ModRecipeTypes.LOOM_TABLE_TYPE.get(), ModBlocks.LOOM_TABLE.get());
        this.registerRecipes(recipeManager, registry, ModRecipeTypes.MASON_TABLE_TYPE.get(), ModBlocks.MASON_TABLE.get());
        this.registerRecipes(recipeManager, registry, ModRecipeTypes.ALCHEMY_BENCH_TYPE.get(), ModBlocks.ALCHEMY_BENCH.get());
        this.registerRecipes(recipeManager, registry, ModRecipeTypes.MECHANIST_WORKBENCH_TYPE.get(), ModBlocks.MECHANIST_WORKBENCH.get());
    }

    private void registerRecipes(RecipeManager recipeManager, DisplayRegistry registry, RecipeType<ChippedRecipe> type, Block block) {
        ResourceLocation category = Registry.f_122824_.m_7981_((Object)block);
        for (ChippedRecipeCategory.FlattenedRecipe recipe : REIChippedPlugin.flatten(recipeManager.m_44013_(type), (CategoryIdentifier<ChippedRecipeCategory.FlattenedRecipe>)CategoryIdentifier.of((ResourceLocation)category))) {
            registry.add((Display)recipe);
        }
    }

    private static List<ChippedRecipeCategory.FlattenedRecipe> flatten(Collection<ChippedRecipe> recipes, CategoryIdentifier<ChippedRecipeCategory.FlattenedRecipe> category) {
        ArrayList<ChippedRecipeCategory.FlattenedRecipe> flattenedRecipes = new ArrayList<ChippedRecipeCategory.FlattenedRecipe>();
        for (ChippedRecipe recipe : recipes) {
            for (HolderSet<Item> tag : recipe.tags()) {
                List<Item> items = tag.m_203614_().filter(Holder::m_203633_).map(Holder::m_203334_).toList();
                Ingredient ingredient = Ingredient.m_43921_(items.stream().map(ItemStack::new));
                for (Item item : items) {
                    flattenedRecipes.add(new ChippedRecipeCategory.FlattenedRecipe(ingredient, new ItemStack((ItemLike)item), category));
                }
            }
        }
        return flattenedRecipes;
    }
}

