/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamicsandfriends;

import com.mojang.logging.LogUtils;
import cy.jdkdigital.dyenamicsandfriends.compat.CreateCompat;
import cy.jdkdigital.dyenamicsandfriends.loot.OptionalLootItem;
import cy.jdkdigital.dyenamicsandfriends.loot.condition.ModLoadedCondition;
import cy.jdkdigital.dyenamicsandfriends.loot.condition.OptionalLootItemBlockStatePropertyCondition;
import cy.jdkdigital.dyenamicsandfriends.registry.DyenamicRegistry;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.resource.PathResourcePack;
import org.slf4j.Logger;

@Mod(value="dyenamicsandfriends")
public class DyenamicsAndFriends {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String MODID = "dyenamicsandfriends";
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"dyenamicsandfriends");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"dyenamicsandfriends");
    public static final DeferredRegister<MenuType<?>> CONTAINER_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"dyenamicsandfriends");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITIES, (String)"dyenamicsandfriends");
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"dyenamicsandfriends");
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((ResourceKey)Registry.f_122914_, (String)"dyenamicsandfriends");
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"dyenamicsandfriends");
    public static final DeferredRegister<GlobalLootModifierSerializer<?>> LOOT_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.LOOT_MODIFIER_SERIALIZERS, (String)"dyenamicsandfriends");
    public static final DeferredRegister<LootPoolEntryType> LOOT_POOL_ENTRIES = DeferredRegister.create((ResourceKey)Registry.f_122815_, (String)"dyenamicsandfriends");
    public static final DeferredRegister<LootItemConditionType> LOOT_POOL_CONDITIONS = DeferredRegister.create((ResourceKey)Registry.f_122817_, (String)"dyenamicsandfriends");
    public static final RegistryObject<LootPoolEntryType> OPTIONAL_LOOT_ITEM = LOOT_POOL_ENTRIES.register("optional_loot_item", () -> new LootPoolEntryType((Serializer)new OptionalLootItem.Serializer()));
    public static final RegistryObject<LootItemConditionType> OPTIONAL_BLOCK_STATE_PROPERTY = LOOT_POOL_CONDITIONS.register("optional_block_state_property", () -> new LootItemConditionType((Serializer)new OptionalLootItemBlockStatePropertyCondition.Serializer()));
    public static final RegistryObject<LootItemConditionType> MOD_LOADED_CONDITION = LOOT_POOL_CONDITIONS.register("mod_loaded", () -> new LootItemConditionType((Serializer)new ModLoadedCondition.Serializer()));

    public DyenamicsAndFriends() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onPackEvent);
        DyenamicRegistry.setup();
        DyenamicRegistry.registerCompatBlocks();
        BLOCKS.register(modEventBus);
        BLOCK_ENTITIES.register(modEventBus);
        CONTAINER_TYPES.register(modEventBus);
        ITEMS.register(modEventBus);
        RECIPE_SERIALIZERS.register(modEventBus);
        RECIPE_TYPES.register(modEventBus);
        PARTICLE_TYPES.register(modEventBus);
        LOOT_SERIALIZERS.register(modEventBus);
        LOOT_POOL_ENTRIES.register(modEventBus);
        LOOT_POOL_CONDITIONS.register(modEventBus);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        if (ModList.get().isLoaded("create")) {
            CreateCompat.setup(event);
        }
    }

    private void onPackEvent(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.SERVER_DATA) {
            event.addRepositorySource((RepositorySource)new ModLoadedPackFinder());
        }
    }

    private static class ModLoadedPackFinder
    implements RepositorySource {
        private ModLoadedPackFinder() {
        }

        public void m_7686_(Consumer<Pack> packLoader, Pack.PackConstructor packBuilder) {
            IModFileInfo modFile = ((ModContainer)ModList.get().getModContainerById(DyenamicsAndFriends.MODID).get()).getModInfo().getOwningFile();
            for (String modId : DyenamicRegistry.MODS) {
                try {
                    if (!ModList.get().isLoaded(modId)) continue;
                    packLoader.accept(Pack.m_10430_((String)("dyenamicsandfriends:compat_" + modId), (boolean)false, () -> new PathResourcePack("dyenamicsandfriends:compat_" + modId, modFile.getFile().findResource(new String[]{"compat_packs/" + modId + "/"})), (Pack.PackConstructor)packBuilder, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10528_));
                }
                catch (Exception e) {
                    LOGGER.debug("Failed to load compat pack: " + modId);
                }
            }
        }
    }
}

