/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamicsandfriends.client.render.farmersdelight;

import cofh.dyenamics.core.util.DyenamicDyeColor;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import cy.jdkdigital.dyenamicsandfriends.common.block.entity.farmersdelight.DyenamicsCanvasSignBlockEntity;
import cy.jdkdigital.dyenamicsandfriends.common.block.farmersdelight.DyenamicsStandingCanvasSignBlock;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;
import vectorwing.farmersdelight.client.renderer.CanvasSignRenderer;
import vectorwing.farmersdelight.common.registry.ModAtlases;

public class DyenamicsCanvasSignRenderer
extends CanvasSignRenderer {
    public static final float TEXT_LINE_HEIGHT = 10.0f;
    public static final float TEXT_VERTICAL_OFFSET = 19.0f;
    private static final int OUTLINE_RENDER_DISTANCE = Mth.m_144944_((int)16);
    public static final Map<DyenamicDyeColor, Material> DYED_CANVAS_SIGN_MATERIALS = Arrays.stream(DyenamicDyeColor.values()).collect(Collectors.toMap(Function.identity(), DyenamicsCanvasSignRenderer::getSignMaterial));
    private final SignRenderer.SignModel signModel;
    private final Font font;

    public DyenamicsCanvasSignRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        this.signModel = new SignRenderer.SignModel(context.m_173582_(ModelLayers.m_171291_((WoodType)WoodType.f_61831_)));
        this.font = context.m_173586_();
    }

    public void m_6922_(SignBlockEntity blockEntityIn, float pPartialTick, PoseStack poseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        if (blockEntityIn instanceof DyenamicsCanvasSignBlockEntity) {
            int light;
            boolean hasOutline;
            int baseColor;
            int darkColor;
            DyenamicsCanvasSignBlockEntity blockEntity = (DyenamicsCanvasSignBlockEntity)blockEntityIn;
            BlockState state = blockEntity.m_58900_();
            poseStack.m_85836_();
            SignRenderer.SignModel signModel = this.signModel;
            if (state.m_60734_() instanceof DyenamicsStandingCanvasSignBlock) {
                poseStack.m_85837_(0.5, 0.5, 0.5);
                float f1 = -((float)((Integer)state.m_61143_((Property)StandingSignBlock.f_56987_) * 360) / 16.0f);
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(f1));
                signModel.f_112507_.f_104207_ = true;
            } else {
                poseStack.m_85837_(0.5, 0.5, 0.5);
                float f4 = -((Direction)state.m_61143_((Property)WallSignBlock.f_58064_)).m_122435_();
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(f4));
                poseStack.m_85837_(0.0, -0.3125, -0.4375);
                signModel.f_112507_.f_104207_ = false;
            }
            poseStack.m_85836_();
            float rootScale = 0.6666667f;
            poseStack.m_85841_(rootScale, -rootScale, -rootScale);
            Material material = DyenamicsCanvasSignRenderer.getMaterial(blockEntity.getDyenamicsColor());
            VertexConsumer vertexconsumer = material.m_119194_(pBufferSource, arg_0 -> ((SignRenderer.SignModel)signModel).m_103119_(arg_0));
            signModel.f_173655_.m_104301_(poseStack, vertexconsumer, pPackedLight, pPackedOverlay);
            poseStack.m_85849_();
            float textScale = 0.010416667f;
            poseStack.m_85837_(0.0, 0.3333333432674408, 0.046666666865348816);
            poseStack.m_85841_(textScale, -textScale, textScale);
            FormattedCharSequence[] aformattedcharsequence = blockEntity.m_155717_(Minecraft.m_91087_().m_167974_(), component -> {
                List list = this.font.m_92923_((FormattedText)component, 90);
                return list.isEmpty() ? FormattedCharSequence.f_13691_ : (FormattedCharSequence)list.get(0);
            });
            if (blockEntity.m_155727_()) {
                darkColor = DyenamicsCanvasSignRenderer.getDarkColor(blockEntity, true);
                baseColor = blockEntity.getTextColor().getTextColor();
                hasOutline = DyenamicsCanvasSignRenderer.isOutlineVisible(blockEntity, baseColor);
                light = 0xF000F0;
            } else {
                baseColor = darkColor = DyenamicsCanvasSignRenderer.getDarkColor(blockEntity, false);
                hasOutline = false;
                light = pPackedLight;
            }
            for (int i1 = 0; i1 < 4; ++i1) {
                FormattedCharSequence formattedcharsequence = aformattedcharsequence[i1];
                float x = -this.font.m_92724_(formattedcharsequence) / 2;
                float y = (float)i1 * 10.0f - 19.0f;
                if (hasOutline) {
                    this.font.m_168645_(formattedcharsequence, x, y, baseColor, darkColor, poseStack.m_85850_().m_85861_(), pBufferSource, light);
                    continue;
                }
                this.font.m_92733_(formattedcharsequence, x, y, baseColor, false, poseStack.m_85850_().m_85861_(), pBufferSource, false, 0, light);
            }
            poseStack.m_85849_();
        }
    }

    private static boolean isOutlineVisible(DyenamicsCanvasSignBlockEntity blockEntity, int textColor) {
        if (textColor == DyeColor.BLACK.m_41071_()) {
            return true;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer localPlayer = minecraft.f_91074_;
        if (localPlayer != null && minecraft.f_91066_.m_92176_().m_90612_() && localPlayer.m_150108_()) {
            return true;
        }
        Entity entity = minecraft.m_91288_();
        return entity != null && entity.m_20238_(Vec3.m_82512_((Vec3i)blockEntity.m_58899_())) < (double)OUTLINE_RENDER_DISTANCE;
    }

    private static int getDarkColor(DyenamicsCanvasSignBlockEntity blockEntity, boolean isOutlineVisible) {
        int textColor = blockEntity.getTextColor().getTextColor();
        double brightness = isOutlineVisible ? 0.4 : 0.6;
        int red = (int)((double)NativeImage.m_85085_((int)textColor) * brightness);
        int green = (int)((double)NativeImage.m_85103_((int)textColor) * brightness);
        int blue = (int)((double)NativeImage.m_85119_((int)textColor) * brightness);
        return textColor == DyeColor.BLACK.m_41071_() && blockEntity.m_155727_() ? -988212 : NativeImage.m_84992_((int)0, (int)blue, (int)green, (int)red);
    }

    public static Material getMaterial(@Nullable DyenamicDyeColor dyeColor) {
        return dyeColor != null ? DYED_CANVAS_SIGN_MATERIALS.get(dyeColor) : ModAtlases.BLANK_CANVAS_SIGN_MATERIAL;
    }

    private static Material getSignMaterial(DyenamicDyeColor dyeType) {
        return new Material(Sheets.f_110739_, new ResourceLocation("dyenamicsandfriends", "entity/farmersdelight/canvas_" + dyeType.m_7912_()));
    }
}

