/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamicsandfriends.common.block.chalk;

import cofh.dyenamics.core.util.DyenamicDyeColor;
import cy.jdkdigital.dyenamicsandfriends.compat.ChalkCompat;
import io.github.mortuusars.chalk.blocks.ChalkMarkBlock;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.HitResult;

public class DyenamicsChalkMarkBlock
extends ChalkMarkBlock {
    private final DyenamicDyeColor color;

    public DyenamicsChalkMarkBlock(DyenamicDyeColor dyeColor, BlockBehaviour.Properties properties) {
        super(dyeColor.getAnalogue(), properties);
        this.color = dyeColor;
    }

    public DyenamicDyeColor getDyenamicColor() {
        return this.color;
    }

    public MutableComponent m_49954_() {
        return super.m_49954_();
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState blockState) {
        return new ItemStack((ItemLike)ChalkCompat.CHALKS.get(this.color).get());
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        if (player.m_7500_()) {
            return new ItemStack((ItemLike)ChalkCompat.CHALKS.get(this.color).get());
        }
        ItemStack item = this.getMatchingItemStack(player, (Item)ChalkCompat.CHALKS.get(this.color).get());
        return item == ItemStack.f_41583_ ? new ItemStack((ItemLike)ChalkCompat.CHALKS.get(this.color).get()) : item;
    }

    private ItemStack getMatchingItemStack(Player player, Item item) {
        return player.m_150109_().f_35974_.stream().filter(invItem -> invItem.m_41720_().getRegistryName() == item.getRegistryName()).findFirst().orElse(ItemStack.f_41583_);
    }

    public void m_6256_(BlockState blockState, Level world, BlockPos pos, Player player) {
        this.removeMark(world, pos, false);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        BlockPos relative = pos.m_142300_(((Direction)state.m_61143_((Property)FACING)).m_122424_());
        if (relative.equals((Object)fromPos)) {
            this.removeMark(world, pos, isMoving);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        return this.removeMark(world, pos, false);
    }

    private boolean removeMark(Level level, BlockPos pos, boolean isMoving) {
        Direction facing = (Direction)level.m_8055_(pos).m_61143_((Property)FACING);
        if (level.m_7471_(pos, isMoving)) {
            if (!level.m_5776_()) {
                level.m_5594_(null, pos, SoundEvents.f_12196_, SoundSource.BLOCKS, 0.5f, new Random().nextFloat() * 0.2f + 0.8f);
            } else {
                ChalkCompat.spawnColorDustParticles(this.color, level, pos, facing);
            }
            return true;
        }
        return false;
    }
}

