/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamicsandfriends.common.block.elevatorid;

import cofh.dyenamics.core.util.DyenamicDyeColor;
import cy.jdkdigital.dyenamicsandfriends.common.block.entity.elevatorid.DyenamicsElevatorBlockEntity;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import xyz.vsngamer.elevatorid.blocks.ElevatorBlock;
import xyz.vsngamer.elevatorid.tile.ElevatorTileEntity;
import xyz.vsngamer.elevatorid.util.FakeUseContext;

public class DyenamicsElevatorBlock
extends ElevatorBlock {
    private final DyenamicDyeColor color;
    private final Supplier<BlockEntityType<ElevatorTileEntity>> blockEntitySupplier;

    public DyenamicsElevatorBlock(DyenamicDyeColor color, Supplier<BlockEntityType<ElevatorTileEntity>> blockEntitySupplier) {
        super(DyeColor.WHITE);
        this.color = color;
        this.blockEntitySupplier = blockEntitySupplier;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DyenamicsElevatorBlockEntity(this, pos, state);
    }

    public Supplier<BlockEntityType<ElevatorTileEntity>> getBlockEntitySupplier() {
        return this.blockEntitySupplier;
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return this.color.getLightValue();
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level worldIn, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand handIn, @Nonnull BlockHitResult hit) {
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack handStack = player.m_21120_(handIn);
        DyenamicsElevatorBlockEntity tile = this.getElevatorTile((BlockGetter)worldIn, pos);
        if (tile == null) {
            return InteractionResult.FAIL;
        }
        Block handBlock = Block.m_49814_((Item)handStack.m_41720_());
        BlockState stateToApply = handBlock.m_5573_((BlockPlaceContext)new FakeUseContext(player, handIn, hit));
        if (tile.setCamoAndUpdate(stateToApply)) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_6047_() && tile.getHeldState() != null) {
            tile.setCamoAndUpdate(null);
            return InteractionResult.SUCCESS;
        }
        NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)tile, (BlockPos)pos);
        return InteractionResult.SUCCESS;
    }

    private DyenamicsElevatorBlockEntity getElevatorTile(BlockGetter world, BlockPos pos) {
        BlockEntity tile;
        if (world != null && pos != null && (tile = world.m_7702_(pos)) instanceof DyenamicsElevatorBlockEntity && tile.m_58903_().m_155262_(world.m_8055_(pos))) {
            return (DyenamicsElevatorBlockEntity)tile;
        }
        return null;
    }
}

