/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamicsandfriends.common.block.entity.supplementaries;

import cofh.dyenamics.core.util.DyenamicDyeColor;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.dyenamicsandfriends.common.block.supplementaries.DyenamicsFlagBlock;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.supplementaries.common.block.tiles.FlagBlockTile;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class DyenamicsFlagBlockEntity
extends FlagBlockTile {
    private final DyenamicsFlagBlock block;
    private List<Pair<BannerPattern, DyenamicDyeColor>> patterns;

    public DyenamicsFlagBlockEntity(DyenamicsFlagBlock block, BlockPos pos, BlockState state) {
        super(pos, state);
        this.block = block;
    }

    public BlockEntityType<?> m_58903_() {
        return this.block != null ? this.block.getBlockEntitySupplier().get() : null;
    }

    public List<Pair<BannerPattern, DyenamicDyeColor>> getDyenamicsPatterns() {
        if (this.patterns == null) {
            List dyeColorPatterns = super.getPatterns();
            dyeColorPatterns.removeIf(pattern -> ((BannerPattern)pattern.getFirst()).equals((Object)BannerPattern.BASE));
            List<BannerPattern> itemPatterns = dyeColorPatterns.stream().map(Pair::getFirst).distinct().toList();
            this.patterns = DyenamicsFlagBlockEntity.createPatterns(this.block.getDyenamicsColor(), itemPatterns);
        }
        return this.patterns;
    }

    public static List<Pair<BannerPattern, DyenamicDyeColor>> createPatterns(DyenamicDyeColor pColor, ListTag patterns) {
        ArrayList list = Lists.newArrayList();
        if (patterns != null) {
            for (int i = 0; i < patterns.size(); ++i) {
                CompoundTag compoundtag = patterns.m_128728_(i);
                BannerPattern bannerPattern = BannerPattern.m_58575_((String)compoundtag.m_128461_("Pattern"));
                if (bannerPattern == null) continue;
                list.add(bannerPattern);
            }
        }
        return DyenamicsFlagBlockEntity.createPatterns(pColor, list);
    }

    public static List<Pair<BannerPattern, DyenamicDyeColor>> createPatterns(DyenamicDyeColor pColor, List<BannerPattern> patterns) {
        ArrayList list = Lists.newArrayList();
        list.add(Pair.of((Object)BannerPattern.BASE, (Object)pColor));
        if (patterns.size() > 0) {
            for (BannerPattern bannerPattern : patterns) {
                if (bannerPattern == null) continue;
                list.add(Pair.of((Object)bannerPattern, (Object)pColor));
            }
        }
        return list;
    }
}

