/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamicsandfriends.common.item.chalk;

import cofh.dyenamics.core.util.DyenamicDyeColor;
import cy.jdkdigital.dyenamicsandfriends.compat.ChalkCompat;
import io.github.mortuusars.chalk.blocks.MarkSymbol;
import io.github.mortuusars.chalk.items.ChalkItem;
import io.github.mortuusars.chalk.setup.ModTags;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class DyenamicsChalkItem
extends ChalkItem {
    private final DyenamicDyeColor color;

    public DyenamicsChalkItem(DyenamicDyeColor dyeColor, Item.Properties properties) {
        super(dyeColor.getAnalogue(), properties);
        this.color = dyeColor;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        InteractionHand hand = context.m_43724_();
        ItemStack itemStack = context.m_43722_();
        Player player = context.m_43723_();
        if (player != null && itemStack.m_41720_() instanceof DyenamicsChalkItem) {
            if (hand == InteractionHand.OFF_HAND && player.m_21205_().m_41720_() instanceof DyenamicsChalkItem) {
                return InteractionResult.FAIL;
            }
            Level level = context.m_43725_();
            boolean isGlowingDye = ((DyenamicsChalkItem)itemStack.m_41720_()).color.equals((Object)DyenamicDyeColor.FLUORESCENT);
            boolean isGlowingOffhandItem = player.m_21206_().m_204117_(ModTags.Items.GLOWING);
            MarkSymbol symbol = context.m_7078_() ? MarkSymbol.CROSS : MarkSymbol.NONE;
            if (ChalkCompat.draw(symbol, this.color, isGlowingOffhandItem || isGlowingDye, context.m_8083_(), context.m_43719_(), context.m_43720_(), level) == InteractionResult.SUCCESS) {
                if (!player.m_7500_()) {
                    this.damageAndConsumeItems(hand, itemStack, player, level, isGlowingOffhandItem);
                }
                return InteractionResult.m_19078_((boolean)context.m_43725_().f_46443_);
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.FAIL;
    }

    private void damageAndConsumeItems(InteractionHand hand, ItemStack itemStack, Player player, Level level, boolean isGlowing) {
        itemStack.m_41721_(itemStack.m_41773_() + 1);
        if (itemStack.m_41773_() >= itemStack.m_41776_()) {
            player.m_21008_(hand, ItemStack.f_41583_);
            Vec3 playerPos = player.m_20182_();
            level.m_6263_(player, playerPos.f_82479_, playerPos.f_82480_, playerPos.f_82481_, SoundEvents.f_11993_, SoundSource.BLOCKS, 0.9f, 0.9f + level.f_46441_.nextFloat() * 0.2f);
        }
        if (isGlowing) {
            player.m_21206_().m_41774_(1);
        }
    }

    public DyenamicDyeColor getDyenamicsColor() {
        return this.color;
    }
}

