/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamicsandfriends.compat;

import cofh.dyenamics.core.util.DyenamicDyeColor;
import cy.jdkdigital.dyenamicsandfriends.common.block.ceramics.DyenamicsFluidCisternBlock;
import cy.jdkdigital.dyenamicsandfriends.common.block.entity.ceramics.DyenamicsCisternBlockEntity;
import cy.jdkdigital.dyenamicsandfriends.registry.DyenamicRegistry;
import java.util.HashMap;
import java.util.Map;
import knightminer.ceramics.client.renderer.CisternBlockEntityRenderer;
import knightminer.ceramics.items.CrackableBlockItem;
import knightminer.ceramics.items.FixedTooltipBlockItem;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.registries.RegistryObject;

public class CeramicsCompat {
    public static Map<DyenamicDyeColor, RegistryObject<? extends Block>> PORCELAIN_BLOCKS = new HashMap<DyenamicDyeColor, RegistryObject<? extends Block>>();
    public static Map<DyenamicDyeColor, RegistryObject<? extends Block>> PORCELAIN_CISTERNS = new HashMap<DyenamicDyeColor, RegistryObject<? extends Block>>();
    public static Map<DyenamicDyeColor, RegistryObject<? extends Block>> COLORED_CISTERNS = new HashMap<DyenamicDyeColor, RegistryObject<? extends Block>>();

    public static void registerBlocks(DyenamicDyeColor color) {
        String prefix = "ceramics_" + color.m_7912_();
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)color.getMapColor()).m_60913_(1.25f, 4.2f).m_60955_().m_60953_(state -> color.getLightValue());
        PORCELAIN_BLOCKS.put(color, DyenamicRegistry.registerBlock(prefix + "_porcelain", () -> new Block(properties), () -> new BlockItem((Block)PORCELAIN_BLOCKS.get(color).get(), new Item.Properties().m_41491_(CreativeModeTab.f_40750_))));
        COLORED_CISTERNS.put(color, DyenamicRegistry.registerBlock(prefix + "_terracotta_cistern", () -> new DyenamicsFluidCisternBlock(properties.m_60955_().m_60977_(), true, DyenamicRegistry.registerBlockEntity(prefix + "_terracotta_cistern", () -> DyenamicRegistry.createBlockEntityType((pos, state) -> new DyenamicsCisternBlockEntity((DyenamicsFluidCisternBlock)((Object)((Object)((Object)((Object)COLORED_CISTERNS.get(color).get())))), pos, state, true), (Block)COLORED_CISTERNS.get(color).get()))), () -> new CrackableBlockItem((Block)COLORED_CISTERNS.get(color).get(), new Item.Properties().m_41491_(CreativeModeTab.f_40750_), "terracotta_cistern.tooltip")));
        PORCELAIN_CISTERNS.put(color, DyenamicRegistry.registerBlock(prefix + "_porcelain_cistern", () -> new DyenamicsFluidCisternBlock(properties.m_60955_(), false, DyenamicRegistry.registerBlockEntity(prefix + "_porcelain_cistern", () -> DyenamicRegistry.createBlockEntityType((pos, state) -> new DyenamicsCisternBlockEntity((DyenamicsFluidCisternBlock)((Object)((Object)((Object)((Object)PORCELAIN_CISTERNS.get(color).get())))), pos, state, false), (Block)PORCELAIN_CISTERNS.get(color).get()))), () -> new FixedTooltipBlockItem((Block)PORCELAIN_CISTERNS.get(color).get(), new Item.Properties().m_41491_(CreativeModeTab.f_40750_), "porcelain_cistern.tooltip")));
    }

    public static class Client {
        public static void registerBlockRendering() {
            COLORED_CISTERNS.values().forEach(cistern -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)cistern.get()), (RenderType)RenderType.m_110463_()));
        }

        public static void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            COLORED_CISTERNS.values().forEach(registryObject -> {
                Object patt3759$temp = registryObject.get();
                if (patt3759$temp instanceof DyenamicsFluidCisternBlock) {
                    DyenamicsFluidCisternBlock cistern = (DyenamicsFluidCisternBlock)((Object)((Object)patt3759$temp));
                    event.registerBlockEntityRenderer(cistern.getBlockEntitySupplier().get(), CisternBlockEntityRenderer::new);
                }
            });
            PORCELAIN_CISTERNS.values().forEach(registryObject -> {
                Object patt4084$temp = registryObject.get();
                if (patt4084$temp instanceof DyenamicsFluidCisternBlock) {
                    DyenamicsFluidCisternBlock cistern = (DyenamicsFluidCisternBlock)((Object)((Object)patt4084$temp));
                    event.registerBlockEntityRenderer(cistern.getBlockEntitySupplier().get(), CisternBlockEntityRenderer::new);
                }
            });
        }
    }
}

