/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamicsandfriends.compat;

import cofh.dyenamics.core.util.DyenamicDyeColor;
import com.mojang.math.Vector3f;
import cy.jdkdigital.dyenamicsandfriends.common.block.chalk.DyenamicsChalkMarkBlock;
import cy.jdkdigital.dyenamicsandfriends.common.item.chalk.DyenamicsChalkBoxItem;
import cy.jdkdigital.dyenamicsandfriends.common.item.chalk.DyenamicsChalkItem;
import cy.jdkdigital.dyenamicsandfriends.registry.DyenamicRegistry;
import io.github.mortuusars.chalk.Chalk;
import io.github.mortuusars.chalk.blocks.ChalkMarkBlock;
import io.github.mortuusars.chalk.blocks.MarkSymbol;
import io.github.mortuusars.chalk.core.ChalkMark;
import io.github.mortuusars.chalk.render.ChalkMarkBakedModel;
import io.github.mortuusars.chalk.setup.ClientSetup;
import io.github.mortuusars.chalk.setup.ModTags;
import io.github.mortuusars.chalk.utils.ClickLocationUtils;
import io.github.mortuusars.chalk.utils.ParticleUtils;
import io.github.mortuusars.chalk.utils.PositionUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.RegistryObject;

public class ChalkCompat {
    private static final Map<DyenamicDyeColor, RegistryObject<? extends Block>> CHALK_MARK_BLOCKS = new HashMap<DyenamicDyeColor, RegistryObject<? extends Block>>();
    public static final Map<DyenamicDyeColor, RegistryObject<? extends Item>> CHALKS = new HashMap<DyenamicDyeColor, RegistryObject<? extends Item>>();
    public static RegistryObject<? extends Item> CHALK_BOX = null;

    public static void registerBlocks(DyenamicDyeColor color) {
        String prefix = "chalk_" + color.m_7912_();
        CHALK_MARK_BLOCKS.put(color, DyenamicRegistry.registerBlock(prefix + "_chalk_mark", () -> new DyenamicsChalkMarkBlock(color, BlockBehaviour.Properties.m_60944_((Material)Material.f_76303_, (MaterialColor)color.getMapColor()).m_60966_().m_60955_().m_60910_().m_60918_(SoundType.f_56739_).m_60953_(state -> color.getLightValue())), null, false));
    }

    public static void registerItems(DyenamicDyeColor color) {
        String prefix = "chalk_" + color.m_7912_();
        CHALKS.put(color, DyenamicRegistry.registerItem(prefix + "_chalk", () -> new DyenamicsChalkItem(color, new Item.Properties())));
        if (color.equals((Object)DyenamicDyeColor.PEACH)) {
            CHALK_BOX = DyenamicRegistry.registerItem("chalk_box", () -> new DyenamicsChalkBoxItem(new Item.Properties().m_41491_(CreativeModeTab.f_40756_).m_41487_(1)));
        }
    }

    public static InteractionResult draw(MarkSymbol symbol, DyenamicDyeColor color, boolean isGlowing, BlockPos clickedPos, Direction clickedFace, Vec3 clickLocation, Level level) {
        if (!ChalkMark.canBeDrawnAt((BlockPos)clickedPos.m_142300_(clickedFace), (BlockPos)clickedPos, (Direction)clickedFace, (Level)level)) {
            Chalk.LOGGER.info("Chalk cannot be drawn at this position. ({}, {}, {})", (Object)clickedPos.m_123341_(), (Object)clickedPos.m_123342_(), (Object)clickedPos.m_123343_());
            return InteractionResult.FAIL;
        }
        boolean isClickedOnAMark = level.m_8055_(clickedPos).m_204336_(ModTags.Blocks.CHALK_MARK);
        BlockPos newMarkPosition = isClickedOnAMark ? clickedPos : clickedPos.m_142300_(clickedFace);
        Direction newMarkFacing = isClickedOnAMark ? (Direction)level.m_8055_(newMarkPosition).m_61143_((Property)ChalkMarkBlock.FACING) : clickedFace;
        BlockState markBlockState = ChalkCompat.createMarkBlockState(symbol, color, newMarkFacing, clickLocation, clickedPos, isGlowing);
        if (isClickedOnAMark) {
            BlockState oldMarkBlockState = level.m_8055_(newMarkPosition);
            if (((Integer)markBlockState.m_61143_((Property)ChalkMarkBlock.ORIENTATION)).equals(oldMarkBlockState.m_61143_((Property)ChalkMarkBlock.ORIENTATION)) && newMarkFacing == oldMarkBlockState.m_61143_((Property)ChalkMarkBlock.FACING) && symbol == oldMarkBlockState.m_61143_((Property)ChalkMarkBlock.SYMBOL) && (!isGlowing || ((Boolean)oldMarkBlockState.m_61143_((Property)ChalkMarkBlock.GLOWING)).booleanValue())) {
                return InteractionResult.FAIL;
            }
            level.m_7471_(newMarkPosition, false);
        }
        ChalkCompat.drawMark(markBlockState, newMarkPosition, level);
        return InteractionResult.SUCCESS;
    }

    private static BlockState createMarkBlockState(MarkSymbol symbol, DyenamicDyeColor color, Direction clickedFace, Vec3 clickLocation, BlockPos clickedPos, boolean isGlowing) {
        BlockState newBlockState = (BlockState)((BlockState)((BlockState)((Block)CHALK_MARK_BLOCKS.get(color).get()).m_49966_().m_61124_((Property)ChalkMarkBlock.FACING, (Comparable)clickedFace)).m_61124_((Property)ChalkMarkBlock.SYMBOL, (Comparable)symbol)).m_61124_((Property)ChalkMarkBlock.GLOWING, (Comparable)Boolean.valueOf(isGlowing));
        if (symbol == MarkSymbol.NONE) {
            newBlockState = (BlockState)newBlockState.m_61124_((Property)ChalkMarkBlock.ORIENTATION, (Comparable)Integer.valueOf(ClickLocationUtils.getBlockRegion((Vec3)clickLocation, (BlockPos)clickedPos, (Direction)clickedFace)));
        }
        return newBlockState;
    }

    private static boolean drawMark(BlockState markState, BlockPos markPos, Level level) {
        boolean isMarkDrawn = level.m_7731_(markPos, markState, 11);
        if (isMarkDrawn) {
            Block block;
            double pX = (double)markPos.m_123341_() + 0.5;
            double pY = (double)markPos.m_123342_() + 0.5;
            double pZ = (double)markPos.m_123343_() + 0.5;
            level.m_6263_(null, pX, pY, pZ, SoundEvents.f_12493_, SoundSource.BLOCKS, 0.7f, new Random().nextFloat() * 0.2f + 0.8f);
            if (level.f_46443_ && (block = markState.m_60734_()) instanceof DyenamicsChalkMarkBlock) {
                DyenamicsChalkMarkBlock markBlock = (DyenamicsChalkMarkBlock)block;
                ChalkCompat.spawnColorDustParticles(markBlock.getDyenamicColor(), level, markPos, (Direction)markState.m_61143_((Property)ChalkMarkBlock.FACING));
            }
        }
        return isMarkDrawn;
    }

    public static void spawnColorDustParticles(DyenamicDyeColor color, Level level, BlockPos pos, Direction face) {
        int colorValue = color.getColorValue();
        float R = (colorValue & 0xFF0000) >> 16;
        float G = (colorValue & 0xFF00) >> 8;
        float B = colorValue & 0xFF;
        ParticleUtils.spawnParticle((Level)level, (ParticleOptions)new DustParticleOptions(new Vector3f(R / 255.0f, G / 255.0f, B / 255.0f), 2.0f), (Vector3f)PositionUtils.blockCenterOffsetToFace((BlockPos)pos, (Direction)face, (float)0.25f), (int)1);
    }

    public static class Client {
        public static final BlockColor CHALK_MARK_BLOCK_COLOR = (blockState, blockAndTintGetter, blockPos, index) -> {
            if (!(blockState.m_60734_() instanceof DyenamicsChalkMarkBlock)) {
                return 0xFFFFFF;
            }
            DyenamicDyeColor blockColor = ((DyenamicsChalkMarkBlock)blockState.m_60734_()).getDyenamicColor();
            return blockColor.getColorValue();
        };

        public static void registerBlockRendering(FMLClientSetupEvent event) {
            Minecraft.m_91087_().m_91298_().m_92589_(CHALK_MARK_BLOCK_COLOR, (Block[])CHALK_MARK_BLOCKS.values().stream().map(RegistryObject::get).toArray(Block[]::new));
            CHALK_MARK_BLOCKS.values().forEach(registryObject -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.m_110463_()));
            DyenamicsChalkBoxItem chalkBox = (DyenamicsChalkBoxItem)((Object)CHALK_BOX.get());
            ItemProperties.register((Item)chalkBox, (ResourceLocation)ClientSetup.CHALK_BOX_SELECTED_PROPERTY, (stack, level, entity, damage) -> chalkBox.getSelectedChalkColor(stack));
        }

        public static void bakeModel(ModelBakeEvent event) {
            CHALK_MARK_BLOCKS.forEach((color, block) -> {
                for (BlockState blockState : ((Block)block.get()).m_49965_().m_61056_()) {
                    ModelResourceLocation variantMRL = BlockModelShaper.m_110895_((BlockState)blockState);
                    BakedModel existingModel = (BakedModel)event.getModelRegistry().get(variantMRL);
                    if (existingModel == null) {
                        Chalk.LOGGER.warn("Did not find the expected vanilla baked model(s) for " + block + " in registry");
                        continue;
                    }
                    if (existingModel instanceof ChalkMarkBakedModel) {
                        Chalk.LOGGER.warn("Tried to replace " + block + " twice");
                        continue;
                    }
                    ChalkMarkBakedModel customModel = new ChalkMarkBakedModel(existingModel);
                    event.getModelRegistry().put(variantMRL, customModel);
                }
            });
        }
    }
}

