/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamicsandfriends.compat;

import cofh.dyenamics.common.blocks.DyenamicStainedGlassBlock;
import cofh.dyenamics.common.blocks.DyenamicStainedGlassPane;
import cofh.dyenamics.core.util.DyenamicDyeColor;
import cy.jdkdigital.dyenamicsandfriends.DyenamicsAndFriends;
import cy.jdkdigital.dyenamicsandfriends.loot.modifier.StainedGlassBlockLootModifier;
import cy.jdkdigital.dyenamicsandfriends.registry.DyenamicRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.registries.RegistryObject;

public class QuarkCompat {
    private static final Map<DyenamicDyeColor, RegistryObject<? extends Block>> FRAMED_GLASS = new HashMap<DyenamicDyeColor, RegistryObject<? extends Block>>();
    private static final Map<DyenamicDyeColor, RegistryObject<? extends Block>> FRAMED_GLASS_PANES = new HashMap<DyenamicDyeColor, RegistryObject<? extends Block>>();

    public static void setup() {
        DyenamicsAndFriends.LOOT_SERIALIZERS.register("shard", StainedGlassBlockLootModifier.Serializer::new);
    }

    public static void registerBlocks(DyenamicDyeColor color) {
        String prefix = "quark_" + color.m_7912_();
        FRAMED_GLASS.put(color, DyenamicRegistry.registerBlock(prefix + "_framed_glass", () -> new DyenamicStainedGlassBlock(color, BlockBehaviour.Properties.m_60944_((Material)Material.f_76275_, (MaterialColor)color.getMapColor()).m_60978_(0.3f).m_60918_(SoundType.f_56744_).m_60955_().m_60922_((a, b, c, d) -> false).m_60924_((a, b, c) -> false).m_60960_((a, b, c) -> false).m_60971_((a, b, c) -> false).m_60953_(state -> color.getLightValue())), CreativeModeTab.f_40749_, true));
        FRAMED_GLASS_PANES.put(color, DyenamicRegistry.registerBlock(prefix + "_framed_glass_pane", () -> new DyenamicStainedGlassPane(color, BlockBehaviour.Properties.m_60944_((Material)Material.f_76275_, (MaterialColor)color.getMapColor()).m_60978_(0.3f).m_60918_(SoundType.f_56744_).m_60955_().m_60922_((a, b, c, d) -> false).m_60924_((a, b, c) -> false).m_60960_((a, b, c) -> false).m_60971_((a, b, c) -> false).m_60953_(state -> color.getLightValue())), CreativeModeTab.f_40749_, true));
        BlockBehaviour.Properties props = BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)color.getMapColor()).m_60913_(1.25f, 4.2f).m_60953_(state -> color.getLightValue());
        RegistryObject<? extends Block> shingles = DyenamicRegistry.registerBlock(prefix + "_shingles", () -> new Block(props), CreativeModeTab.f_40749_, true);
        DyenamicRegistry.registerBlock(prefix + "_shingles_stairs", () -> new StairBlock(() -> ((Block)shingles.get()).m_49966_(), props), CreativeModeTab.f_40749_, true);
        DyenamicRegistry.registerBlock(prefix + "_shingles_slab", () -> new SlabBlock(props), CreativeModeTab.f_40749_, true);
    }

    public static void registerItems(DyenamicDyeColor color) {
        String prefix = "quark_" + color.m_7912_();
        DyenamicRegistry.registerItem(prefix + "_shard", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
    }

    public static class Client {
        public static void registerBlockRendering() {
            FRAMED_GLASS.values().forEach(registryObject -> {
                Object patt3724$temp = registryObject.get();
                if (patt3724$temp instanceof DyenamicStainedGlassBlock) {
                    DyenamicStainedGlassBlock glass = (DyenamicStainedGlassBlock)patt3724$temp;
                    ItemBlockRenderTypes.setRenderLayer((Block)glass, (RenderType)RenderType.m_110466_());
                }
            });
            FRAMED_GLASS_PANES.values().forEach(registryObject -> {
                Object patt4008$temp = registryObject.get();
                if (patt4008$temp instanceof DyenamicStainedGlassPane) {
                    DyenamicStainedGlassPane pane = (DyenamicStainedGlassPane)patt4008$temp;
                    ItemBlockRenderTypes.setRenderLayer((Block)pane, (RenderType)RenderType.m_110466_());
                }
            });
        }
    }
}

