/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamicsandfriends.registry;

import cofh.dyenamics.core.init.BlockInit;
import cofh.dyenamics.core.util.DyenamicDyeColor;
import cy.jdkdigital.dyenamicsandfriends.DyenamicsAndFriends;
import cy.jdkdigital.dyenamicsandfriends.compat.AnotherFurnitureCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.BotanyPotsCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.CeramicsCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.ChalkCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.ClayworksCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.ComfortsCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.CreateCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.ElevatoridCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.FarmersDelightCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.FurnishCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.OreganizedCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.QuarkCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.RegionsUnexploredCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.SupplementariesCompat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.RegistryObject;

public class DyenamicRegistry {
    public static final List<String> MODS = new ArrayList<String>(){
        {
            this.add("another_furniture");
            this.add("botanypots");
            this.add("ceramics");
            this.add("chalk");
            this.add("clayworks");
            this.add("comforts");
            this.add("create");
            this.add("elevatorid");
            this.add("farmersdelight");
            this.add("furnish");
            this.add("oreganized");
            this.add("quark");
            this.add("regions_unexplored");
            this.add("supplementaries");
        }
    };

    public static void setup() {
        QuarkCompat.setup();
    }

    public static void registerCompatBlocks() {
        for (DyenamicDyeColor color : DyenamicDyeColor.dyenamicValues()) {
            if (ModList.get().isLoaded("create")) {
                CreateCompat.registerBlocks(color);
            }
            if (ModList.get().isLoaded("createdeco")) {
                // empty if block
            }
            if (ModList.get().isLoaded("another_furniture")) {
                AnotherFurnitureCompat.registerBlocks(color);
            }
            if (ModList.get().isLoaded("botanypots")) {
                BotanyPotsCompat.registerBlocks(color);
            }
            if (ModList.get().isLoaded("comforts")) {
                ComfortsCompat.registerBlocks(color);
            }
            if (ModList.get().isLoaded("elevatorid")) {
                ElevatoridCompat.registerBlocks(color);
            }
            if (ModList.get().isLoaded("farmersdelight")) {
                FarmersDelightCompat.registerBlocks(color);
            }
            if (ModList.get().isLoaded("reliquary")) {
                // empty if block
            }
            if (ModList.get().isLoaded("snowyspirit")) {
                // empty if block
            }
            if (ModList.get().isLoaded("supplementaries")) {
                SupplementariesCompat.registerBlocks(color);
            }
            if (ModList.get().isLoaded("regions_unexplored")) {
                RegionsUnexploredCompat.registerBlocks(color);
            }
            if (ModList.get().isLoaded("waystones")) {
                // empty if block
            }
            if (ModList.get().isLoaded("quark")) {
                QuarkCompat.registerBlocks(color);
                QuarkCompat.registerItems(color);
            }
            if (ModList.get().isLoaded("furnish")) {
                FurnishCompat.registerBlocks(color);
            }
            if (ModList.get().isLoaded("skinnedlanterns")) {
                // empty if block
            }
            if (ModList.get().isLoaded("nightlights")) {
                // empty if block
            }
            if (ModList.get().isLoaded("cfm")) {
                // empty if block
            }
            if (ModList.get().isLoaded("chalk")) {
                ChalkCompat.registerBlocks(color);
                ChalkCompat.registerItems(color);
            }
            if (ModList.get().isLoaded("oreganized")) {
                OreganizedCompat.registerBlocks(color);
            }
            if (ModList.get().isLoaded("ceramics")) {
                CeramicsCompat.registerBlocks(color);
            }
            if (ModList.get().isLoaded("glazedresymmetry")) {
                // empty if block
            }
            if (!ModList.get().isLoaded("clayworks")) continue;
            ClayworksCompat.registerBlocks(color);
        }
    }

    public static RegistryObject<? extends Block> registerBlock(String name, Supplier<? extends Block> sup, CreativeModeTab tab, boolean registerItem) {
        RegistryObject block = DyenamicsAndFriends.BLOCKS.register(name, sup);
        if (registerItem) {
            DyenamicRegistry.registerItem(name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(tab)));
        }
        return block;
    }

    public static RegistryObject<? extends Block> registerBlock(String name, Supplier<? extends Block> sup, @Nullable Supplier<Item> itemSupplier) {
        RegistryObject block = DyenamicsAndFriends.BLOCKS.register(name, sup);
        if (itemSupplier != null) {
            DyenamicRegistry.registerItem(name, itemSupplier);
        }
        return block;
    }

    public static RegistryObject<? extends Item> registerItem(String name, @Nullable Supplier<Item> itemSupplier) {
        return DyenamicsAndFriends.ITEMS.register(name, itemSupplier);
    }

    public static <E extends BlockEntity, T extends BlockEntityType<E>> Supplier<T> registerBlockEntity(String id, Supplier<T> supplier) {
        return DyenamicsAndFriends.BLOCK_ENTITIES.register(id, supplier);
    }

    public static <E extends BlockEntity> BlockEntityType<E> createBlockEntityType(BlockEntityType.BlockEntitySupplier<E> factory, Block ... blocks) {
        return BlockEntityType.Builder.m_155273_(factory, (Block[])blocks).m_58966_(null);
    }

    public static void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        if (ModList.get().isLoaded("another_furniture")) {
            AnotherFurnitureCompat.Client.registerBlockEntityRenderers(event);
        }
        if (ModList.get().isLoaded("botanypots")) {
            BotanyPotsCompat.Client.registerBlockEntityRenderers(event);
        }
        if (ModList.get().isLoaded("comforts")) {
            ComfortsCompat.Client.registerBlockEntityRenderers(event);
        }
        if (ModList.get().isLoaded("farmersdelight")) {
            FarmersDelightCompat.Client.registerBlockEntityRenderers(event);
        }
        if (ModList.get().isLoaded("furnish")) {
            FurnishCompat.Client.registerBlockEntityRenderers(event);
        }
        if (ModList.get().isLoaded("ceramics")) {
            CeramicsCompat.Client.registerBlockEntityRenderers(event);
        }
        if (ModList.get().isLoaded("supplementaries")) {
            SupplementariesCompat.Client.registerBlockEntityRenderers(event);
        }
    }

    public static void registerBlockRendering(FMLClientSetupEvent event) {
        if (ModList.get().isLoaded("another_furniture")) {
            AnotherFurnitureCompat.Client.registerBlockRendering();
        }
        if (ModList.get().isLoaded("botanypots")) {
            BotanyPotsCompat.Client.registerBlockRendering();
        }
        if (ModList.get().isLoaded("chalk")) {
            ChalkCompat.Client.registerBlockRendering(event);
        }
        if (ModList.get().isLoaded("elevatorid")) {
            ElevatoridCompat.Client.registerBlockRendering();
        }
        if (ModList.get().isLoaded("furnish")) {
            FurnishCompat.Client.registerBlockRendering();
        }
        if (ModList.get().isLoaded("quark")) {
            QuarkCompat.Client.registerBlockRendering();
        }
        if (ModList.get().isLoaded("oreganized")) {
            OreganizedCompat.Client.registerBlockRendering();
        }
        if (ModList.get().isLoaded("ceramics")) {
            CeramicsCompat.Client.registerBlockRendering();
        }
        if (ModList.get().isLoaded("supplementaries")) {
            SupplementariesCompat.Client.registerBlockRendering();
        }
    }

    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        if (ModList.get().isLoaded("comforts")) {
            ComfortsCompat.stitchTextures(event);
        }
        if (ModList.get().isLoaded("farmersdelight")) {
            FarmersDelightCompat.stitchTextures(event);
        }
    }

    public static void onModelBake(ModelBakeEvent event) {
        if (ModList.get().isLoaded("chalk")) {
            ChalkCompat.Client.bakeModel(event);
        }
        if (ModList.get().isLoaded("elevatorid")) {
            ElevatoridCompat.Client.bakeModel(event);
        }
    }

    public static void onEntityPlace(BlockEvent.EntityPlaceEvent event) {
        if (ModList.get().isLoaded("furnish")) {
            FurnishCompat.entityPlace(event);
        }
    }

    public static void onPlayerRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (ModList.get().isLoaded("furnish")) {
            FarmersDelightCompat.playerRightClick(event);
        }
    }

    public static Block getDyenamicsBlock(DyenamicDyeColor color, String block) {
        return (Block)((RegistryObject)((Map)BlockInit.DYED_BLOCKS.get(color.m_7912_())).get(block)).get();
    }
}

