/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pickupnotifier.config;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fuzs.puzzleslib.config.serialization.EntryCollectionBuilder;
import fuzs.puzzleslib.json.JsonConfigFileUtil;
import java.io.FileReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ItemBlacklistManager {
    private static DimensionBlacklist defaultBlacklist = DimensionBlacklist.create(false);
    private static Map<ResourceKey<Level>, DimensionBlacklist> dimensionBlacklists = Maps.newIdentityHashMap();

    public static boolean isItemAllowed(ResourceKey<Level> dimension, Item item) {
        DimensionBlacklist blacklist = dimensionBlacklists.getOrDefault(dimension, defaultBlacklist);
        if (blacklist.inverted()) {
            return blacklist.items().contains(item);
        }
        return !blacklist.items().contains(item);
    }

    public static void loadAll(String directory) {
        defaultBlacklist = DimensionBlacklist.create(false);
        dimensionBlacklists = Maps.newIdentityHashMap();
        JsonConfigFileUtil.getAllAndLoad((String)directory, file -> {}, ItemBlacklistManager::deserializeDataEntry, () -> {});
    }

    private static void deserializeDataEntry(FileReader reader) {
        DimensionBlacklist blacklist;
        String[] items;
        ResourceKey dimension;
        JsonElement jsonElement = (JsonElement)JsonConfigFileUtil.GSON.fromJson((Reader)reader, JsonElement.class);
        JsonObject jsonObject = GsonHelper.m_13918_((JsonElement)jsonElement, (String)"pick ups config");
        boolean inverted = jsonObject.has("inverted") ? GsonHelper.m_13912_((JsonObject)jsonObject, (String)"inverted") : false;
        if (jsonObject.has("dimension")) {
            ResourceLocation resourceLocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"dimension"));
            dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)resourceLocation);
        } else {
            dimension = null;
        }
        if (jsonObject.has("items")) {
            JsonArray jsonArray = GsonHelper.m_13933_((JsonObject)jsonObject, (String)"items");
            items = (String[])JsonConfigFileUtil.GSON.fromJson((JsonElement)jsonArray, String[].class);
        } else {
            items = new String[]{};
        }
        if (dimension != null) {
            blacklist = dimensionBlacklists.computeIfAbsent((ResourceKey<Level>)dimension, dimension1 -> DimensionBlacklist.create(inverted));
            if (inverted != blacklist.inverted()) {
                throw new IllegalStateException("Found multiple configs for dimension %s where one is inverted and the other one is not, this is not allowed!".formatted(dimension));
            }
        } else {
            if (inverted != defaultBlacklist.inverted()) {
                defaultBlacklist = DimensionBlacklist.create(inverted);
            }
            blacklist = defaultBlacklist;
        }
        blacklist.items().addAll(EntryCollectionBuilder.of((IForgeRegistry)ForgeRegistries.ITEMS).buildSet(Arrays.asList(items)));
    }

    private record DimensionBlacklist(Set<Item> items, boolean inverted) {
        public static DimensionBlacklist create(boolean inverted) {
            return new DimensionBlacklist(Sets.newIdentityHashSet(), inverted);
        }
    }
}

