/*
 * Decompiled with CFR 0.152.
 */
package com.snowshock35.jeiintegration;

import com.mojang.blaze3d.platform.InputConstants;
import com.snowshock35.jeiintegration.JEIIntegration;
import com.snowshock35.jeiintegration.config.Config;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.Level;

public class TooltipEventHandler {
    private Config.Client config = Config.CLIENT;

    private static boolean isDebugMode() {
        return Minecraft.m_91087_().f_91066_.f_92125_;
    }

    private static boolean isShiftKeyDown() {
        return InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340) || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)344);
    }

    private void registerTooltip(ItemTooltipEvent e, Component tooltip, String configOption) {
        boolean isEnabled = false;
        if (Objects.equals(configOption, "enabled")) {
            isEnabled = true;
        } else if (Objects.equals(configOption, "onShift") && TooltipEventHandler.isShiftKeyDown()) {
            isEnabled = true;
        } else if (Objects.equals(configOption, "onDebug") && TooltipEventHandler.isDebugMode()) {
            isEnabled = true;
        } else if (Objects.equals(configOption, "onShiftAndDebug") && TooltipEventHandler.isShiftKeyDown() && TooltipEventHandler.isDebugMode()) {
            isEnabled = true;
        }
        if (isEnabled) {
            e.getToolTip().add(tooltip);
        }
    }

    private void registerTooltips(ItemTooltipEvent e, Collection<Component> tooltips, String configValue) {
        for (Component tooltip : tooltips) {
            this.registerTooltip(e, tooltip, configValue);
        }
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent e) {
        CompoundTag nbtData;
        int enchantability;
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        decimalFormat.setGroupingUsed(true);
        decimalFormat.setGroupingSize(3);
        ItemStack itemStack = e.getItemStack();
        Item item = itemStack.m_41720_();
        if (e.getItemStack().m_41619_()) {
            return;
        }
        int burnTime = 0;
        try {
            burnTime = ForgeHooks.getBurnTime((ItemStack)itemStack, (RecipeType)RecipeType.f_44108_);
        }
        catch (Exception ex) {
            JEIIntegration.logger.log(Level.WARN, "):\n\nSomething went wrong!");
        }
        if (burnTime > 0) {
            MutableComponent burnTooltip = new TranslatableComponent("tooltip.jeiintegration.burnTime").m_7220_((Component)new TextComponent(" " + decimalFormat.format(burnTime) + " ")).m_7220_((Component)new TranslatableComponent("tooltip.jeiintegration.burnTime.suffix")).m_130940_(ChatFormatting.DARK_GRAY);
            this.registerTooltip(e, (Component)burnTooltip, (String)this.config.burnTimeTooltipMode.get());
        }
        int maxDamage = itemStack.m_41776_();
        int currentDamage = maxDamage - itemStack.m_41773_();
        if (maxDamage > 0) {
            MutableComponent durabilityTooltip = new TranslatableComponent("tooltip.jeiintegration.durability").m_7220_((Component)new TextComponent(" " + currentDamage + "/" + maxDamage)).m_130940_(ChatFormatting.DARK_GRAY);
            this.registerTooltip(e, (Component)durabilityTooltip, (String)this.config.durabilityTooltipMode.get());
        }
        if ((enchantability = item.getItemEnchantability(itemStack)) > 0) {
            MutableComponent enchantabilityTooltip = new TranslatableComponent("tooltip.jeiintegration.enchantability").m_7220_((Component)new TextComponent(" " + enchantability)).m_130940_(ChatFormatting.DARK_GRAY);
            this.registerTooltip(e, (Component)enchantabilityTooltip, (String)this.config.enchantabilityTooltipMode.get());
        }
        FoodProperties foodProperties = item.getFoodProperties(itemStack, (LivingEntity)Minecraft.m_91087_().f_91074_);
        if (item.m_41472_() && foodProperties != null) {
            int healVal = foodProperties.m_38744_();
            float satVal = (float)healVal * (foodProperties.m_38745_() * 2.0f);
            MutableComponent foodTooltip = new TranslatableComponent("tooltip.jeiintegration.hunger").m_7220_((Component)new TextComponent(" " + healVal + " ")).m_7220_((Component)new TranslatableComponent("tooltip.jeiintegration.saturation")).m_7220_((Component)new TextComponent(" " + decimalFormat.format(satVal))).m_130940_(ChatFormatting.DARK_GRAY);
            this.registerTooltip(e, (Component)foodTooltip, (String)this.config.foodTooltipMode.get());
        }
        if ((nbtData = item.getShareTag(itemStack)) != null) {
            MutableComponent nbtTooltip = new TranslatableComponent("tooltip.jeiintegration.nbtTagData").m_7220_((Component)new TextComponent(" " + nbtData)).m_130940_(ChatFormatting.DARK_GRAY);
            this.registerTooltip(e, (Component)nbtTooltip, (String)this.config.nbtTooltipMode.get());
        }
        MutableComponent registryTooltip = new TranslatableComponent("tooltip.jeiintegration.registryName").m_7220_((Component)new TextComponent(" " + item.getRegistryName())).m_130940_(ChatFormatting.DARK_GRAY);
        this.registerTooltip(e, (Component)registryTooltip, (String)this.config.registryNameTooltipMode.get());
        int stackSize = e.getItemStack().m_41741_();
        if (stackSize > 0) {
            MutableComponent stackSizeTooltip = new TranslatableComponent("tooltip.jeiintegration.maxStackSize").m_7220_((Component)new TextComponent(" " + itemStack.m_41741_())).m_130940_(ChatFormatting.DARK_GRAY);
            this.registerTooltip(e, (Component)stackSizeTooltip, (String)this.config.maxStackSizeTooltipMode.get());
        }
        if (itemStack.m_204131_().toList().size() > 0) {
            MutableComponent tagsTooltip = new TranslatableComponent("tooltip.jeiintegration.tags").m_130940_(ChatFormatting.DARK_GRAY);
            HashSet<Component> tags = new HashSet<Component>();
            for (ResourceLocation tag : itemStack.m_204131_().map(TagKey::f_203868_).toList()) {
                tags.add((Component)new TextComponent("    " + tag).m_130940_(ChatFormatting.DARK_GRAY));
            }
            this.registerTooltip(e, (Component)tagsTooltip, (String)this.config.tagsTooltipMode.get());
            this.registerTooltips(e, tags, (String)this.config.tagsTooltipMode.get());
        }
        MutableComponent translationKeyTooltip = new TranslatableComponent("tooltip.jeiintegration.translationKey").m_7220_((Component)new TextComponent(" " + itemStack.m_41778_())).m_130940_(ChatFormatting.DARK_GRAY);
        this.registerTooltip(e, (Component)translationKeyTooltip, (String)this.config.translationKeyTooltipMode.get());
    }
}

