/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.transmitter;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import owmii.powah.Powah;
import owmii.powah.block.Tier;
import owmii.powah.block.transmitter.PlayerTransmitterTile;
import owmii.powah.config.v2.types.ChargingConfig;
import owmii.powah.inventory.PlayerTransmitterContainer;
import owmii.powah.lib.block.AbstractEnergyBlock;
import owmii.powah.lib.block.AbstractTileEntity;
import owmii.powah.lib.item.EnergyBlockItem;
import owmii.powah.lib.logistics.inventory.AbstractContainer;

public class PlayerTransmitterBlock
extends AbstractEnergyBlock<ChargingConfig, PlayerTransmitterBlock> {
    public static final BooleanProperty TOP = BooleanProperty.m_61465_((String)"top");
    public static final VoxelShape TOP_SHAPE = Shapes.m_83124_((VoxelShape)PlayerTransmitterBlock.box(6.0, 8.0, 6.0, 10.0, 12.0, 10.0), (VoxelShape[])new VoxelShape[]{PlayerTransmitterBlock.box(7.0, 4.5, 7.0, 9.0, 8.0, 9.0), PlayerTransmitterBlock.box(4.0, 0.5, 4.0, 12.0, 1.5, 12.0), PlayerTransmitterBlock.box(4.0, 2.0, 4.0, 12.0, 3.0, 12.0), PlayerTransmitterBlock.box(4.0, 3.5, 4.0, 12.0, 4.5, 12.0), PlayerTransmitterBlock.box(1.0, -15.0, 1.0, 15.0, -1.0, 15.0), PlayerTransmitterBlock.box(4.0, -1.0, 4.0, 12.0, 0.0, 12.0)});
    public static final VoxelShape BOTTOM_SHAPE = Shapes.m_83124_((VoxelShape)PlayerTransmitterBlock.box(6.0, 24.0, 6.0, 10.0, 28.0, 10.0), (VoxelShape[])new VoxelShape[]{PlayerTransmitterBlock.box(7.0, 20.5, 7.0, 9.0, 24.0, 9.0), PlayerTransmitterBlock.box(4.0, 16.5, 4.0, 12.0, 17.5, 12.0), PlayerTransmitterBlock.box(4.0, 18.0, 4.0, 12.0, 19.0, 12.0), PlayerTransmitterBlock.box(4.0, 19.5, 4.0, 12.0, 20.5, 12.0), PlayerTransmitterBlock.box(1.0, 1.0, 1.0, 15.0, 15.0, 15.0), PlayerTransmitterBlock.box(4.0, 15.0, 4.0, 12.0, 16.0, 12.0)});

    public PlayerTransmitterBlock(BlockBehaviour.Properties properties, Tier variant) {
        super(properties, variant);
        this.setStateProps(state -> (BlockState)state.m_61124_((Property)TOP, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)TOP) != false ? TOP_SHAPE : BOTTOM_SHAPE;
    }

    @Override
    public ChargingConfig getConfig() {
        return Powah.config().devices.player_transmitters;
    }

    @Override
    public EnergyBlockItem getBlockItem(Item.Properties properties, @Nullable CreativeModeTab group) {
        return super.getBlockItem(properties.m_41487_(1), group);
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return (Boolean)state.m_61143_((Property)TOP) == false ? new PlayerTransmitterTile(pos, state, (Tier)this.variant) : null;
    }

    @Override
    @Nullable
    public AbstractContainer getContainer(int id, Inventory inventory, AbstractTileEntity te, BlockHitResult result) {
        if (te instanceof PlayerTransmitterTile) {
            return new PlayerTransmitterContainer(id, inventory, (PlayerTransmitterTile)te);
        }
        return null;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockState bottomState;
        if (((Boolean)state.m_61143_((Property)TOP)).booleanValue() && (bottomState = world.m_8055_(pos.m_7495_())).m_60734_() instanceof PlayerTransmitterBlock) {
            return bottomState.m_60734_().m_6227_(bottomState, world, pos.m_7495_(), player, hand, result);
        }
        return super.m_6227_(state, world, pos, player, hand, result);
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        BlockState bottomState = world.m_8055_(currentPos.m_7495_());
        BlockState topState = world.m_8055_(currentPos.m_7494_());
        if (!((Boolean)state.m_61143_((Property)TOP)).booleanValue() && !(topState.m_60734_() instanceof PlayerTransmitterBlock) || ((Boolean)state.m_61143_((Property)TOP)).booleanValue() && !(bottomState.m_60734_() instanceof PlayerTransmitterBlock)) {
            world.m_7731_(currentPos, Blocks.f_50016_.m_49966_(), 3);
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
    }

    @Override
    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, world, pos, oldState, isMoving);
        if (!((Boolean)state.m_61143_((Property)TOP)).booleanValue() && world.m_46859_(pos.m_7494_())) {
            world.m_7731_(pos.m_7494_(), (BlockState)this.m_49966_().m_61124_((Property)TOP, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)TOP) != false ? super.m_7898_(state, world, pos) : world.m_46859_(pos.m_7494_()) || world.m_8055_(pos.m_7494_()).m_60734_() == this;
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        if (player.m_7500_()) {
            world.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
            return;
        }
        BlockEntity tileEntity = world.m_7702_((Boolean)state.m_61143_((Property)TOP) != false ? pos.m_7495_() : pos);
        if (!world.m_5776_() && tileEntity instanceof PlayerTransmitterTile) {
            PlayerTransmitterTile tile = (PlayerTransmitterTile)tileEntity;
            ItemStack stack = tile.storeToStack(new ItemStack((ItemLike)this));
            PlayerTransmitterBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)stack);
            world.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        }
    }

    @Override
    public void m_6240_(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{TOP}));
    }
}

