/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.move;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class EscapeSun<E extends PathfinderMob>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_ABSENT), Pair.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED)});
    protected float speedModifier = 1.0f;
    protected Vec3 hidePos = null;

    public EscapeSun<E> speedModifier(float speedMod) {
        this.speedModifier = speedMod;
        return this;
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        if (!(level.m_46461_() && entity.m_6060_() && level.m_45527_(entity.m_142538_()))) {
            return false;
        }
        if (!entity.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
            return false;
        }
        this.hidePos = this.getHidePos(entity);
        return this.hidePos != null;
    }

    @Override
    protected void start(E entity) {
        BrainUtils.setMemory(entity, MemoryModuleType.f_26370_, new WalkTarget(this.hidePos, this.speedModifier, 0));
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        if (this.hidePos == null) {
            return false;
        }
        WalkTarget walkTarget = (WalkTarget)BrainUtils.getMemory(entity, MemoryModuleType.f_26370_);
        if (walkTarget == null) {
            return false;
        }
        return walkTarget.m_26420_().m_6675_().equals((Object)new BlockPos(this.hidePos)) && !entity.m_21573_().m_26571_();
    }

    @Override
    protected boolean m_7773_(long gameTime) {
        return false;
    }

    @Override
    protected void stop(E entity) {
        this.hidePos = null;
    }

    @Nullable
    protected Vec3 getHidePos(E entity) {
        Random randomsource = entity.m_21187_();
        BlockPos entityPos = entity.m_142538_();
        for (int i = 0; i < 10; ++i) {
            BlockPos hidePos = entityPos.m_142082_(randomsource.nextInt(20) - 10, randomsource.nextInt(6) - 3, randomsource.nextInt(20) - 10);
            if (((PathfinderMob)entity).f_19853_.m_45527_(hidePos) || !(entity.m_21692_(hidePos) < 0.0f)) continue;
            return Vec3.m_82539_((Vec3i)hidePos);
        }
        return null;
    }
}

