/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.sensor.vanilla;

import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.pathfinder.Path;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.registry.SBLSensors;
import net.tslat.smartbrainlib.util.BrainUtils;

public class NearestHomeSensor<E extends Mob>
extends PredicateSensor<E, E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.of((Object[])new MemoryModuleType[]{MemoryModuleType.f_26380_});
    protected int radius = 48;
    private final Object2LongOpenHashMap<BlockPos> homesMap = new Object2LongOpenHashMap(5);
    private int tries = 0;

    public NearestHomeSensor() {
        super((brainOwner, entity) -> brainOwner.m_6162_());
    }

    public NearestHomeSensor<E> setRadius(int radius) {
        this.radius = radius;
        return this;
    }

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return SBLSensors.NEAREST_HOME.get();
    }

    protected void doTick(ServerLevel level, E entity) {
        if (!this.predicate().test(entity, entity)) {
            return;
        }
        this.tries = 0;
        long nodeExpiryTime = level.m_46467_() + (long)level.m_5822_().nextInt(20);
        PoiManager poiManager = level.m_8904_();
        Predicate<BlockPos> predicate = pos -> {
            if (this.homesMap.containsKey(pos)) {
                return false;
            }
            if (++this.tries >= 5) {
                return false;
            }
            this.homesMap.put(pos, nodeExpiryTime + 40L);
            return true;
        };
        Set poiLocations = poiManager.m_27138_(poiType -> poiType.equals(PoiType.f_27346_), predicate, entity.m_142538_(), this.radius, PoiManager.Occupancy.ANY).collect(Collectors.toSet());
        Path pathToHome = entity.m_21573_().m_26548_(poiLocations, PoiType.f_27346_.m_27397_());
        if (pathToHome != null && pathToHome.m_77403_()) {
            BlockPos targetPos = pathToHome.m_77406_();
            poiManager.m_27177_(targetPos).ifPresent(poiType -> BrainUtils.setMemory((LivingEntity)entity, MemoryModuleType.f_26380_, targetPos));
        } else if (this.tries < 5) {
            this.homesMap.object2LongEntrySet().removeIf(pos -> pos.getLongValue() < nodeExpiryTime);
        }
    }
}

