/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.api.everbook;

import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.Widget;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.api.utils.NBTHelper;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ram.talia.hexal.api.HexalAPI;
import ram.talia.hexal.api.everbook.Everbook;
import ram.talia.hexal.api.everbook.FileEncrypterDecrypter;
import ram.talia.hexal.api.everbook.MacroHolder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 (2\u00020\u0001:\u0001(B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012 \b\u0002\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0006\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\tJ\u001a\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019J\u0015\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u001aJ\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\tH\u0002J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001c\u001a\u00020\u001dJ\"\u0010\u001e\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0017\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\tJ\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\tJ\u0006\u0010#\u001a\u00020\"J\u0006\u0010$\u001a\u00020\nJ\u001a\u0010%\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\t2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u0017J\u0016\u0010%\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010&\u001a\u00020\nJ\u000e\u0010'\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\tR&\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006)"}, d2={"Lram/talia/hexal/api/everbook/Everbook;", "", "uuid", "Ljava/util/UUID;", "(Ljava/util/UUID;)V", "entries", "", "", "Lkotlin/Pair;", "Lat/petrak/hexcasting/api/spell/math/HexPattern;", "Lnet/minecraft/nbt/CompoundTag;", "macros", "", "(Ljava/util/UUID;Ljava/util/Map;Ljava/util/List;)V", "everbookEncrypterDecrypter", "Lram/talia/hexal/api/everbook/FileEncrypterDecrypter;", "macroHolder", "Lram/talia/hexal/api/everbook/MacroHolder;", "getUuid", "()Ljava/util/UUID;", "getClientIota", "key", "getIota", "Lat/petrak/hexcasting/api/spell/SpellDatum;", "level", "Lnet/minecraft/server/level/ServerLevel;", "getIota$hexal_forge_1_18_2", "getKey", "index", "", "getMacro", "isMacro", "", "removeIota", "", "saveToDisk", "serialiseToNBT", "setIota", "iota", "toggleMacro", "Companion", "hexal-forge-1.18.2"})
public final class Everbook {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UUID uuid;
    @NotNull
    private final Map<String, Pair<HexPattern, CompoundTag>> entries;
    @NotNull
    private final FileEncrypterDecrypter everbookEncrypterDecrypter;
    @NotNull
    private final MacroHolder macroHolder;
    @NotNull
    public static final String TAG_UUID = "uuid";
    @NotNull
    public static final String TAG_MACROS = "macros";
    @NotNull
    public static final String TAG_PATTERN = "pattern";
    @NotNull
    public static final String TAG_IOTA = "iota";

    public Everbook(@NotNull UUID uuid, @NotNull Map<String, Pair<HexPattern, CompoundTag>> entries, @NotNull List<String> macros) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)TAG_UUID);
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        Intrinsics.checkNotNullParameter(macros, (String)TAG_MACROS);
        this.uuid = uuid;
        this.entries = entries;
        this.everbookEncrypterDecrypter = new FileEncrypterDecrypter(FileEncrypterDecrypter.Companion.getKey(this.uuid, "AES"), "AES/CBC/PKCS5Padding");
        this.macroHolder = new MacroHolder(this, macros);
    }

    public /* synthetic */ Everbook(UUID uUID, Map map, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = new LinkedHashMap();
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(uUID, map, list);
    }

    @NotNull
    public final UUID getUuid() {
        return this.uuid;
    }

    public Everbook(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)TAG_UUID);
        this(uuid, new LinkedHashMap(), CollectionsKt.emptyList());
    }

    @NotNull
    public final SpellDatum<?> getIota(@NotNull HexPattern key, @NotNull ServerLevel level) {
        Pair<HexPattern, CompoundTag> entry;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Pair<HexPattern, CompoundTag> pair = entry = this.entries.get(this.getKey(key));
        return pair == null ? SpellDatum.Companion.make((Object)Widget.NULL) : SpellDatum.Companion.fromNBT((CompoundTag)pair.getSecond(), level);
    }

    @NotNull
    public final CompoundTag getIota$hexal_forge_1_18_2(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        CompoundTag entry = this.entries.get(key);
        CompoundTag compoundTag = entry;
        if (compoundTag == null || (compoundTag = (CompoundTag)compoundTag.getSecond()) == null) {
            compoundTag = new CompoundTag();
        }
        return compoundTag;
    }

    public final void setIota(@NotNull HexPattern key, @NotNull SpellDatum<?> iota) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(iota, (String)TAG_IOTA);
        this.entries.put(this.getKey(key), (Pair<HexPattern, CompoundTag>)new Pair((Object)key, (Object)iota.serializeToNBT()));
        if (this.macroHolder.isMacro(key)) {
            this.macroHolder.recalcMacros();
        }
    }

    public final void setIota(@NotNull HexPattern key, @NotNull CompoundTag iota) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)iota, (String)TAG_IOTA);
        this.entries.put(this.getKey(key), (Pair<HexPattern, CompoundTag>)new Pair((Object)key, (Object)iota));
        if (this.macroHolder.isMacro(key)) {
            this.macroHolder.recalcMacros();
        }
    }

    public final void removeIota(@NotNull HexPattern key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.entries.remove(this.getKey(key));
        if (this.macroHolder.isMacro(key)) {
            this.macroHolder.recalcMacros();
        }
    }

    @Nullable
    public final List<SpellDatum<?>> getMacro(@NotNull HexPattern key, @NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return this.macroHolder.getMacro(key, level);
    }

    public final boolean isMacro(@NotNull HexPattern key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.macroHolder.isMacro(key);
    }

    public final void toggleMacro(@NotNull HexPattern key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (this.macroHolder.isMacro(key)) {
            this.macroHolder.deleteMacro(key);
        } else {
            this.macroHolder.setMacro(key);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final HexPattern getKey(int index) {
        void $this$mapTo$iv$iv;
        if (index >= this.entries.size() || index < 0) {
            return null;
        }
        Iterable $this$map$iv = this.entries.values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((HexPattern)it.getFirst());
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return (HexPattern)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                HexPattern it = (HexPattern)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.anglesSignature());
                it = (HexPattern)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.anglesSignature())));
            }
        }).get(index);
    }

    @Nullable
    public final CompoundTag getClientIota(@NotNull HexPattern key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Pair<HexPattern, CompoundTag> pair = this.entries.get(this.getKey(key));
        return pair != null ? (CompoundTag)pair.getSecond() : null;
    }

    private final String getKey(HexPattern key) {
        CharSequence charSequence;
        String angles = key.anglesSignature();
        CharSequence charSequence2 = angles;
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = "empty";
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    @NotNull
    public final CompoundTag serialiseToNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128362_(TAG_UUID, this.uuid);
        NBTHelper.putList((CompoundTag)tag, (String)TAG_MACROS, (ListTag)this.macroHolder.serialiseToNBT());
        Map<String, Pair<HexPattern, CompoundTag>> $this$forEach$iv = this.entries;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Pair<HexPattern, CompoundTag>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Pair<HexPattern, CompoundTag>> element$iv;
            Map.Entry<String, Pair<HexPattern, CompoundTag>> entry = element$iv = iterator.next();
            boolean bl = false;
            String key = entry.getKey();
            Pair<HexPattern, CompoundTag> pair = entry.getValue();
            CompoundTag pairCompound = new CompoundTag();
            pairCompound.m_128365_(TAG_PATTERN, (Tag)((HexPattern)pair.getFirst()).serializeToNBT());
            pairCompound.m_128365_(TAG_IOTA, (Tag)pair.getSecond());
            tag.m_128365_(key, (Tag)pairCompound);
        }
        return tag;
    }

    public final void saveToDisk() {
        Path MINECRAFT_PATH = Minecraft.m_91087_().f_91069_.toPath();
        Path everbookPath = MINECRAFT_PATH.resolve("everbook/everbook-" + this.uuid + ".dat");
        Intrinsics.checkNotNullExpressionValue((Object)everbookPath, (String)"everbookPath");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        Path oldEverbookPath = Files.exists(everbookPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? everbookPath : Minecraft.m_91087_().f_91069_.toPath().resolve("everbook.dat");
        Intrinsics.checkNotNullExpressionValue((Object)oldEverbookPath, (String)"oldEverbookPath");
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (Files.exists(oldEverbookPath, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            Function0 currentBackups2 = (Function0)new Function0<Stream<Path>>(MINECRAFT_PATH, this){
                final /* synthetic */ Path $MINECRAFT_PATH;
                final /* synthetic */ Everbook this$0;
                {
                    this.$MINECRAFT_PATH = $MINECRAFT_PATH;
                    this.this$0 = $receiver;
                    super(0);
                }

                public final Stream<Path> invoke() {
                    Path path;
                    Path $this$invoke_u24lambda_u2d0 = path = this.$MINECRAFT_PATH.resolve("everbook/");
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)$this$invoke_u24lambda_u2d0, (String)"");
                    FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                    Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories($this$invoke_u24lambda_u2d0, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(this, *attributes)");
                    return Files.list(path).filter(arg_0 -> saveToDisk.currentBackups.1.invoke$lambda-1(this.this$0, arg_0));
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                private static final boolean invoke$lambda-1(Everbook this$0, Path p) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Path path = p.getFileName();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"p.fileName");
                    if (!StringsKt.contains$default((CharSequence)PathsKt.getName((Path)path), (CharSequence)"backup", (boolean)false, (int)2, null)) return false;
                    Path path2 = p.getFileName();
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"p.fileName");
                    CharSequence charSequence = PathsKt.getName((Path)path2);
                    String string = this$0.getUuid().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uuid.toString()");
                    if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null)) return false;
                    return true;
                }
            };
            long currentBackupCount = ((Stream)currentBackups2.invoke()).count();
            Path destination = currentBackupCount < 6L ? MINECRAFT_PATH.resolve("everbook/everbook-" + this.uuid + "-backup-" + currentBackupCount + ".dat") : ((Stream)currentBackups2.invoke()).min(Comparator.comparing(Everbook::saveToDisk$lambda-4)).orElse(MINECRAFT_PATH.resolve("everbook/everbook-" + this.uuid + "-backup-" + currentBackupCount + ".dat"));
            Intrinsics.checkNotNullExpressionValue((Object)destination, (String)"destination");
            Files.deleteIfExists(destination);
            Path path = oldEverbookPath;
            Path path2 = destination;
            CopyOption[] copyOptionArray = (CopyOption[])((Object[])new CopyOption[0]);
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path, path2, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"copy(this, target, *options)");
        }
        CompoundTag tag = this.serialiseToNBT();
        HexalAPI.LOGGER.info("saving everbook " + tag + " at " + everbookPath);
        File file = everbookPath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"everbookPath.toFile()");
        this.everbookEncrypterDecrypter.encrypt(tag, file);
    }

    private static final Instant saveToDisk$lambda-4(Path p) {
        return Files.readAttributes(p, BasicFileAttributes.class, new LinkOption[0]).lastModifiedTime().toInstant();
    }

    @JvmStatic
    @NotNull
    public static final Everbook fromNbt(@NotNull CompoundTag tag) {
        return Companion.fromNbt(tag);
    }

    @JvmStatic
    @NotNull
    public static final Everbook fromDisk(@NotNull UUID uuid) {
        return Companion.fromDisk(uuid);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lram/talia/hexal/api/everbook/Everbook$Companion;", "", "()V", "TAG_IOTA", "", "TAG_MACROS", "TAG_PATTERN", "TAG_UUID", "fromDisk", "Lram/talia/hexal/api/everbook/Everbook;", "uuid", "Ljava/util/UUID;", "fromNbt", "tag", "Lnet/minecraft/nbt/CompoundTag;", "hexal-forge-1.18.2"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Everbook fromNbt(@NotNull CompoundTag tag) {
            List list;
            String string;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Map entries = new LinkedHashMap();
            Set set = tag.m_128431_();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"tag.allKeys");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CompoundTag pairCompound;
                String it = (String)element$iv;
                boolean bl = false;
                if (it.equals(Everbook.TAG_UUID) || it.equals(Everbook.TAG_MACROS) || !NBTHelper.hasCompound((CompoundTag)(pairCompound = tag.m_128469_(it)), (String)Everbook.TAG_PATTERN) || !NBTHelper.hasCompound((CompoundTag)pairCompound, (String)Everbook.TAG_IOTA)) continue;
                Map map = entries;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                string = it;
                CompoundTag compoundTag = pairCompound.m_128469_(Everbook.TAG_PATTERN);
                Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"pairCompound.getCompound(TAG_PATTERN)");
                Pair pair = new Pair((Object)HexPattern.Companion.fromNBT(compoundTag), (Object)pairCompound.m_128469_(Everbook.TAG_IOTA));
                map.put(string, pair);
            }
            if (NBTHelper.hasList((CompoundTag)tag, (String)Everbook.TAG_MACROS)) {
                void $this$mapTo$iv$iv;
                Object element$iv;
                Iterable $this$map$iv = (Iterable)NBTHelper.getListByByte((CompoundTag)tag, (String)Everbook.TAG_MACROS, (byte)8);
                boolean $i$f$map = false;
                element$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    string = (Tag)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    void v2 = it;
                    if (v2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type net.minecraft.nbt.StringTag");
                    }
                    collection.add(((StringTag)v2).m_7916_());
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            List macros = list;
            UUID uUID = tag.m_128342_(Everbook.TAG_UUID);
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"tag.getUUID(TAG_UUID)");
            return new Everbook(uUID, entries, macros);
        }

        @JvmStatic
        @NotNull
        public final Everbook fromDisk(@NotNull UUID uuid) {
            Path everbookPath;
            Intrinsics.checkNotNullParameter((Object)uuid, (String)Everbook.TAG_UUID);
            Path MINECRAFT_PATH = Minecraft.m_91087_().f_91069_.toPath();
            Path path = everbookPath = MINECRAFT_PATH.resolve("everbook/everbook-" + uuid + ".dat");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"everbookPath");
            Path path2 = path;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                everbookPath = MINECRAFT_PATH.resolve("everbook.dat");
            }
            FileEncrypterDecrypter everbookEncrypterDecrypter = new FileEncrypterDecrypter(FileEncrypterDecrypter.Companion.getKey(uuid, "AES"), "AES/CBC/PKCS5Padding");
            File file = everbookPath.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"everbookPath.toFile()");
            CompoundTag compoundTag = everbookEncrypterDecrypter.decryptCompound(file);
            if (compoundTag == null) {
                return new Everbook(uuid);
            }
            CompoundTag tag = compoundTag;
            HexalAPI.LOGGER.info("loading everbook " + tag + " for " + uuid + " from " + everbookPath);
            return this.fromNbt(tag);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

