/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.api.linkable;

import at.petrak.hexcasting.api.misc.FrozenColorizer;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.Widget;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ram.talia.hexal.api.OperatorUtilsKt;
import ram.talia.hexal.api.linkable.ILinkable;
import ram.talia.hexal.api.linkable.LinkableRegistry;
import ram.talia.hexal.api.linkable.LinkableTypes;
import ram.talia.hexal.api.nbt.SerialisedIotaList;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 G2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002GHB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010 \u001a\u00020!2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u0001H\u0002J\b\u0010#\u001a\u00020\u0000H\u0016J\u0012\u0010$\u001a\f\u0012\u0004\u0012\u00020\u0000\u0012\u0002\b\u00030%H\u0016J\u0014\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00012\u0006\u0010&\u001a\u00020'H\u0016J\u0014\u0010(\u001a\u00020'2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0001H\u0016J\u0010\u0010)\u001a\n +*\u0004\u0018\u00010*0*H\u0016J\u001c\u0010,\u001a\u00020!2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u00012\u0006\u0010-\u001a\u00020.H\u0016J\u000e\u0010/\u001a\u00020!2\u0006\u00100\u001a\u000201J\b\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\n\u0012\u0006\b\u0001\u0012\u0002050\u0007H\u0016J\b\u00106\u001a\u00020'H\u0016J\b\u00107\u001a\u00020'H\u0016J\u0006\u00108\u001a\u00020!J\u0014\u00109\u001a\u00020!2\n\u0010:\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J\u000e\u0010;\u001a\u00020!2\u0006\u0010&\u001a\u00020'J\u0014\u0010;\u001a\u00020!2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u0001H\u0002J\u0006\u0010<\u001a\u00020!J\u000e\u0010=\u001a\u00020!2\u0006\u00100\u001a\u000201J\u000e\u0010\u001e\u001a\u00020!2\u0006\u0010>\u001a\u00020'J\b\u0010?\u001a\u00020.H\u0016J\b\u0010@\u001a\u00020AH\u0016J\u001c\u0010B\u001a\u00020!2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u00012\u0006\u0010C\u001a\u00020.H\u0016J\b\u0010D\u001a\u00020EH\u0016J\b\u0010F\u001a\u00020EH\u0016R\u001e\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R8\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u00102\u0010\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u00108F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\t\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0017\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\tR\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u001b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00012\f\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00018F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006I"}, d2={"Lram/talia/hexal/api/linkable/PlayerLinkstore;", "Lram/talia/hexal/api/linkable/ILinkable;", "player", "Lnet/minecraft/server/level/ServerPlayer;", "(Lnet/minecraft/server/level/ServerPlayer;)V", "asSpellResult", "", "Lat/petrak/hexcasting/api/spell/SpellDatum;", "getAsSpellResult", "()Ljava/util/List;", "lazyLinked", "Lram/talia/hexal/api/linkable/ILinkable$LazyILinkableList;", "lazyRenderLinks", "lazyTransmittingTo", "Lram/talia/hexal/api/linkable/ILinkable$LazyILinkable;", "value", "", "linked", "getLinked", "setLinked", "(Ljava/util/List;)V", "getPlayer", "()Lnet/minecraft/server/level/ServerPlayer;", "renderLinks", "getRenderLinks", "serReceivedIotas", "Lram/talia/hexal/api/nbt/SerialisedIotaList;", "transmittingTo", "getTransmittingTo", "()Lram/talia/hexal/api/linkable/ILinkable;", "setTransmittingTo", "(Lram/talia/hexal/api/linkable/ILinkable;)V", "addRenderLink", "", "other", "get", "getLinkableType", "Lram/talia/hexal/api/linkable/LinkableRegistry$LinkableType;", "index", "", "getLinkedIndex", "getPos", "Lnet/minecraft/world/phys/Vec3;", "kotlin.jvm.PlatformType", "link", "linkOther", "", "loadAdditionalData", "tag", "Lnet/minecraft/nbt/CompoundTag;", "maxSqrLinkRange", "", "nextReceivedIota", "", "numLinked", "numRemainingIota", "pruneLinks", "receiveIota", "iota", "removeRenderLink", "resetTransmittingTo", "saveAdditionalData", "to", "shouldRemove", "toString", "", "unlink", "unlinkOther", "writeToNbt", "Lnet/minecraft/nbt/Tag;", "writeToSync", "Companion", "RenderCentre", "hexal-forge-1.18.2"})
public final class PlayerLinkstore
implements ILinkable<PlayerLinkstore> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ServerPlayer player;
    @NotNull
    private final List<SpellDatum<?>> asSpellResult;
    @NotNull
    private final SerialisedIotaList serReceivedIotas;
    @NotNull
    private final ILinkable.LazyILinkableList lazyLinked;
    @NotNull
    private final ILinkable.LazyILinkableList lazyRenderLinks;
    @NotNull
    private final ILinkable.LazyILinkable lazyTransmittingTo;
    @NotNull
    public static final String TAG_LINKS = "links";
    @NotNull
    public static final String TAG_RENDER_LINKS = "render_links";
    @NotNull
    public static final String TAG_RECEIVED_IOTAS = "received_iotas";
    @NotNull
    public static final String TAG_TRANSMITTING_TO = "transmitting_to";

    public PlayerLinkstore(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.player = player;
        this.asSpellResult = CollectionsKt.listOf((Object)SpellDatum.Companion.make((Object)this.player));
        this.serReceivedIotas = new SerialisedIotaList(null);
        Level level = this.player.f_19853_;
        if (level == null) {
            throw new NullPointerException("null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        }
        this.lazyLinked = new ILinkable.LazyILinkableList((ServerLevel)level);
        Level level2 = this.player.f_19853_;
        if (level2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        }
        this.lazyRenderLinks = new ILinkable.LazyILinkableList((ServerLevel)level2);
        Level level3 = this.player.f_19853_;
        if (level3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        }
        this.lazyTransmittingTo = new ILinkable.LazyILinkable((ServerLevel)level3);
    }

    @NotNull
    public final ServerPlayer getPlayer() {
        return this.player;
    }

    @Override
    @NotNull
    public List<SpellDatum<?>> getAsSpellResult() {
        return this.asSpellResult;
    }

    @NotNull
    public final List<ILinkable<?>> getLinked() {
        return this.lazyLinked.get();
    }

    public final void setLinked(@NotNull List<ILinkable<?>> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.lazyLinked.set(value);
    }

    @NotNull
    public final List<ILinkable<?>> getRenderLinks() {
        return this.lazyRenderLinks.get();
    }

    private final void addRenderLink(ILinkable<?> other) {
        this.getRenderLinks().add(other);
        ram.talia.hexal.xplat.IXplatAbstractions.INSTANCE.syncAddRenderLinkPlayer(this.player, other);
    }

    private final void removeRenderLink(ILinkable<?> other) {
        this.getRenderLinks().remove(other);
        ram.talia.hexal.xplat.IXplatAbstractions.INSTANCE.syncRemoveRenderLinkPlayer(this.player, other);
    }

    public final void removeRenderLink(int index) {
        ILinkable<?> removed = this.getRenderLinks().remove(index);
        ram.talia.hexal.xplat.IXplatAbstractions.INSTANCE.syncRemoveRenderLinkPlayer(this.player, removed);
    }

    public final void pruneLinks() {
        for (int i = this.getLinked().size() - 1; -1 < i; --i) {
            if (!this.getLinked().get(i).shouldRemove() && this.isInRange(this.getLinked().get(i))) continue;
            ILinkable.DefaultImpls.unlink$default(this, this.getLinked().get(i), false, 2, null);
        }
    }

    @Nullable
    public final ILinkable<?> getTransmittingTo() {
        ILinkable iLinkable = (ILinkable)this.lazyTransmittingTo.get();
        if (iLinkable == null) {
            return null;
        }
        ILinkable it = iLinkable;
        if (this.isInRange(it)) {
            return it;
        }
        this.resetTransmittingTo();
        return null;
    }

    private final void setTransmittingTo(ILinkable<?> value) {
        this.lazyTransmittingTo.set(value);
    }

    public final void setTransmittingTo(int to) {
        if (to >= this.numLinked()) {
            this.resetTransmittingTo();
            return;
        }
        this.setTransmittingTo(this.getLinked(to));
    }

    public final void resetTransmittingTo() {
        this.setTransmittingTo(null);
    }

    @Override
    @NotNull
    public PlayerLinkstore get() {
        return this;
    }

    @Override
    public double maxSqrLinkRange() {
        return 1024.0;
    }

    @Override
    @NotNull
    public LinkableRegistry.LinkableType<PlayerLinkstore, ?> getLinkableType() {
        return LinkableTypes.INSTANCE.getPLAYER_LINKSTORE_TYPE();
    }

    @Override
    public Vec3 getPos() {
        return this.player.m_20182_();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean shouldRemove() {
        if (!this.player.m_146910_()) return false;
        Entity.RemovalReason removalReason = this.player.m_146911_();
        if (removalReason == null) return false;
        if (!removalReason.m_146965_()) return false;
        return true;
    }

    @Override
    public void link(@NotNull ILinkable<?> other, boolean linkOther) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (this.getLinked().contains(other) || other instanceof PlayerLinkstore && this.player.m_142081_().equals(((PlayerLinkstore)other).player.m_142081_())) {
            return;
        }
        this.getLinked().add(other);
        if (linkOther) {
            this.addRenderLink(other);
        }
        if (linkOther) {
            other.link(this, false);
        }
    }

    @Override
    public void unlink(@NotNull ILinkable<?> other, boolean unlinkOther) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        this.getLinked().remove(other);
        this.removeRenderLink(other);
        if (unlinkOther) {
            other.unlink(this, false);
        }
    }

    @Override
    @NotNull
    public ILinkable<?> getLinked(int index) {
        return this.getLinked().get(index);
    }

    @Override
    public int getLinkedIndex(@NotNull ILinkable<?> linked) {
        Intrinsics.checkNotNullParameter(linked, (String)"linked");
        return this.getLinked().indexOf(linked);
    }

    @Override
    public int numLinked() {
        return this.getLinked().size();
    }

    @Override
    public void receiveIota(@NotNull SpellDatum<?> iota) {
        Intrinsics.checkNotNullParameter(iota, (String)"iota");
        ServerLevel serverLevel = this.player.m_183503_();
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"player.getLevel()");
        this.serReceivedIotas.add(iota, serverLevel);
    }

    @Override
    @NotNull
    public SpellDatum<? extends Object> nextReceivedIota() {
        ServerLevel serverLevel = this.player.m_183503_();
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"player.getLevel()");
        SpellDatum spellDatum = this.serReceivedIotas.pop(serverLevel);
        if (spellDatum == null) {
            spellDatum = SpellDatum.Companion.make((Object)Widget.NULL);
        }
        return spellDatum;
    }

    @Override
    public int numRemainingIota() {
        return this.getLinked().size();
    }

    @Override
    @NotNull
    public Tag writeToNbt() {
        IntArrayTag intArrayTag = NbtUtils.m_129226_((UUID)this.player.m_142081_());
        Intrinsics.checkNotNullExpressionValue((Object)intArrayTag, (String)"createUUID(player.uuid)");
        return (Tag)intArrayTag;
    }

    @Override
    @NotNull
    public Tag writeToSync() {
        IntTag intTag = IntTag.m_128679_((int)this.player.m_142049_());
        Intrinsics.checkNotNullExpressionValue((Object)intTag, (String)"valueOf(player.id)");
        return (Tag)intTag;
    }

    public final void loadAdditionalData(@NotNull CompoundTag tag) {
        CompoundTag transmittingToTag;
        ListTag receivedIotaTag;
        ListTag renderLinkedTag;
        ListTag linkedTag;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Tag tag2 = tag.m_128423_(TAG_LINKS);
        ListTag listTag = linkedTag = tag2 instanceof ListTag ? (ListTag)tag2 : null;
        if (linkedTag == null) {
            this.lazyLinked.set((List)new ArrayList());
        } else {
            this.lazyLinked.set((Tag)linkedTag);
        }
        tag2 = tag.m_128423_(TAG_RENDER_LINKS);
        ListTag listTag2 = renderLinkedTag = tag2 instanceof ListTag ? (ListTag)tag2 : null;
        if (renderLinkedTag == null) {
            this.lazyRenderLinks.set((List)new ArrayList());
        } else {
            this.lazyRenderLinks.set((Tag)renderLinkedTag);
        }
        tag2 = tag.m_128423_(TAG_RECEIVED_IOTAS);
        ListTag listTag3 = receivedIotaTag = tag2 instanceof ListTag ? (ListTag)tag2 : null;
        if (receivedIotaTag == null) {
            this.serReceivedIotas.set(new ArrayList());
        } else {
            this.serReceivedIotas.setTag(receivedIotaTag);
        }
        tag2 = tag.m_128423_(TAG_TRANSMITTING_TO);
        CompoundTag compoundTag = transmittingToTag = tag2 instanceof CompoundTag ? (CompoundTag)tag2 : null;
        if (transmittingToTag == null) {
            this.lazyTransmittingTo.set(null);
        } else {
            this.lazyTransmittingTo.set((Tag)transmittingToTag);
        }
    }

    public final void saveAdditionalData(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        tag.m_128365_(TAG_LINKS, this.lazyLinked.getUnloaded());
        tag.m_128365_(TAG_RENDER_LINKS, this.lazyRenderLinks.getUnloaded());
        ListTag listTag = this.serReceivedIotas.getTag();
        if (listTag != null) {
            ListTag it = listTag;
            boolean bl = false;
            tag.m_128365_(TAG_RECEIVED_IOTAS, (Tag)it);
        }
        tag.m_128365_(TAG_TRANSMITTING_TO, this.lazyTransmittingTo.getUnloaded());
    }

    @NotNull
    public String toString() {
        return "PlayerLinkstore(player=" + this.player + ")";
    }

    @Override
    public boolean isInRange(@NotNull ILinkable<?> other) {
        return ILinkable.DefaultImpls.isInRange(this, other);
    }

    @Override
    @NotNull
    public List<Component> transmittingTargetReturnDisplay() {
        return ILinkable.DefaultImpls.transmittingTargetReturnDisplay(this);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bH\u0016J\u0014\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00000\u000bH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lram/talia/hexal/api/linkable/PlayerLinkstore$RenderCentre;", "Lram/talia/hexal/api/linkable/ILinkable$IRenderCentre;", "player", "Lnet/minecraft/world/entity/player/Player;", "(Lnet/minecraft/world/entity/player/Player;)V", "getPlayer", "()Lnet/minecraft/world/entity/player/Player;", "colouriser", "Lat/petrak/hexcasting/api/misc/FrozenColorizer;", "kotlin.jvm.PlatformType", "getLinkableType", "Lram/talia/hexal/api/linkable/LinkableRegistry$LinkableType;", "Lram/talia/hexal/api/linkable/PlayerLinkstore;", "renderCentre", "Lnet/minecraft/world/phys/Vec3;", "other", "recursioning", "", "shouldRemove", "hexal-forge-1.18.2"})
    public static final class RenderCentre
    implements ILinkable.IRenderCentre {
        @NotNull
        private final Player player;

        public RenderCentre(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            this.player = player;
        }

        @NotNull
        public final Player getPlayer() {
            return this.player;
        }

        @Override
        @NotNull
        public Vec3 renderCentre(@NotNull ILinkable.IRenderCentre other, boolean recursioning) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            if (!recursioning) {
                Vec3 vec3 = this.player.m_146892_();
                Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"player.eyePosition");
                return vec3;
            }
            Vec3 vec3 = this.player.m_146892_();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"player.eyePosition");
            Vec3 vec32 = other.renderCentre(this, false);
            Vec3 vec33 = this.player.m_146892_();
            Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"player.eyePosition");
            Vec3 vec34 = OperatorUtilsKt.minus(vec32, vec33).m_82541_();
            Intrinsics.checkNotNullExpressionValue((Object)vec34, (String)"other.renderCentre(this,\u2026.eyePosition).normalize()");
            return OperatorUtilsKt.plus(vec3, vec34);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean shouldRemove() {
            if (!this.player.m_146910_()) return false;
            Entity.RemovalReason removalReason = this.player.m_146911_();
            if (removalReason == null) return false;
            if (!removalReason.m_146965_()) return false;
            return true;
        }

        @Override
        public FrozenColorizer colouriser() {
            return IXplatAbstractions.INSTANCE.getColorizer(this.player);
        }

        @NotNull
        public LinkableRegistry.LinkableType<PlayerLinkstore, RenderCentre> getLinkableType() {
            return LinkableTypes.INSTANCE.getPLAYER_LINKSTORE_TYPE();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lram/talia/hexal/api/linkable/PlayerLinkstore$Companion;", "", "()V", "TAG_LINKS", "", "TAG_RECEIVED_IOTAS", "TAG_RENDER_LINKS", "TAG_TRANSMITTING_TO", "hexal-forge-1.18.2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

