/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.api.spell.casting;

import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.Widget;
import at.petrak.hexcasting.api.spell.casting.CastingContext;
import at.petrak.hexcasting.api.spell.casting.CastingHarness;
import at.petrak.hexcasting.api.spell.casting.ControllerInfo;
import at.petrak.hexcasting.api.utils.NBTHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ram.talia.hexal.api.HexalAPI;
import ram.talia.hexal.api.nbt.HexalNBTHelperKt;
import ram.talia.hexal.api.nbt.SerialisedIota;
import ram.talia.hexal.api.nbt.SerialisedIotaList;
import ram.talia.hexal.api.spell.casting.IMixinCastingContext;
import ram.talia.hexal.common.entities.BaseCastingWisp;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001c2\u00020\u0001:\u0003\u001c\u001d\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J2\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00172\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lram/talia/hexal/api/spell/casting/WispCastingManager;", "", "caster", "Lnet/minecraft/server/level/ServerPlayer;", "(Lnet/minecraft/server/level/ServerPlayer;)V", "queue", "Ljava/util/PriorityQueue;", "Lram/talia/hexal/api/spell/casting/WispCastingManager$WispCast;", "cast", "Lram/talia/hexal/api/spell/casting/WispCastingManager$WispCastResult;", "executeCasts", "", "readFromNbt", "tag", "Lnet/minecraft/nbt/CompoundTag;", "level", "Lnet/minecraft/server/level/ServerLevel;", "scheduleCast", "wisp", "Lram/talia/hexal/common/entities/BaseCastingWisp;", "priority", "", "hex", "Lram/talia/hexal/api/nbt/SerialisedIotaList;", "initialStack", "initialRavenmind", "Lram/talia/hexal/api/nbt/SerialisedIota;", "writeToNbt", "Companion", "WispCast", "WispCastResult", "hexal-forge-1.18.2"})
public final class WispCastingManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ServerPlayer caster;
    @NotNull
    private final PriorityQueue<WispCast> queue;
    @NotNull
    public static final String TAG_CAST_LIST = "cast_list";
    public static final int WISP_EVALS_PER_TICK = 10;
    @NotNull
    private static List<Function2<WispCastingManager, WispCast, Boolean>> specialHandlers = new ArrayList();

    public WispCastingManager(@NotNull ServerPlayer caster) {
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        this.caster = caster;
        this.queue = new PriorityQueue();
    }

    public final void scheduleCast(@NotNull BaseCastingWisp wisp, int priority, @NotNull SerialisedIotaList hex, @NotNull SerialisedIotaList initialStack, @NotNull SerialisedIota initialRavenmind) {
        boolean bl;
        WispCast cast;
        block4: {
            Intrinsics.checkNotNullParameter((Object)wisp, (String)"wisp");
            Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
            Intrinsics.checkNotNullParameter((Object)initialStack, (String)"initialStack");
            Intrinsics.checkNotNullParameter((Object)initialRavenmind, (String)"initialRavenmind");
            cast = new WispCast(wisp, priority, this.caster.f_19853_.m_46467_(), hex, initialStack, initialRavenmind);
            Iterable $this$any$iv = specialHandlers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Function2 handler = (Function2)element$iv;
                    boolean bl2 = false;
                    if (!((Boolean)handler.invoke((Object)this, (Object)cast)).booleanValue()) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        this.queue.add(cast);
    }

    public static /* synthetic */ void scheduleCast$default(WispCastingManager wispCastingManager, BaseCastingWisp baseCastingWisp, int n, SerialisedIotaList serialisedIotaList, SerialisedIotaList serialisedIotaList2, SerialisedIota serialisedIota, int n2, Object object) {
        if ((n2 & 8) != 0) {
            serialisedIotaList2 = new SerialisedIotaList(null);
        }
        if ((n2 & 0x10) != 0) {
            serialisedIota = new SerialisedIota(null);
        }
        wispCastingManager.scheduleCast(baseCastingWisp, n, serialisedIotaList, serialisedIotaList2, serialisedIota);
    }

    public final void executeCasts() {
        if (this.caster.f_19853_.f_46443_) {
            HexalAPI.LOGGER.info("HOW DID THIS HAPPEN");
            return;
        }
        int evalsLeft = 10;
        Iterator<WispCast> iterator = this.queue.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"queue.iterator()");
        Iterator<WispCast> itr = iterator;
        ArrayList results = new ArrayList();
        while (evalsLeft > 0 && itr.hasNext()) {
            WispCast cast = itr.next();
            itr.remove();
            if (cast.getWisp() == null) {
                Level level = this.caster.f_19853_;
                if (level == null) {
                    throw new NullPointerException("null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                }
                Entity entity = ((ServerLevel)level).m_8791_(cast.getWispUUID());
                cast.setWisp(entity instanceof BaseCastingWisp ? (BaseCastingWisp)entity : null);
                if (cast.getWisp() == null) continue;
            }
            BaseCastingWisp baseCastingWisp = cast.getWisp();
            Intrinsics.checkNotNull((Object)baseCastingWisp);
            if (baseCastingWisp.m_146910_()) continue;
            Collection collection = results;
            Intrinsics.checkNotNullExpressionValue((Object)cast, (String)"cast");
            collection.add(this.cast(cast));
            --evalsLeft;
        }
        Iterable $this$forEach$iv = results;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WispCastResult result = (WispCastResult)element$iv;
            boolean bl = false;
            result.callback();
        }
    }

    @NotNull
    public final WispCastResult cast(@NotNull WispCast cast) {
        IMixinCastingContext mCast;
        Intrinsics.checkNotNullParameter((Object)cast, (String)"cast");
        CastingContext ctx = new CastingContext(this.caster, InteractionHand.MAIN_HAND);
        BaseCastingWisp baseCastingWisp = cast.getWisp();
        Intrinsics.checkNotNull((Object)baseCastingWisp);
        BaseCastingWisp wisp = baseCastingWisp;
        wisp.setSummonedChildThisCast(false);
        IMixinCastingContext iMixinCastingContext = mCast = ctx instanceof IMixinCastingContext ? (IMixinCastingContext)ctx : null;
        if (iMixinCastingContext != null) {
            iMixinCastingContext.setWisp(wisp);
        }
        CastingHarness harness = new CastingHarness(ctx, null, 2, null);
        harness.setStack(CollectionsKt.toMutableList((Collection)cast.getInitialStack().get(ctx.getWorld())));
        SpellDatum spellDatum = cast.getInitialRavenmind().get(ctx.getWorld());
        if (spellDatum == null) {
            spellDatum = SpellDatum.Companion.make((Object)Widget.NULL);
        }
        harness.setLocalIota(spellDatum);
        List<SpellDatum<?>> list = cast.getHex().get(ctx.getWorld());
        ServerLevel serverLevel = this.caster.m_183503_();
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"caster.getLevel()");
        ControllerInfo info = harness.executeIotas(list, serverLevel);
        return new WispCastResult(wisp, info.getResolutionType().getSuccess(), info.getMakesCastSound(), harness.getStack(), harness.getLocalIota());
    }

    public final void readFromNbt(@Nullable CompoundTag tag, @NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        CompoundTag compoundTag = tag;
        Tag tag2 = compoundTag != null ? compoundTag.m_128423_(TAG_CAST_LIST) : null;
        ListTag listTag = tag2 instanceof ListTag ? (ListTag)tag2 : null;
        if (listTag == null) {
            return;
        }
        ListTag list = listTag;
        for (Tag castTag : list) {
            Intrinsics.checkNotNullExpressionValue((Object)castTag, (String)"castTag");
            this.queue.add(WispCast.Companion.makeFromNbt(NBTHelper.getAsCompound((Tag)castTag), level));
        }
    }

    public final void writeToNbt(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        ListTag list = new ListTag();
        for (WispCast cast : this.queue) {
            list.add((Object)cast.writeToNbt());
        }
        tag.m_128365_(TAG_CAST_LIST, (Tag)list);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 12\b\u0012\u0004\u0012\u00020\u00000\u0001:\u00011B7\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rB9\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0010J\u0011\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0000H\u0096\u0002J\t\u0010\"\u001a\u00020\u000fH\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u0007H\u00c6\u0003J\t\u0010%\u001a\u00020\tH\u00c6\u0003J\t\u0010&\u001a\u00020\tH\u00c6\u0003J\t\u0010'\u001a\u00020\fH\u00c6\u0003JE\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010)\u001a\u00020*2\b\u0010!\u001a\u0004\u0018\u00010+H\u00d6\u0003J\t\u0010,\u001a\u00020\u0005H\u00d6\u0001J\t\u0010-\u001a\u00020.H\u00d6\u0001J\u0006\u0010/\u001a\u000200R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00062"}, d2={"Lram/talia/hexal/api/spell/casting/WispCastingManager$WispCast;", "", "wisp", "Lram/talia/hexal/common/entities/BaseCastingWisp;", "priority", "", "timeAdded", "", "hex", "Lram/talia/hexal/api/nbt/SerialisedIotaList;", "initialStack", "initialRavenmind", "Lram/talia/hexal/api/nbt/SerialisedIota;", "(Lram/talia/hexal/common/entities/BaseCastingWisp;IJLram/talia/hexal/api/nbt/SerialisedIotaList;Lram/talia/hexal/api/nbt/SerialisedIotaList;Lram/talia/hexal/api/nbt/SerialisedIota;)V", "wispUUID", "Ljava/util/UUID;", "(Ljava/util/UUID;IJLram/talia/hexal/api/nbt/SerialisedIotaList;Lram/talia/hexal/api/nbt/SerialisedIotaList;Lram/talia/hexal/api/nbt/SerialisedIota;)V", "getHex", "()Lram/talia/hexal/api/nbt/SerialisedIotaList;", "getInitialRavenmind", "()Lram/talia/hexal/api/nbt/SerialisedIota;", "getInitialStack", "getPriority", "()I", "getTimeAdded", "()J", "getWisp", "()Lram/talia/hexal/common/entities/BaseCastingWisp;", "setWisp", "(Lram/talia/hexal/common/entities/BaseCastingWisp;)V", "getWispUUID", "()Ljava/util/UUID;", "compareTo", "other", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "", "hashCode", "toString", "", "writeToNbt", "Lnet/minecraft/nbt/CompoundTag;", "Companion", "hexal-forge-1.18.2"})
    public static final class WispCast
    implements Comparable<WispCast> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final UUID wispUUID;
        private final int priority;
        private final long timeAdded;
        @NotNull
        private final SerialisedIotaList hex;
        @NotNull
        private final SerialisedIotaList initialStack;
        @NotNull
        private final SerialisedIota initialRavenmind;
        @Nullable
        private BaseCastingWisp wisp;
        @NotNull
        public static final String TAG_WISP = "wisp";
        @NotNull
        public static final String TAG_PRIORITY = "priority";
        @NotNull
        public static final String TAG_TIME_ADDED = "time_added";
        @NotNull
        public static final String TAG_HEX = "hex";
        @NotNull
        public static final String TAG_INITIAL_STACK = "initial_stack";
        @NotNull
        public static final String TAG_INITIAL_RAVENMIND = "initial_ravenmind";

        public WispCast(@NotNull UUID wispUUID, int priority, long timeAdded, @NotNull SerialisedIotaList hex, @NotNull SerialisedIotaList initialStack, @NotNull SerialisedIota initialRavenmind) {
            Intrinsics.checkNotNullParameter((Object)wispUUID, (String)"wispUUID");
            Intrinsics.checkNotNullParameter((Object)hex, (String)TAG_HEX);
            Intrinsics.checkNotNullParameter((Object)initialStack, (String)"initialStack");
            Intrinsics.checkNotNullParameter((Object)initialRavenmind, (String)"initialRavenmind");
            this.wispUUID = wispUUID;
            this.priority = priority;
            this.timeAdded = timeAdded;
            this.hex = hex;
            this.initialStack = initialStack;
            this.initialRavenmind = initialRavenmind;
        }

        public /* synthetic */ WispCast(UUID uUID, int n, long l, SerialisedIotaList serialisedIotaList, SerialisedIotaList serialisedIotaList2, SerialisedIota serialisedIota, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 0x10) != 0) {
                serialisedIotaList2 = new SerialisedIotaList(null);
            }
            if ((n2 & 0x20) != 0) {
                serialisedIota = new SerialisedIota(null);
            }
            this(uUID, n, l, serialisedIotaList, serialisedIotaList2, serialisedIota);
        }

        @NotNull
        public final UUID getWispUUID() {
            return this.wispUUID;
        }

        public final int getPriority() {
            return this.priority;
        }

        public final long getTimeAdded() {
            return this.timeAdded;
        }

        @NotNull
        public final SerialisedIotaList getHex() {
            return this.hex;
        }

        @NotNull
        public final SerialisedIotaList getInitialStack() {
            return this.initialStack;
        }

        @NotNull
        public final SerialisedIota getInitialRavenmind() {
            return this.initialRavenmind;
        }

        @Nullable
        public final BaseCastingWisp getWisp() {
            return this.wisp;
        }

        public final void setWisp(@Nullable BaseCastingWisp baseCastingWisp) {
            this.wisp = baseCastingWisp;
        }

        public WispCast(@NotNull BaseCastingWisp wisp, int priority, long timeAdded, @NotNull SerialisedIotaList hex, @NotNull SerialisedIotaList initialStack, @NotNull SerialisedIota initialRavenmind) {
            Intrinsics.checkNotNullParameter((Object)wisp, (String)TAG_WISP);
            Intrinsics.checkNotNullParameter((Object)hex, (String)TAG_HEX);
            Intrinsics.checkNotNullParameter((Object)initialStack, (String)"initialStack");
            Intrinsics.checkNotNullParameter((Object)initialRavenmind, (String)"initialRavenmind");
            UUID uUID = wisp.m_142081_();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"wisp.uuid");
            this(uUID, priority, timeAdded, hex, initialStack, initialRavenmind);
            this.wisp = wisp;
        }

        @Override
        public int compareTo(@NotNull WispCast other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            if (this.priority != other.priority) {
                return this.priority - other.priority;
            }
            return (int)(this.timeAdded - other.timeAdded);
        }

        @NotNull
        public final CompoundTag writeToNbt() {
            CompoundTag tag;
            block2: {
                ListTag it;
                tag = new CompoundTag();
                tag.m_128362_(TAG_WISP, this.wispUUID);
                tag.m_128405_(TAG_PRIORITY, this.priority);
                tag.m_128356_(TAG_TIME_ADDED, this.timeAdded);
                ListTag listTag = this.hex.getTag();
                if (listTag != null) {
                    it = listTag;
                    boolean bl = false;
                    tag.m_128365_(TAG_HEX, (Tag)it);
                }
                ListTag listTag2 = this.initialStack.getTag();
                if (listTag2 != null) {
                    it = listTag2;
                    boolean bl = false;
                    tag.m_128365_(TAG_INITIAL_STACK, (Tag)it);
                }
                CompoundTag compoundTag = this.initialRavenmind.getTag();
                if (compoundTag == null) break block2;
                it = compoundTag;
                boolean bl = false;
                NBTHelper.putCompound((CompoundTag)tag, (String)TAG_INITIAL_RAVENMIND, (CompoundTag)it);
            }
            return tag;
        }

        @NotNull
        public final UUID component1() {
            return this.wispUUID;
        }

        public final int component2() {
            return this.priority;
        }

        public final long component3() {
            return this.timeAdded;
        }

        @NotNull
        public final SerialisedIotaList component4() {
            return this.hex;
        }

        @NotNull
        public final SerialisedIotaList component5() {
            return this.initialStack;
        }

        @NotNull
        public final SerialisedIota component6() {
            return this.initialRavenmind;
        }

        @NotNull
        public final WispCast copy(@NotNull UUID wispUUID, int priority, long timeAdded, @NotNull SerialisedIotaList hex, @NotNull SerialisedIotaList initialStack, @NotNull SerialisedIota initialRavenmind) {
            Intrinsics.checkNotNullParameter((Object)wispUUID, (String)"wispUUID");
            Intrinsics.checkNotNullParameter((Object)hex, (String)TAG_HEX);
            Intrinsics.checkNotNullParameter((Object)initialStack, (String)"initialStack");
            Intrinsics.checkNotNullParameter((Object)initialRavenmind, (String)"initialRavenmind");
            return new WispCast(wispUUID, priority, timeAdded, hex, initialStack, initialRavenmind);
        }

        public static /* synthetic */ WispCast copy$default(WispCast wispCast, UUID uUID, int n, long l, SerialisedIotaList serialisedIotaList, SerialisedIotaList serialisedIotaList2, SerialisedIota serialisedIota, int n2, Object object) {
            if ((n2 & 1) != 0) {
                uUID = wispCast.wispUUID;
            }
            if ((n2 & 2) != 0) {
                n = wispCast.priority;
            }
            if ((n2 & 4) != 0) {
                l = wispCast.timeAdded;
            }
            if ((n2 & 8) != 0) {
                serialisedIotaList = wispCast.hex;
            }
            if ((n2 & 0x10) != 0) {
                serialisedIotaList2 = wispCast.initialStack;
            }
            if ((n2 & 0x20) != 0) {
                serialisedIota = wispCast.initialRavenmind;
            }
            return wispCast.copy(uUID, n, l, serialisedIotaList, serialisedIotaList2, serialisedIota);
        }

        @NotNull
        public String toString() {
            return "WispCast(wispUUID=" + this.wispUUID + ", priority=" + this.priority + ", timeAdded=" + this.timeAdded + ", hex=" + this.hex + ", initialStack=" + this.initialStack + ", initialRavenmind=" + this.initialRavenmind + ")";
        }

        public int hashCode() {
            int result = this.wispUUID.hashCode();
            result = result * 31 + Integer.hashCode(this.priority);
            result = result * 31 + Long.hashCode(this.timeAdded);
            result = result * 31 + this.hex.hashCode();
            result = result * 31 + this.initialStack.hashCode();
            result = result * 31 + this.initialRavenmind.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WispCast)) {
                return false;
            }
            WispCast wispCast = (WispCast)other;
            if (!Intrinsics.areEqual((Object)this.wispUUID, (Object)wispCast.wispUUID)) {
                return false;
            }
            if (this.priority != wispCast.priority) {
                return false;
            }
            if (this.timeAdded != wispCast.timeAdded) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.hex, (Object)wispCast.hex)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.initialStack, (Object)wispCast.initialStack)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.initialRavenmind, (Object)wispCast.initialRavenmind);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lram/talia/hexal/api/spell/casting/WispCastingManager$WispCast$Companion;", "", "()V", "TAG_HEX", "", "TAG_INITIAL_RAVENMIND", "TAG_INITIAL_STACK", "TAG_PRIORITY", "TAG_TIME_ADDED", "TAG_WISP", "makeFromNbt", "Lram/talia/hexal/api/spell/casting/WispCastingManager$WispCast;", "tag", "Lnet/minecraft/nbt/CompoundTag;", "level", "Lnet/minecraft/server/level/ServerLevel;", "hexal-forge-1.18.2"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final WispCast makeFromNbt(@NotNull CompoundTag tag, @NotNull ServerLevel level) {
                BaseCastingWisp wisp;
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                UUID wispUUID = tag.m_128342_(WispCast.TAG_WISP);
                Entity entity = level.m_8791_(wispUUID);
                BaseCastingWisp baseCastingWisp = wisp = entity instanceof BaseCastingWisp ? (BaseCastingWisp)entity : null;
                if (wisp != null) {
                    entity = tag.m_128423_(WispCast.TAG_HEX);
                    SerialisedIotaList serialisedIotaList = new SerialisedIotaList(entity instanceof ListTag ? (ListTag)entity : null);
                    entity = tag.m_128423_(WispCast.TAG_INITIAL_STACK);
                    SerialisedIotaList serialisedIotaList2 = new SerialisedIotaList(entity instanceof ListTag ? (ListTag)entity : null);
                    entity = tag.m_128423_(WispCast.TAG_INITIAL_RAVENMIND);
                    return new WispCast(wisp, tag.m_128451_(WispCast.TAG_PRIORITY), tag.m_128454_(WispCast.TAG_TIME_ADDED), serialisedIotaList, serialisedIotaList2, new SerialisedIota(entity instanceof CompoundTag ? (CompoundTag)entity : null));
                }
                UUID uUID = tag.m_128342_(WispCast.TAG_WISP);
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"tag.getUUID(TAG_WISP)");
                entity = tag.m_128423_(WispCast.TAG_HEX);
                SerialisedIotaList serialisedIotaList = new SerialisedIotaList(entity instanceof ListTag ? (ListTag)entity : null);
                entity = tag.m_128423_(WispCast.TAG_INITIAL_STACK);
                SerialisedIotaList serialisedIotaList3 = new SerialisedIotaList(entity instanceof ListTag ? (ListTag)entity : null);
                entity = tag.m_128423_(WispCast.TAG_INITIAL_RAVENMIND);
                return new WispCast(uUID, tag.m_128451_(WispCast.TAG_PRIORITY), tag.m_128454_(WispCast.TAG_TIME_ADDED), serialisedIotaList, serialisedIotaList3, new SerialisedIota(entity instanceof CompoundTag ? (CompoundTag)entity : null));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B?\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\f\u0012\u0006\u0010\n\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u0018\u001a\u00020\u0019J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\fH\u00c6\u0003J\t\u0010\u001e\u001a\u00020\rH\u00c6\u0003J;\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\f2\b\b\u0002\u0010\n\u001a\u00020\rH\u00c6\u0001J\u0013\u0010 \u001a\u00020\u00052\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020%H\u00d6\u0001R\u0011\u0010\n\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006&"}, d2={"Lram/talia/hexal/api/spell/casting/WispCastingManager$WispCastResult;", "", "wisp", "Lram/talia/hexal/common/entities/BaseCastingWisp;", "succeeded", "", "makesCastSound", "endStack", "", "Lat/petrak/hexcasting/api/spell/SpellDatum;", "endRavenmind", "(Lram/talia/hexal/common/entities/BaseCastingWisp;ZZLjava/util/List;Lat/petrak/hexcasting/api/spell/SpellDatum;)V", "Lram/talia/hexal/api/nbt/SerialisedIotaList;", "Lram/talia/hexal/api/nbt/SerialisedIota;", "(Lram/talia/hexal/common/entities/BaseCastingWisp;ZZLram/talia/hexal/api/nbt/SerialisedIotaList;Lram/talia/hexal/api/nbt/SerialisedIota;)V", "getEndRavenmind", "()Lram/talia/hexal/api/nbt/SerialisedIota;", "getEndStack", "()Lram/talia/hexal/api/nbt/SerialisedIotaList;", "getMakesCastSound", "()Z", "getSucceeded", "getWisp", "()Lram/talia/hexal/common/entities/BaseCastingWisp;", "callback", "", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "", "hexal-forge-1.18.2"})
    public static final class WispCastResult {
        @NotNull
        private final BaseCastingWisp wisp;
        private final boolean succeeded;
        private final boolean makesCastSound;
        @NotNull
        private final SerialisedIotaList endStack;
        @NotNull
        private final SerialisedIota endRavenmind;

        public WispCastResult(@NotNull BaseCastingWisp wisp, boolean succeeded, boolean makesCastSound, @NotNull SerialisedIotaList endStack, @NotNull SerialisedIota endRavenmind) {
            Intrinsics.checkNotNullParameter((Object)wisp, (String)"wisp");
            Intrinsics.checkNotNullParameter((Object)endStack, (String)"endStack");
            Intrinsics.checkNotNullParameter((Object)endRavenmind, (String)"endRavenmind");
            this.wisp = wisp;
            this.succeeded = succeeded;
            this.makesCastSound = makesCastSound;
            this.endStack = endStack;
            this.endRavenmind = endRavenmind;
        }

        @NotNull
        public final BaseCastingWisp getWisp() {
            return this.wisp;
        }

        public final boolean getSucceeded() {
            return this.succeeded;
        }

        public final boolean getMakesCastSound() {
            return this.makesCastSound;
        }

        @NotNull
        public final SerialisedIotaList getEndStack() {
            return this.endStack;
        }

        @NotNull
        public final SerialisedIota getEndRavenmind() {
            return this.endRavenmind;
        }

        public WispCastResult(@NotNull BaseCastingWisp wisp, boolean succeeded, boolean makesCastSound, @NotNull List<? extends SpellDatum<?>> endStack, @Nullable SpellDatum<?> endRavenmind) {
            Intrinsics.checkNotNullParameter((Object)wisp, (String)"wisp");
            Intrinsics.checkNotNullParameter(endStack, (String)"endStack");
            SpellDatum<?> spellDatum = endRavenmind;
            this(wisp, succeeded, makesCastSound, new SerialisedIotaList(HexalNBTHelperKt.toNbtListSpellDatum(endStack)), new SerialisedIota((CompoundTag)(spellDatum != null ? spellDatum.serializeToNBT() : null)));
        }

        public final void callback() {
            this.wisp.castCallback(this);
        }

        @NotNull
        public final BaseCastingWisp component1() {
            return this.wisp;
        }

        public final boolean component2() {
            return this.succeeded;
        }

        public final boolean component3() {
            return this.makesCastSound;
        }

        @NotNull
        public final SerialisedIotaList component4() {
            return this.endStack;
        }

        @NotNull
        public final SerialisedIota component5() {
            return this.endRavenmind;
        }

        @NotNull
        public final WispCastResult copy(@NotNull BaseCastingWisp wisp, boolean succeeded, boolean makesCastSound, @NotNull SerialisedIotaList endStack, @NotNull SerialisedIota endRavenmind) {
            Intrinsics.checkNotNullParameter((Object)wisp, (String)"wisp");
            Intrinsics.checkNotNullParameter((Object)endStack, (String)"endStack");
            Intrinsics.checkNotNullParameter((Object)endRavenmind, (String)"endRavenmind");
            return new WispCastResult(wisp, succeeded, makesCastSound, endStack, endRavenmind);
        }

        public static /* synthetic */ WispCastResult copy$default(WispCastResult wispCastResult, BaseCastingWisp baseCastingWisp, boolean bl, boolean bl2, SerialisedIotaList serialisedIotaList, SerialisedIota serialisedIota, int n, Object object) {
            if ((n & 1) != 0) {
                baseCastingWisp = wispCastResult.wisp;
            }
            if ((n & 2) != 0) {
                bl = wispCastResult.succeeded;
            }
            if ((n & 4) != 0) {
                bl2 = wispCastResult.makesCastSound;
            }
            if ((n & 8) != 0) {
                serialisedIotaList = wispCastResult.endStack;
            }
            if ((n & 0x10) != 0) {
                serialisedIota = wispCastResult.endRavenmind;
            }
            return wispCastResult.copy(baseCastingWisp, bl, bl2, serialisedIotaList, serialisedIota);
        }

        @NotNull
        public String toString() {
            return "WispCastResult(wisp=" + this.wisp + ", succeeded=" + this.succeeded + ", makesCastSound=" + this.makesCastSound + ", endStack=" + this.endStack + ", endRavenmind=" + this.endRavenmind + ")";
        }

        public int hashCode() {
            int result = this.wisp.hashCode();
            int n = this.succeeded ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            int n2 = this.makesCastSound ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result = result * 31 + n2;
            result = result * 31 + this.endStack.hashCode();
            result = result * 31 + this.endRavenmind.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WispCastResult)) {
                return false;
            }
            WispCastResult wispCastResult = (WispCastResult)other;
            if (!Intrinsics.areEqual((Object)this.wisp, (Object)wispCastResult.wisp)) {
                return false;
            }
            if (this.succeeded != wispCastResult.succeeded) {
                return false;
            }
            if (this.makesCastSound != wispCastResult.makesCastSound) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.endStack, (Object)wispCastResult.endStack)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.endRavenmind, (Object)wispCastResult.endRavenmind);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\t0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lram/talia/hexal/api/spell/casting/WispCastingManager$Companion;", "", "()V", "TAG_CAST_LIST", "", "WISP_EVALS_PER_TICK", "", "specialHandlers", "", "Lkotlin/Function2;", "Lram/talia/hexal/api/spell/casting/WispCastingManager;", "Lram/talia/hexal/api/spell/casting/WispCastingManager$WispCast;", "", "getSpecialHandlers", "()Ljava/util/List;", "setSpecialHandlers", "(Ljava/util/List;)V", "hexal-forge-1.18.2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Function2<WispCastingManager, WispCast, Boolean>> getSpecialHandlers() {
            return specialHandlers;
        }

        public final void setSpecialHandlers(@NotNull List<Function2<WispCastingManager, WispCast, Boolean>> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            specialHandlers = list;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

