/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.common.blocks.entity;

import at.petrak.hexcasting.api.block.HexBlockEntity;
import at.petrak.hexcasting.api.misc.FrozenColorizer;
import at.petrak.hexcasting.common.lib.HexItems;
import java.util.Collection;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import ram.talia.hexal.common.entities.WanderingWisp;
import ram.talia.hexal.common.lib.HexalBlockEntities;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0017\u001a\u00020\u0012H\u0002J\u0006\u0010\u0018\u001a\u00020\u0012R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lram/talia/hexal/common/blocks/entity/BlockEntitySlipway;", "Lat/petrak/hexcasting/api/block/HexBlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "isActive", "", "nextSpawnTick", "", "getPos", "()Lnet/minecraft/core/BlockPos;", "random", "Ljava/util/Random;", "getState", "()Lnet/minecraft/world/level/block/state/BlockState;", "clientTick", "", "loadModData", "tag", "Lnet/minecraft/nbt/CompoundTag;", "saveModData", "serverTick", "tick", "Companion", "hexal-forge-1.18.2"})
public final class BlockEntitySlipway
extends HexBlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockPos pos;
    @NotNull
    private final BlockState state;
    @NotNull
    private Random random;
    private boolean isActive;
    private long nextSpawnTick;
    @NotNull
    public static final String TAG_IS_ACTIVE = "is_active";
    @NotNull
    public static final String TAG_NEXT_SPAWN_TICK = "last_spawned_tick";
    public static final double ACTIVE_RANGE = 5.0;
    public static final int SPAWN_INTERVAL_MU = 80;
    public static final int SPAWN_INTERVAL_SIG = 10;
    @NotNull
    private static final Random RANDOM = new Random();

    public BlockEntitySlipway(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(HexalBlockEntities.SLIPWAY, pos, state);
        this.pos = pos;
        this.state = state;
        this.random = new Random();
    }

    @NotNull
    public final BlockPos getPos() {
        return this.pos;
    }

    @NotNull
    public final BlockState getState() {
        return this.state;
    }

    public final void tick() {
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_) {
            this.clientTick();
        } else {
            this.serverTick();
        }
    }

    private final void clientTick() {
    }

    private final void serverTick() {
        if (!this.isActive) {
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level);
            if (level.m_45914_((double)this.pos.m_123341_(), (double)this.pos.m_123342_(), (double)this.pos.m_123343_(), 5.0)) {
                this.isActive = true;
                this.sync();
            }
            return;
        }
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        long tick = level.m_46467_();
        if (tick >= this.nextSpawnTick) {
            this.nextSpawnTick = tick + (long)this.random.nextGaussian(80.0, 10.0);
            FrozenColorizer colouriser = Companion.getRandomColouriser();
            Level level2 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level2);
            Vec3 vec3 = Vec3.m_82512_((Vec3i)((Vec3i)this.pos));
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"atCenterOf(pos)");
            WanderingWisp wisp = new WanderingWisp(level2, vec3);
            wisp.setColouriser(colouriser);
            Level level3 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level3);
            level3.m_7967_((Entity)wisp);
            this.sync();
        }
    }

    protected void saveModData(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        tag.m_128379_(TAG_IS_ACTIVE, this.isActive);
        tag.m_128356_(TAG_NEXT_SPAWN_TICK, this.nextSpawnTick);
    }

    protected void loadModData(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.isActive = tag.m_128471_(TAG_IS_ACTIVE);
        this.nextSpawnTick = tag.m_128454_(TAG_NEXT_SPAWN_TICK);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lram/talia/hexal/common/blocks/entity/BlockEntitySlipway$Companion;", "", "()V", "ACTIVE_RANGE", "", "RANDOM", "Ljava/util/Random;", "getRANDOM", "()Ljava/util/Random;", "SPAWN_INTERVAL_MU", "", "SPAWN_INTERVAL_SIG", "TAG_IS_ACTIVE", "", "TAG_NEXT_SPAWN_TICK", "getRandomColouriser", "Lat/petrak/hexcasting/api/misc/FrozenColorizer;", "hexal-forge-1.18.2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Random getRANDOM() {
            return RANDOM;
        }

        @NotNull
        public final FrozenColorizer getRandomColouriser() {
            Collection collection = HexItems.DYE_COLORIZERS.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"DYE_COLORIZERS.values");
            return new FrozenColorizer(new ItemStack((ItemLike)CollectionsKt.elementAt((Iterable)collection, (int)this.getRANDOM().nextInt(HexItems.DYE_COLORIZERS.size()))), Util.f_137441_);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

